/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.ReaperServant;
import com.Polarice3.Goety.common.entities.ally.undead.WraithServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.StrayServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.VanguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.BlackguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.IceSpike;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AbstractCairnNecromancer
extends AbstractNecromancer {
    public AbstractCairnNecromancer(EntityType<? extends AbstractSkeletonServant> type, Level level) {
        super(type, level);
    }

    @Override
    public void projectileGoal(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new AbstractNecromancer.NecromancerRangedGoal(this, 1.0, 20, 10.0f));
    }

    @Override
    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new SummonServantSpell());
        this.f_21345_.m_25352_(priority + 1, (Goal)new AbstractNecromancer.SummonUndeadGoal(this));
    }

    public float m_6100_() {
        return 0.75f;
    }

    @Override
    public void m_6504_(@NotNull LivingEntity p_33317_, float p_33318_) {
        if (this.getNecroLevel() <= 0) {
            IceSpike iceSpike = new IceSpike((LivingEntity)this, this.f_19853_);
            double d0 = p_33317_.m_20185_() - this.m_20185_();
            double d1 = p_33317_.m_20227_(0.3333333333333333) - iceSpike.m_20186_();
            double d2 = p_33317_.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            iceSpike.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
            if (this.f_19853_.m_7967_((Entity)iceSpike)) {
                this.m_216990_((SoundEvent)ModSounds.ICE_SPIKE_CAST.get());
                this.m_6674_(InteractionHand.MAIN_HAND);
            }
        } else {
            for (int i = -this.getNecroLevel(); i <= this.getNecroLevel(); ++i) {
                Vec3 vector3d = this.m_20252_(1.0f);
                IceSpike iceSpike = new IceSpike((LivingEntity)this, this.f_19853_);
                iceSpike.m_6686_(vector3d.f_82479_ + (double)((float)i / 10.0f), vector3d.f_82480_, vector3d.f_82481_ + (double)((float)i / 10.0f), 1.6f, 1.0f);
                if (!this.f_19853_.m_7967_((Entity)iceSpike)) continue;
                this.m_216990_((SoundEvent)ModSounds.ICE_SPIKE_CAST.get());
                this.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }

    @Override
    public Summoned getDefaultSummon() {
        return new SkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.STRAY_SERVANT.get()), this.f_19853_);
    }

    @Override
    public Summoned getSummon() {
        Summoned summoned = this.getDefaultSummon();
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.ZOMBIE_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new ZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.FROZEN_ZOMBIE_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.SKELETON_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new StrayServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.STRAY_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.WRAITH_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new WraithServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.WRAITH_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.REAPER_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new ReaperServant((EntityType<? extends Owned>)((EntityType)ModEntityType.REAPER_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.VANGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.15f) {
            summoned = new VanguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.VANGUARD_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.BLACKGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new BlackguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.BLACKGUARD_SERVANT.get()), this.f_19853_);
        }
        return summoned;
    }

    @Override
    public boolean summonVariants() {
        return this.f_19853_.m_46801_(this.m_20183_());
    }

    public class SummonServantSpell
    extends AbstractNecromancer.SummoningSpellGoal {
        public SummonServantSpell() {
            super(AbstractCairnNecromancer.this);
        }

        @Override
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == AbstractCairnNecromancer.this;
            };
            int i = AbstractCairnNecromancer.this.f_19853_.m_6443_(LivingEntity.class, AbstractCairnNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 6;
        }

        @Override
        protected void castSpell() {
            Level level = AbstractCairnNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 2; ++i1) {
                    Summoned summonedentity = AbstractCairnNecromancer.this.getSummon();
                    BlockPos blockPos = BlockFinder.SummonRadius(AbstractCairnNecromancer.this.m_20183_(), (Entity)summonedentity, (Level)serverLevel);
                    summonedentity.setTrueOwner((LivingEntity)AbstractCairnNecromancer.this);
                    summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    if (((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                        summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(AbstractCairnNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (BlockFinder.findStructure(serverLevel, (LivingEntity)AbstractCairnNecromancer.this, ModTags.Structures.CRYPT)) {
                        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                            Item item;
                            ItemStack itemstack;
                            if (equipmentslottype.m_20743_() == EquipmentSlot.Type.ARMOR && (itemstack = summonedentity.m_6844_(equipmentslottype)).m_41619_() && (item = this.cursedKnightArmor(equipmentslottype)) != null && serverLevel.f_46441_.m_188501_() <= 0.25f) {
                                summonedentity.m_8061_(equipmentslottype, new ItemStack((ItemLike)item));
                            }
                            summonedentity.m_21409_(equipmentslottype, 0.0f);
                        }
                        summonedentity.m_21008_(InteractionHand.MAIN_HAND, Items.f_42383_.m_7968_());
                        summonedentity.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                    }
                    if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                    SoundUtil.playNecromancerSummon((Entity)summonedentity);
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 0.1f, 0.1f, 0.05f, -1, summonedentity.m_20182_());
                }
            }
        }

        @Nullable
        public Item cursedKnightArmor(EquipmentSlot pSlot) {
            return switch (pSlot) {
                case EquipmentSlot.HEAD -> Items.f_42464_;
                case EquipmentSlot.CHEST -> (Item)ModItems.CURSED_KNIGHT_CHESTPLATE.get();
                case EquipmentSlot.LEGS -> Items.f_42466_;
                case EquipmentSlot.FEET -> (Item)ModItems.CURSED_KNIGHT_BOOTS.get();
                default -> null;
            };
        }

        @Override
        protected AbstractNecromancer.NecromancerSpellType getNecromancerSpellType() {
            return AbstractNecromancer.NecromancerSpellType.ZOMBIE;
        }
    }
}

