/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.LookAtTargetGoal;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.neutral.AbstractVine;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.PoisonQuill;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PoisonQuillVine
extends AbstractVine {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(PoisonQuillVine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int openTick = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public AnimationState burstAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();
    public AnimationState holdAnimationState = new AnimationState();
    public AnimationState openAnimationState = new AnimationState();
    public AnimationState closeAnimationState = new AnimationState();
    public AnimationState targetAnimationState = new AnimationState();
    public AnimationState docileAnimationState = new AnimationState();

    public PoisonQuillVine(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new QuillRangedGoal(this, 14.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal((Mob)this, 16.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.PoisonQuillVineHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.PoisonQuillVineArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.PoisonQuillVineDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.PoisonQuillVineHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.PoisonQuillVineArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.PoisonQuillVineDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag p_31485_) {
        super.m_7380_(p_31485_);
        p_31485_.m_128405_("Animation", this.getCurrentAnimation());
    }

    @Override
    public void m_7378_(CompoundTag p_31474_) {
        super.m_7378_(p_31474_);
        if (p_31474_.m_128441_("Animation")) {
            this.setAnimationState(p_31474_.m_128451_("Animation"));
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "shoot")) {
            return 2;
        }
        if (Objects.equals(animation, "burst")) {
            return 3;
        }
        if (Objects.equals(animation, "burrow")) {
            return 4;
        }
        if (Objects.equals(animation, "hold")) {
            return 5;
        }
        if (Objects.equals(animation, "open")) {
            return 6;
        }
        if (Objects.equals(animation, "close")) {
            return 7;
        }
        if (Objects.equals(animation, "target")) {
            return 8;
        }
        if (Objects.equals(animation, "docile")) {
            return 9;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.shootAnimationState);
        list.add(this.burstAnimationState);
        list.add(this.burrowAnimationState);
        list.add(this.holdAnimationState);
        list.add(this.openAnimationState);
        list.add(this.closeAnimationState);
        list.add(this.targetAnimationState);
        list.add(this.docileAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopNoneIdleAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception || state == this.idleAnimationState) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.shootAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                    break;
                }
                case 3: {
                    this.burstAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.burstAnimationState);
                    break;
                }
                case 4: {
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.burrowAnimationState);
                    break;
                }
                case 5: {
                    this.holdAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.holdAnimationState);
                    break;
                }
                case 6: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.openAnimationState.m_216977_(this.f_19797_);
                    this.stopNoneIdleAnimation(this.openAnimationState);
                    break;
                }
                case 7: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.closeAnimationState.m_216977_(this.f_19797_);
                    this.stopNoneIdleAnimation(this.closeAnimationState);
                    break;
                }
                case 8: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.targetAnimationState.m_216982_(this.f_19797_);
                    this.stopNoneIdleAnimation(this.targetAnimationState);
                    break;
                }
                case 9: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.docileAnimationState.m_216982_(this.f_19797_);
                    this.stopNoneIdleAnimation(this.docileAnimationState);
                }
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason != MobSpawnType.MOB_SUMMONED) {
            this.setPerpetual(true);
        }
        this.setAnimationState("hold");
        return pSpawnData;
    }

    @Override
    public void initRotate() {
    }

    @Override
    @Nullable
    public EntityType<?> getVariant(@Nullable Player player, Level level, BlockPos blockPos) {
        if (level.m_46801_(blockPos) || level.m_46801_(blockPos.m_7494_())) {
            return (EntityType)ModEntityType.POISON_ANEMONE.get();
        }
        return super.getVariant(player, level, blockPos);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.POISON_QUILL_VINE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)ModSounds.POISON_QUILL_VINE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.POISON_QUILL_VINE_DEATH.get();
    }

    @Override
    protected SoundEvent getBurstSound() {
        return (SoundEvent)ModSounds.POISON_QUILL_VINE_BURST.get();
    }

    @Override
    protected SoundEvent getBurrowSound() {
        return (SoundEvent)ModSounds.POISON_QUILL_VINE_BURST.get();
    }

    protected SoundEvent getCloseSound() {
        return (SoundEvent)ModSounds.POISON_QUILL_VINE_CLOSE.get();
    }

    protected SoundEvent getOpenSound() {
        return (SoundEvent)ModSounds.POISON_QUILL_VINE_OPEN.get();
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50191_.m_49966_();
    }

    public static float getEmergingTime() {
        return MathHelper.secondsToTicks(1.25f);
    }

    @Override
    public boolean isEmerging() {
        return (float)this.getAge() < PoisonQuillVine.getEmergingTime() && !this.isActivate();
    }

    @Override
    public boolean m_20164_() {
        return (float)this.getAge() < PoisonQuillVine.getEmergingTime() && this.isActivate();
    }

    public void shootQuill(@NotNull LivingEntity target) {
        PoisonQuill quill = new PoisonQuill(this.f_19853_, (LivingEntity)this);
        Vec3 vector3d = this.m_20252_(1.0f);
        quill.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20188_(), this.m_20189_() + vector3d.f_82481_);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - quill.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        quill.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
        if (this.f_19853_.m_7967_((Entity)quill)) {
            this.m_216990_((SoundEvent)ModSounds.POISON_QUILL_VINE_SHOOT.get());
        }
    }

    @Override
    protected AABB getTargetSearchArea() {
        return this.m_20191_().m_82377_(8.0, 4.0, 8.0);
    }

    @Override
    public boolean canTarget() {
        return true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.getCurrentAnimation() == this.getAnimationState("target") && this.m_5448_() == null) {
                this.setAnimationState("close");
                this.m_216990_(this.getCloseSound());
            }
            if (this.getCurrentAnimation() == this.getAnimationState("close")) {
                ++this.openTick;
                if (this.openTick > 20) {
                    this.openTick = 0;
                    this.setAnimationState("docile");
                }
            }
            if (this.getCurrentAnimation() == this.getAnimationState("docile") && this.m_5448_() != null) {
                this.setAnimationState("open");
                this.m_216990_(this.getOpenSound());
            }
            if (this.getCurrentAnimation() == this.getAnimationState("open")) {
                ++this.openTick;
                if (this.openTick > 20) {
                    this.openTick = 0;
                    this.setAnimationState("target");
                }
            }
        }
    }

    @Override
    public void burst() {
        super.burst();
        if (this.activeTick < 25 && this.getCurrentAnimation() != this.getAnimationState("burst")) {
            this.setAnimationState("burst");
            this.m_5496_(this.getBurstSound(), 2.0f, 1.0f);
        } else if (this.activeTick == 25) {
            this.setAnimationState("docile");
        }
    }

    @Override
    public void burrow() {
        super.burrow();
        this.setAnimationState("burrow");
        this.m_5496_(this.getBurrowSound(), 2.0f, 1.0f);
    }

    @Override
    public EntityDimensions m_6972_(Pose p_33113_) {
        float i = (float)this.getAge() / PoisonQuillVine.getEmergingTime();
        EntityDimensions entitydimensions = this.m_6095_().m_20680_();
        return entitydimensions.m_20390_(1.0f, i);
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack((ItemLike)ModItems.POISON_QUILL_SEED.get());
    }

    public static class QuillRangedGoal
    extends Goal {
        private final PoisonQuillVine mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = 0;
        private final float attackRadius;

        public QuillRangedGoal(PoisonQuillVine mob, float attackRadius) {
            this.mob = mob;
            this.attackRadius = attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && this.mob.m_142582_((Entity)livingentity) && livingentity.m_20270_((Entity)this.mob) <= this.attackRadius) {
                this.target = livingentity;
                return !this.mob.isEmerging() && this.mob.getCurrentAnimation() != this.mob.getAnimationState("hold") && this.mob.getCurrentAnimation() != this.mob.getAnimationState("burrow");
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            this.attackTime = -20;
        }

        public void m_8041_() {
            if (this.mob.getCurrentAnimation() != this.mob.getAnimationState("burrow")) {
                this.mob.setAnimationState("target");
            }
            this.target = null;
            this.attackTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null) {
                this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                ++this.attackTime;
                if (this.attackTime == 1) {
                    this.mob.setAnimationState("shoot");
                } else if (this.attackTime == 10) {
                    this.mob.shootQuill(this.target);
                } else if (this.attackTime >= 25) {
                    this.mob.setAnimationState("target");
                    this.attackTime = -20;
                }
            }
        }
    }
}

