/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.projectiles.SpellHurtingProjectile;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractCyclone
extends SpellHurtingProjectile {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(AbstractCyclone.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Optional<UUID>> TARGET_UNIQUE_ID = SynchedEntityData.m_135353_(AbstractCyclone.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(AbstractCyclone.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float damage = 0.0f;
    public int lifespan;
    public int totalLife = 600;
    public int spun = 0;

    public AbstractCyclone(EntityType<? extends SpellHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
        this.f_19794_ = false;
        this.lifespan = 0;
    }

    public AbstractCyclone(EntityType<? extends SpellHurtingProjectile> pEntityType, LivingEntity shooter, double xPower, double yPower, double zPower, Level level) {
        super(pEntityType, shooter, xPower, yPower, zPower, level);
        this.f_19794_ = false;
        this.lifespan = 0;
    }

    public AbstractCyclone(EntityType<? extends SpellHurtingProjectile> pEntityType, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double xPower, double yPower, double zPower, Level level) {
        super(pEntityType, p_i1795_2_, p_i1795_4_, p_i1795_6_, xPower, yPower, zPower, level);
        this.f_19794_ = false;
        this.lifespan = 0;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(TARGET_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_RADIUS, (Object)Float.valueOf(1.0f));
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (DATA_RADIUS.equals(p_33134_)) {
            this.m_6210_();
        }
        super.m_7350_(p_33134_);
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        float i = this.getSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        return entitydimensions.m_20388_(i);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            this.setOwnerId(compound.m_128342_("Owner"));
        }
        if (compound.m_128403_("Target")) {
            this.setTargetId(compound.m_128342_("Target"));
        }
        if (compound.m_128441_("Lifespan")) {
            this.setLifespan(compound.m_128451_("Lifespan"));
        }
        if (compound.m_128441_("TotalLife")) {
            this.setTotalLife(compound.m_128451_("TotalLife"));
        }
        if (compound.m_128441_("Spun")) {
            this.setSpun(compound.m_128451_("Spun"));
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
        if (compound.m_128441_("Size")) {
            this.setSize(compound.m_128457_("Size"));
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getTargetId() != null) {
            compound.m_128362_("Target", this.getTargetId());
        }
        compound.m_128405_("Lifespan", this.getLifespan());
        compound.m_128405_("TotalLife", this.getTotalLife());
        compound.m_128405_("Spun", this.getSpun());
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128350_("Size", this.getSize());
    }

    @Override
    protected float m_6884_() {
        return 0.68f + Math.min(this.boltSpeed, 0.32f);
    }

    public int getTotalLife() {
        return this.totalLife;
    }

    public void setTotalLife(int totalLife) {
        this.totalLife = totalLife;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(int lifespan) {
        this.lifespan = lifespan;
    }

    public int getSpun() {
        return this.spun;
    }

    public void setSpun(int spun) {
        this.spun = spun;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setOwner(LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setOwnerId(livingEntity.m_20148_());
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            return mob.m_5448_();
        }
        try {
            UUID uuid = this.getTargetId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getTargetId() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_UNIQUE_ID)).orElse(null);
    }

    public void setTargetId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(TARGET_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setTargetId(livingEntity.m_20148_());
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.getLifespan() < this.getTotalLife()) {
                ++this.lifespan;
            } else {
                this.trueRemove();
            }
            if (this.getTrueOwner() != null && this.getTarget() != null) {
                LivingEntity livingentity = this.getTarget();
                double d1 = livingentity.m_20185_() - this.m_20185_();
                double d2 = livingentity.m_20227_(0.5) - this.m_20227_(0.5);
                double d3 = livingentity.m_20189_() - this.m_20189_();
                if (this.f_19797_ % 50 == 0) {
                    this.fakeRemove(d1, d2, d3);
                }
            }
            int maxSpun = 80;
            if (this.getSpun() >= maxSpun) {
                this.trueRemove();
            }
            ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
            for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82400_((double)this.getSize()))) {
                LivingEntity livingEntity = MobUtil.getLivingTarget(entity);
                if (livingEntity == null) continue;
                if (this.m_19749_() != null) {
                    if (livingEntity == this.m_19749_() || MobUtil.areAllies(this.m_19749_(), (Entity)livingEntity)) continue;
                    targets.add(livingEntity);
                    continue;
                }
                targets.add(livingEntity);
            }
            if (!targets.isEmpty()) {
                for (LivingEntity entity : targets) {
                    if (!MobUtil.validEntity((Entity)entity)) continue;
                    this.suckInMobs(entity);
                }
            }
        }
    }

    public void trueRemove() {
        this.setLifespan(this.getTotalLife());
        this.remove();
    }

    public abstract void fakeRemove(double var1, double var3, double var5);

    public abstract void remove();

    public void suckInMobs(LivingEntity livingEntity) {
        ++this.spun;
        float radius = this.getSize() + (float)(this.spun % 20) * 0.05f;
        float knockBack = (float)Mth.m_14008_((double)(1.0 - livingEntity.m_21133_(Attributes.f_22278_)), (double)0.0, (double)1.0);
        float angle = (float)(this.spun % 20) * -0.25f;
        double f0 = this.m_20185_() + (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle))));
        double f1 = this.m_20189_() + (double)(radius * Mth.m_14089_((float)angle));
        double d0 = (f0 - livingEntity.m_20185_()) * (double)knockBack;
        double d1 = (f1 - livingEntity.m_20189_()) * (double)knockBack;
        if ((this.f_36813_ != 0.0 || this.f_36814_ != 0.0 || this.f_36815_ != 0.0) && this.getTrueOwner() != null) {
            this.fakeRemove(0.0, 0.0, 0.0);
        }
        if (this.getTarget() == null || this.getTarget().m_21224_()) {
            this.setTarget(livingEntity);
        }
        this.hurtMobs(livingEntity);
        MobUtil.twister((Entity)livingEntity, d0, 0.1 * (double)knockBack, d1);
    }

    public abstract void hurtMobs(LivingEntity var1);

    public void setSize(float p_33109_) {
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)p_33109_, (float)0.0f, (float)64.0f)));
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    @Override
    protected boolean m_5603_(Entity p_36842_) {
        return super.m_5603_(p_36842_) && !p_36842_.f_19794_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

