/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.AcidPool;
import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BioMine
extends SpellEntity {
    public float extraRadius = 0.0f;
    public int extraDuration = 0;
    public int lifeTicks = MathHelper.secondsToTicks(5);

    public BioMine(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("LifeTicks")) {
            this.lifeTicks = pCompound.m_128451_("LifeTicks");
        }
        if (pCompound.m_128441_("Duration")) {
            this.extraDuration = pCompound.m_128451_("Duration");
        }
        if (pCompound.m_128441_("CurrentTicks")) {
            this.f_19797_ = pCompound.m_128451_("CurrentTicks");
        }
        if (pCompound.m_128441_("ExtraRadius")) {
            this.setExtraRadius(pCompound.m_128457_("ExtraRadius"));
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("LifeTicks", this.lifeTicks);
        pCompound.m_128405_("Duration", this.extraDuration);
        pCompound.m_128405_("CurrentTicks", this.f_19797_);
        pCompound.m_128350_("ExtraRadius", this.getExtraRadius());
    }

    public float getExtraRadius() {
        return this.extraRadius;
    }

    public void setExtraRadius(float radius) {
        this.extraRadius = radius;
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public void setLifeTicks(int lifeTicks) {
        this.lifeTicks = lifeTicks;
    }

    public int getExtraDuration() {
        return this.extraDuration;
    }

    public void setExtraDuration(int extraDuration) {
        this.extraDuration = extraDuration;
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public void m_20256_(@NotNull Vec3 p_149804_) {
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        --this.lifeTicks;
        if (!this.f_19853_.f_46443_) {
            if (this.lifeTicks <= 0 && this.f_19853_.m_213780_().m_188503_(8) == 0) {
                this.trigger();
            }
            if (!this.m_20068_() && !this.m_20069_()) {
                MobUtil.moveDownToGround(this);
            }
            if (this.f_19797_ >= 20) {
                double bbSize = 3.0 + (double)this.getExtraRadius();
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(bbSize, bbSize / 2.0, bbSize))) {
                    if (!livingentity.m_6084_() || livingentity.m_20147_()) continue;
                    if (this.m_269323_() != null) {
                        if (MobUtil.areAllies((Entity)this.m_269323_(), (Entity)livingentity) || livingentity == this.m_269323_()) continue;
                        this.trigger();
                        continue;
                    }
                    this.trigger();
                }
            }
        }
    }

    public void trigger() {
        if (!this.f_19853_.f_46443_) {
            double bbSize = 3.0 + (double)this.getExtraRadius();
            for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(bbSize, bbSize / 2.0, bbSize))) {
                if (!livingentity.m_6084_() || livingentity.m_20147_()) continue;
                if (this.m_269323_() != null) {
                    if (MobUtil.areAllies((Entity)this.m_269323_(), (Entity)livingentity) || livingentity == this.m_269323_()) continue;
                    this.explodeDamage(livingentity);
                    continue;
                }
                this.explodeDamage(livingentity);
            }
            AcidPool acidPool = new AcidPool((EntityType)ModEntityType.ACID_POOL.get(), this.f_19853_);
            acidPool.m_146884_(this.m_20182_());
            acidPool.setRadius(2.0f + this.getExtraRadius());
            acidPool.setDamage(2.0f + this.getExtraDamage());
            acidPool.setColor(2143038);
            ColorUtil colorUtil0 = new ColorUtil(2143038);
            acidPool.setParticle((ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get());
            acidPool.setParticleSpeed(colorUtil0.red(), colorUtil0.green(), colorUtil0.blue());
            acidPool.setDuration(MathHelper.secondsToTicks(3) + this.getExtraDuration());
            if (this.m_269323_() != null) {
                acidPool.setOwner(this.m_269323_());
            }
            this.f_19853_.m_7967_((Entity)acidPool);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ColorUtil colorUtil = ColorUtil.WHITE;
                serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, (float)bbSize, 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, (float)bbSize, 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_5496_((SoundEvent)ModSounds.BIOMINE_TRIGGER.get(), 1.4f, 1.0f);
            this.m_146870_();
        }
    }

    public void explodeDamage(LivingEntity livingEntity) {
        if (!this.f_19853_.f_46443_) {
            float damage = 3.0f + this.getExtraDamage();
            if (this.m_269323_() != null) {
                livingEntity.m_6469_(ModDamageSource.acid(this, (Entity)this.m_269323_()), damage);
            } else {
                livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), damage);
            }
        }
    }

    public boolean m_6469_(DamageSource p_31050_, float p_31051_) {
        if (this.m_6673_(p_31050_)) {
            return false;
        }
        if (MobUtil.areAllies(this, p_31050_.m_7639_())) {
            return false;
        }
        if (!this.m_213877_() && !this.f_19853_.f_46443_) {
            this.trigger();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }
}

