/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.GroundProjectile;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.Vec3Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class BlossomThorn
extends GroundProjectile {
    public int duration = 0;
    public float extraDamage = 0.0f;
    public float height = 4.0f + (this.f_19796_.m_188501_() - 0.5f) * 2.0f * 0.5f;
    public Vec3 randVec = Vec3Util.randVec(this.f_19796_);

    public BlossomThorn(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
        this.lifeTicks = 20;
    }

    public BlossomThorn(Level world, double pPosX, double pPosY, double pPosZ, int pWarmUp, LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.BLOSSOM_THORN.get()), world);
        this.warmupDelayTicks = pWarmUp;
        this.setOwner(owner);
        this.m_6034_(pPosX, pPosY, pPosZ);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ExtraDamage")) {
            this.extraDamage = pCompound.m_128451_("ExtraDamage");
        }
        if (pCompound.m_128441_("Duration")) {
            this.duration = pCompound.m_128451_("Duration");
        }
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ExtraDamage", this.extraDamage);
        pCompound.m_128405_("Duration", this.duration);
    }

    public void setExtraDamage(float extraDamage) {
        this.extraDamage = extraDamage;
    }

    public float getExtraDamage() {
        return this.extraDamage;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.sentTrapEvent) {
                --this.lifeTicks;
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (!this.playSound) {
                this.f_19853_.m_7605_((Entity)this, (byte)5);
                this.playSound = true;
            }
            if (!this.sentTrapEvent) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.sentTrapEvent = true;
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82377_(0.0, 4.0, 0.0))) {
                    LivingEntity livingEntity = MobUtil.getLivingTarget(entity);
                    if (livingEntity == null) continue;
                    this.dealDamageTo(livingEntity);
                }
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    private void dealDamageTo(LivingEntity target) {
        LivingEntity livingentity = this.getOwner();
        float baseDamage = ((Double)SpellConfig.BlossomDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (target.m_6084_() && !target.m_20147_() && MobUtil.validEntity((Entity)target) && target != livingentity) {
            boolean flag;
            if (livingentity != null) {
                if (MobUtil.areAllies((Entity)livingentity, (Entity)target)) {
                    return;
                }
                flag = target.m_6469_(this.m_269291_().m_269374_((Entity)livingentity), baseDamage + this.getExtraDamage());
            } else {
                flag = target.m_6469_(this.m_269291_().m_269374_((Entity)this), baseDamage + this.getExtraDamage());
            }
            if (flag) {
                MobEffect effect = MobEffects.f_19614_;
                if (livingentity != null && CuriosFinder.hasWildRobe(livingentity)) {
                    effect = (MobEffect)GoetyEffects.ACID_VENOM.get();
                }
                target.m_147207_(new MobEffectInstance(effect, 140 + MathHelper.secondsToTicks(this.duration)), (Entity)this);
            }
        }
    }

    @Override
    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 5 && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.VINE_TRAP_BURST.get(), this.m_5720_(), 1.0f, 0.75f, false);
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.QUICK_GROWING_VINE_BURST.get(), this.m_5720_(), 1.0f, 0.75f, false);
        }
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

