/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.utils.BrewUtils;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BrewArrow
extends Arrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(BrewArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public List<MobEffectInstance> effects = Lists.newArrayList();
    public List<BrewEffectInstance> brewEffects = Lists.newArrayList();
    private boolean fixedColor;

    public BrewArrow(EntityType<? extends Arrow> p_36721_, Level p_36722_) {
        super(p_36721_, p_36722_);
    }

    public BrewArrow(Level p_36861_, double p_36862_, double p_36863_, double p_36864_) {
        super(p_36861_, p_36862_, p_36863_, p_36864_);
    }

    public BrewArrow(Level p_36866_, LivingEntity p_36867_) {
        super(p_36866_, p_36867_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    public void m_36878_(ItemStack p_36879_) {
        if (p_36879_.m_150930_(Items.f_42738_)) {
            int i;
            List<BrewEffectInstance> collection;
            List collection0 = PotionUtils.m_43571_((ItemStack)p_36879_);
            if (!collection0.isEmpty()) {
                for (MobEffectInstance instance : collection0) {
                    this.effects.add(new MobEffectInstance(instance));
                }
            }
            if (!(collection = BrewUtils.getCustomEffects(p_36879_)).isEmpty()) {
                for (BrewEffectInstance instance : collection) {
                    this.brewEffects.add(new BrewEffectInstance(instance));
                }
            }
            if ((i = BrewArrow.m_36884_(p_36879_)) == -1) {
                this.m_36890_();
            } else {
                this.m_36882_(i);
            }
        } else if (p_36879_.m_150930_(Items.f_42412_)) {
            this.effects.clear();
            this.brewEffects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int m_36884_(ItemStack p_36885_) {
        CompoundTag compoundtag = p_36885_.m_41783_();
        return compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99) ? compoundtag.m_128451_("CustomPotionColor") : -1;
    }

    private void m_36890_() {
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)BrewUtils.getColor(this.effects, this.brewEffects));
    }

    public void m_36870_(MobEffectInstance p_19717_) {
        this.effects.add(p_19717_);
        if (!this.fixedColor) {
            this.m_36890_();
        }
    }

    public void addBrewEffect(BrewEffectInstance p_19717_) {
        this.brewEffects.add(p_19717_);
        if (!this.fixedColor) {
            this.m_36890_();
        }
    }

    public int m_36889_() {
        return (Integer)this.m_20088_().m_135370_(ID_EFFECT_COLOR);
    }

    public void m_36882_(int p_19715_) {
        this.fixedColor = true;
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)p_19715_);
    }

    public void m_7380_(CompoundTag p_36881_) {
        ListTag listtag;
        super.m_7380_(p_36881_);
        if (this.fixedColor) {
            p_36881_.m_128405_("Color", this.m_36889_());
        }
        if (!this.effects.isEmpty()) {
            listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            p_36881_.m_128365_("Effects", (Tag)listtag);
        }
        if (!this.brewEffects.isEmpty()) {
            listtag = new ListTag();
            for (BrewEffectInstance brewEffectInstance : this.brewEffects) {
                listtag.add((Object)brewEffectInstance.save(new CompoundTag()));
            }
            p_36881_.m_128365_("BrewEffects", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag p_36875_) {
        Object instance;
        CompoundTag compoundtag;
        int i;
        ListTag listtag;
        super.m_7378_(p_36875_);
        if (p_36875_.m_128425_("Effects", 9)) {
            listtag = p_36875_.m_128437_("Effects", 10);
            for (i = 0; i < listtag.size(); ++i) {
                compoundtag = listtag.m_128728_(i);
                instance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                if (instance == null) continue;
                this.m_36870_((MobEffectInstance)instance);
            }
        }
        if (p_36875_.m_128425_("BrewEffects", 9)) {
            listtag = p_36875_.m_128437_("BrewEffects", 10);
            for (i = 0; i < listtag.size(); ++i) {
                compoundtag = listtag.m_128728_(i);
                instance = BrewEffectInstance.load(compoundtag);
                if (instance == null) continue;
                this.addBrewEffect((BrewEffectInstance)instance);
            }
        }
        if (p_36875_.m_128425_("Color", 99)) {
            this.m_36882_(p_36875_.m_128451_("Color"));
        } else {
            this.m_36890_();
        }
    }

    protected void m_7761_(LivingEntity p_36873_) {
        super.m_7761_(p_36873_);
        Entity entity = this.m_150173_();
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobeffectinstance1 : this.effects) {
                p_36873_.m_147207_(mobeffectinstance1, entity);
            }
        }
        if (!this.brewEffects.isEmpty()) {
            for (BrewEffectInstance brewEffectInstance : this.brewEffects) {
                if (!brewEffectInstance.getEffect().canLinger()) continue;
                brewEffectInstance.getEffect().applyInstantenousEffect((Entity)this, this.m_19749_(), p_36873_, brewEffectInstance.getAmplifier(), 0.5);
            }
        }
    }

    protected ItemStack m_7941_() {
        if (this.effects.isEmpty() && this.brewEffects.isEmpty()) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42738_);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.m_36889_());
        }
        return itemstack;
    }
}

