/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.TangleEntity;
import com.Polarice3.Goety.init.ModSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntangleVines
extends TangleEntity {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(EntangleVines.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean isDamaging;
    public AnimationState hiddenAnimationState = new AnimationState();
    public AnimationState holdAnimationState = new AnimationState();
    public AnimationState burstAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();

    public EntangleVines(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public EntangleVines(Level p_19871_, LivingEntity owner, Entity target) {
        super((EntityType)ModEntityType.ENTANGLE_VINES.get(), p_19871_, owner, target);
    }

    public EntangleVines(Level p_19871_, LivingEntity owner, BlockPos blockPos) {
        super((EntityType)ModEntityType.ENTANGLE_VINES.get(), p_19871_, owner, blockPos);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "hold")) {
            return 1;
        }
        if (Objects.equals(animation, "burst")) {
            return 2;
        }
        if (Objects.equals(animation, "burrow")) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.hiddenAnimationState);
        list.add(this.holdAnimationState);
        list.add(this.burstAnimationState);
        list.add(this.burrowAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.hiddenAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.hiddenAnimationState);
                    break;
                }
                case 1: {
                    this.holdAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.holdAnimationState);
                    break;
                }
                case 2: {
                    this.burstAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.burstAnimationState);
                    break;
                }
                case 3: {
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.burrowAnimationState);
                }
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Damaging")) {
            this.isDamaging = pCompound.m_128471_("Damaging");
        }
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Damaging", this.isDamaging);
    }

    public void setDamaging(boolean damaging) {
        this.isDamaging = damaging;
    }

    @Override
    public void burst() {
        this.setAnimationState("burst");
        this.m_5496_((SoundEvent)ModSounds.VINE_TRAP_BURST.get(), 2.0f, 1.0f);
        this.m_5496_((SoundEvent)ModSounds.VINE_TRAP_HOLD.get(), 1.0f, 1.0f);
    }

    @Override
    public void tangleTarget() {
        super.tangleTarget();
        this.setAnimationState("hold");
        if (this.getTarget() != null && this.isDamaging) {
            this.getTarget().m_6469_(this.m_269291_().m_269374_((Entity)this), 1.0f);
        }
    }

    @Override
    public void burrow() {
        this.setAnimationState("burrow");
    }
}

