/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.render.HauntedSkullTextures;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.BoneLord;
import com.Polarice3.Goety.common.entities.hostile.SkullLord;
import com.Polarice3.Goety.common.entities.projectiles.ExplosiveProjectile;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ExplosionUtil;
import com.Polarice3.Goety.utils.LootingExplosion;
import com.Polarice3.Goety.utils.MobUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class HauntedSkullProjectile
extends ExplosiveProjectile {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(HauntedSkullProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float damage = ((Double)SpellConfig.HauntedSkullDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
    public boolean isPowered;

    public HauntedSkullProjectile(EntityType<? extends ExplosiveProjectile> p_i50166_1_, Level p_i50166_2_) {
        super(p_i50166_1_, p_i50166_2_);
    }

    public HauntedSkullProjectile(double p_i50167_2_, double p_i50167_4_, double p_i50167_6_, double p_i50167_8_, double p_i50167_10_, double p_i50167_12_, Level p_i50167_14_) {
        super((EntityType<? extends ExplosiveProjectile>)((EntityType)ModEntityType.HAUNTED_SKULL_SHOT.get()), p_i50167_2_, p_i50167_4_, p_i50167_6_, p_i50167_8_, p_i50167_10_, p_i50167_12_, p_i50167_14_);
    }

    public HauntedSkullProjectile(LivingEntity p_i50168_2_, double p_i50168_3_, double p_i50168_5_, double p_i50168_7_, Level p_i50168_9_) {
        super((EntityType<? extends ExplosiveProjectile>)((EntityType)ModEntityType.HAUNTED_SKULL_SHOT.get()), p_i50168_2_, p_i50168_3_, p_i50168_5_, p_i50168_7_, p_i50168_9_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)9);
    }

    public ResourceLocation getResourceLocation() {
        return HauntedSkullTextures.TEXTURES.getOrDefault(this.getAnimation(), HauntedSkullTextures.TEXTURES.get(0));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            Vec3 vector3d = this.m_20184_();
            double d0 = this.m_20185_() + vector3d.f_82479_;
            double d1 = this.m_20186_() + vector3d.f_82480_;
            double d2 = this.m_20189_() + vector3d.f_82481_;
            if (this.getAnimation() < 16) {
                this.setAnimation(this.getAnimation() + 1);
            } else {
                this.setAnimation(9);
            }
            for (int j = 0; j < 2; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0 + this.f_19796_.m_188583_() * (double)0.3f, d1 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
            }
        } else if (this.isUpgraded()) {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_) {
            Entity target = pResult.m_82443_();
            Entity owner = this.m_19749_();
            float enchantment = this.getExtraDamage();
            int flaming = this.getFiery();
            if (owner instanceof LivingEntity) {
                Mob mob;
                LivingEntity livingentity = (LivingEntity)owner;
                if (livingentity instanceof Mob && (mob = (Mob)livingentity).m_21051_(Attributes.f_22281_) != null) {
                    this.damage = (float)mob.m_21133_(Attributes.f_22281_);
                }
                boolean flag = target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), this.damage + enchantment);
                if (livingentity instanceof SkullLord && target instanceof BoneLord) {
                    flag = false;
                }
                if (flag) {
                    if (target.m_6084_()) {
                        this.m_19970_(livingentity, target);
                        if (flaming != 0) {
                            target.m_20254_(5 * flaming);
                        }
                    } else {
                        livingentity.m_5634_(1.0f);
                    }
                }
            } else {
                target.m_6469_(this.m_269291_().m_269425_(), this.damage);
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.explode();
    }

    @Override
    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            if (pEntity == this.m_19749_()) {
                return false;
            }
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        if (this.isUpgraded() && pEntity instanceof AbstractHurtingProjectile) {
            return false;
        }
        return super.m_5603_(pEntity);
    }

    public void explode() {
        if (!this.f_19853_.f_46443_) {
            float wanting;
            Player player;
            Entity owner = this.m_19749_();
            boolean flaming = this.getFiery() > 0;
            boolean loot = false;
            if (owner instanceof Player && CuriosFinder.findRing(player = (Player)owner).m_41720_() == ModItems.RING_OF_WANT.get() && CuriosFinder.findRing(player).m_41793_() && (wanting = (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.WANTING.get()), (ItemStack)CuriosFinder.findRing(player))) > 0.0f) {
                loot = true;
            }
            Explosion.BlockInteraction explodeMode = Explosion.BlockInteraction.KEEP;
            if (this.isDangerous()) {
                explodeMode = this.m_19749_() instanceof Player ? ((Boolean)SpellConfig.HauntedSkullGriefing.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP) : (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP);
            }
            LootingExplosion.Mode lootMode = loot ? LootingExplosion.Mode.LOOT : LootingExplosion.Mode.REGULAR;
            ExplosionUtil.lootExplode(this.f_19853_, (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionPower(), flaming, explodeMode, lootMode);
            this.m_146870_();
        }
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isUpgraded()) {
            return false;
        }
        this.explode();
        this.m_5834_();
        return !this.m_6673_(source);
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123755_;
    }

    protected boolean m_5931_() {
        return false;
    }

    @Override
    public void m_7822_(byte p_19882_) {
        if (p_19882_ == 4) {
            this.isPowered = true;
        } else if (p_19882_ == 5) {
            this.isPowered = false;
        } else {
            super.m_7822_(p_19882_);
        }
    }
}

