/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.ViciousPike;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ViciousTooth
extends Entity {
    private LivingEntity owner;
    private UUID ownerUUID;
    private boolean isDropping;
    public int hovering = 0;
    public float extraDamage = 0.0f;

    public ViciousTooth(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public ViciousTooth(Level pLevel, LivingEntity pOwner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), pLevel);
        this.owner = pOwner;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
        UUID ownerUUID;
        if (pCompound.m_128403_("Owner")) {
            ownerUUID = pCompound.m_128342_("Owner");
        } else {
            String s = pCompound.m_128461_("Owner");
            ownerUUID = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (ownerUUID != null) {
            this.ownerUUID = ownerUUID;
        }
        this.hovering = pCompound.m_128451_("hovering");
        this.extraDamage = pCompound.m_128457_("extraDamage");
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        pCompound.m_128405_("hovering", this.hovering);
        pCompound.m_128350_("extraDamage", this.extraDamage);
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setExtraDamage(float extraDamage) {
        this.extraDamage = extraDamage;
    }

    private void onHit() {
        if (!this.f_19853_.m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            BlockState blockState = Blocks.f_152496_.m_49966_();
            this.m_5496_(SoundEvents.f_12601_, 1.0f, 0.5f);
            serverWorld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_(), 256, (double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0, 1.0);
            if (this.isDropping) {
                for (LivingEntity livingEntity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 1.0, 2.0), this::canHitEntity)) {
                    this.damageTargets(livingEntity);
                }
            }
            for (Direction direction : Direction.values()) {
                if (!direction.m_122434_().m_122479_()) continue;
                BlockPos blockPos = this.m_20183_().m_121945_(direction);
                ViciousPike impale = new ViciousPike(this.f_19853_, this.getOwner() != null ? this.getOwner() : null);
                impale.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                MobUtil.moveDownToGround(impale);
                this.f_19853_.m_7967_((Entity)impale);
            }
        }
        this.m_146870_();
    }

    public void damageTargets(LivingEntity livingEntity) {
        float damage = ((Double)SpellConfig.ViciousToothDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        damage += this.extraDamage;
        if (livingEntity != null && (this.getOwner() != null && !MobUtil.areAllies((Entity)this.getOwner(), (Entity)livingEntity) || this.getOwner() == null)) {
            livingEntity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.getOwner()), damage);
        }
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        super.m_7601_(p_20006_, Vec3.f_82478_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            ++this.hovering;
            HitResult result = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
            if (result.m_6662_() != HitResult.Type.MISS) {
                EntityHitResult result1;
                if (result.m_6662_() == HitResult.Type.ENTITY && (result1 = (EntityHitResult)result).m_82443_() instanceof LivingEntity) {
                    this.damageTargets((LivingEntity)result1.m_82443_());
                }
                this.onHit();
            }
            if (this.m_20096_() || this.m_5830_() || this.f_19863_ || this.f_19862_) {
                this.onHit();
            }
        } else {
            ++this.hovering;
        }
        int hoverTime = this.f_19853_.m_46791_() != Difficulty.HARD ? MathHelper.secondsToTicks(3) : MathHelper.secondsToTicks(2);
        boolean bl = this.isDropping = this.hovering > hoverTime;
        if (!this.isDropping) {
            this.m_20256_(Vec3.f_82478_);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState blockState = Blocks.f_152496_.m_49966_();
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)new BlockParticleOption((ParticleType)ModParticleTypes.FAST_DUST.get(), blockState), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.25f);
            }
        } else {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.25, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public boolean isStarting() {
        return this.hovering < 20;
    }

    public boolean m_6097_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && !entity.f_19794_) {
            LivingEntity owner = this.getOwner();
            return owner == null || !owner.m_20365_(entity);
        }
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

