/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.magic.spells.wild.GrappleSpell;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VineHook
extends Projectile {
    public static final EntityDataAccessor<Boolean> ATTACHED = SynchedEntityData.m_135353_(VineHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.m_135353_(VineHook.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public boolean staff = false;

    public VineHook(EntityType<? extends VineHook> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public VineHook(Level level, Player player, float speed) {
        this((EntityType<? extends VineHook>)((EntityType)ModEntityType.VINE_HOOK.get()), level);
        this.m_5602_((Entity)player);
        this.m_6034_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
        this.m_20256_(player.m_20252_(1.0f).m_82490_((double)speed));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACHED, (Object)false);
        this.f_19804_.m_135372_(LENGTH, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        Player player = this.getPlayerOwner();
        if (!this.m_20068_() && !this.isAttached()) {
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, vec31.f_82480_ - (double)this.getGravity(), vec31.f_82481_);
        }
        if (player != null && (this.f_19853_.m_5776_() || !this.shouldRetract(player))) {
            HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hitResult.m_6662_() != HitResult.Type.MISS) {
                this.m_6532_(hitResult);
            }
            this.m_146884_(hitResult.m_82450_());
            this.m_20101_();
        } else {
            this.m_146870_();
        }
    }

    protected float getGravity() {
        return 0.03f;
    }

    private boolean shouldRetract(Player player) {
        if (!player.m_213877_() && player.m_6084_() && WandUtil.getSpell((LivingEntity)player) instanceof GrappleSpell && this.m_20280_((Entity)player) <= (double)Mth.m_144944_((int)64)) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    protected boolean m_5603_(Entity entity) {
        return false;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_20256_(Vec3.f_82478_);
        this.setAttached(true);
        Player player = this.getPlayerOwner();
        if (player != null) {
            double distance = player.m_146892_().m_82546_(blockHitResult.m_82450_()).m_82553_();
            this.setLength(Math.max((float)distance * 0.5f - 3.0f, 1.5f));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("Attached", this.isAttached());
        compoundTag.m_128350_("Length", this.getLength());
        compoundTag.m_128379_("Staff", this.isStaff());
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.setAttached(compoundTag.m_128471_("Attached"));
        this.setLength(compoundTag.m_128457_("Length"));
        if (compoundTag.m_128441_("Staff")) {
            this.staff = compoundTag.m_128471_("Staff");
        }
    }

    public void setStaff(boolean staff) {
        this.staff = staff;
    }

    public boolean isStaff() {
        return this.staff;
    }

    private void setAttached(boolean attached) {
        this.m_20088_().m_135381_(ATTACHED, (Object)attached);
    }

    private void setLength(float length) {
        this.m_20088_().m_135381_(LENGTH, (Object)Float.valueOf(length));
    }

    public boolean isAttached() {
        return (Boolean)this.m_20088_().m_135370_(ATTACHED);
    }

    public float getLength() {
        return ((Float)this.m_20088_().m_135370_(LENGTH)).floatValue();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        this.updateOwnerInfo(null);
        super.m_142687_(removalReason);
    }

    public void m_142036_() {
        this.updateOwnerInfo(null);
    }

    public void m_5602_(@Nullable Entity entity) {
        super.m_5602_(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable VineHook vineHook) {
        Player player = this.getPlayerOwner();
        if (player != null) {
            SEHelper.setGrappling(player, vineHook);
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Entity entity = this.m_19749_();
        return entity instanceof Player ? (Player)entity : null;
    }

    public boolean m_6072_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? this.m_19879_() : entity.m_19879_());
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        if (this.getPlayerOwner() == null) {
            this.m_6074_();
        }
    }
}

