/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SpellHurtingProjectile;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WitherBolt
extends SpellHurtingProjectile {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(WitherBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Goety.location("textures/entity/projectiles/soul_bolt/wither_bolt_1.png"));
        map.put(1, Goety.location("textures/entity/projectiles/soul_bolt/wither_bolt_2.png"));
        map.put(2, Goety.location("textures/entity/projectiles/soul_bolt/wither_bolt_3.png"));
    });

    public WitherBolt(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    public WitherBolt(double pX, double pY, double pZ, double pXPower, double pYPower, double pZPower, Level pLevel) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityType.WITHER_BOLT.get()), pX, pY, pZ, pXPower, pYPower, pZPower, pLevel);
    }

    public WitherBolt(LivingEntity pShooter, double pXPower, double pYPower, double pZPower, Level pLevel) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityType.WITHER_BOLT.get()), pShooter, pXPower, pYPower, pZPower, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    @Override
    protected float m_6884_() {
        return 0.95f;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAnimation(compound.m_128451_("Animation"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Animation", this.getAnimation());
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getAnimation(), TEXTURE_BY_TYPE.get(0));
    }

    public void rotateToMatchMovement() {
        this.m_37283_();
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_37626_) {
        super.m_5790_(p_37626_);
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            float baseDamage = ((Double)SpellConfig.SoulBoltDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            Entity entity = p_37626_.m_82443_();
            Entity entity1 = this.m_19749_();
            if (entity1 instanceof LivingEntity) {
                Mob mob;
                LivingEntity livingentity = (LivingEntity)entity1;
                if (livingentity instanceof Mob && (mob = (Mob)livingentity).m_21051_(Attributes.f_22281_) != null && mob.m_21133_(Attributes.f_22281_) > 0.0) {
                    baseDamage = (float)mob.m_21133_(Attributes.f_22281_);
                }
                if (flag = entity.m_6469_(entity.m_269291_().m_269104_((Entity)this, (Entity)livingentity), baseDamage += this.getExtraDamage())) {
                    if (entity.m_6084_()) {
                        this.m_19970_(livingentity, entity);
                    } else {
                        livingentity.m_5634_(2.0f);
                    }
                }
            } else {
                flag = entity.m_6469_(entity.m_269291_().m_269425_(), baseDamage);
            }
            if (flag && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 200), this.m_150173_());
                double x = this.m_20185_();
                double z = this.m_20189_();
                if (entity1 != null) {
                    x = entity1.m_20185_();
                    z = entity1.m_20189_();
                }
                livingEntity.m_147240_(1.0, x - entity.m_20185_(), z - entity.m_20189_());
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.f_19853_.f_46443_) {
            Level entityHitResult;
            Entity entity = this.m_19749_();
            Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
            if (entity instanceof LivingEntity) {
                if (pResult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)pResult;
                    BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                    if (BlockFinder.canBeReplaced(this.f_19853_, blockpos)) {
                        vec3 = Vec3.m_82512_((Vec3i)blockpos);
                    }
                } else if (pResult instanceof EntityHitResult) {
                    entityHitResult = (EntityHitResult)pResult;
                    Entity entity1 = entityHitResult.m_82443_();
                    vec3 = Vec3.m_82512_((Vec3i)entity1.m_20183_());
                }
            }
            if ((entityHitResult = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entityHitResult;
                ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123755_, (Entity)this);
                ColorUtil colorUtil = new ColorUtil(0x1F1F1F);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 2.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround((Entity)this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                DustCloudParticleOption cloudParticleOptions = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)0x1F1F1F).m_252839_()), 1.0f);
                DustCloudParticleOption cloudParticleOptions2 = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)0x171717).m_252839_()), 1.0f);
                for (int i = 0; i < 2; ++i) {
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, 1.0f);
                }
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions2, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, 1.0f);
            }
            new SpellExplosion(this.f_19853_, (Entity)(this.m_19749_() != null ? this.m_19749_() : this), this.m_269291_().m_269104_((Entity)this, this.m_19749_()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0f, 0.0f){

                @Override
                public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                    super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                    if (target instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)target;
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200));
                    }
                }
            };
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
            this.m_5496_((SoundEvent)ModSounds.HELL_BOLT_IMPACT.get(), 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getAnimation() < 2) {
            this.setAnimation(this.getAnimation() + 1);
        } else {
            this.setAnimation(0);
        }
        Entity entity = this.m_19749_();
        if (this.f_19797_ >= MathHelper.secondsToTicks(10)) {
            this.m_146870_();
        }
        if (this.f_19853_.f_46443_ || (entity == null || !entity.m_213877_()) && this.f_19853_.m_46805_(this.m_20183_())) {
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() - vec3.f_82479_;
            double d1 = this.m_20186_() - vec3.f_82480_;
            double d2 = this.m_20189_() - vec3.f_82481_;
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.TOTEM_EFFECT.get(), d0 + this.f_19853_.f_46441_.m_188500_() / 4.0 * (double)this.f_19853_.f_46441_.m_216332_(-1, 1), d1 + 0.15, d2 + this.f_19853_.f_46441_.m_188500_() / 4.0 * (double)this.f_19853_.f_46441_.m_216332_(-1, 1), 0.0, 0.0, 0.0);
        }
    }

    protected ParticleOptions m_5967_() {
        return (ParticleOptions)ModParticleTypes.TOTEM_EFFECT.get();
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    protected boolean m_5931_() {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

