/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.WitherNecromancer;
import com.Polarice3.Goety.common.entities.util.CastSpellTrap;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FirePillar
extends CastSpellTrap {
    public int warmUp;
    public boolean playEvent;

    public FirePillar(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FirePillar(Level worldIn, double x, double y, double z) {
        this((EntityType)ModEntityType.FIRE_PILLAR.get(), worldIn);
        this.m_6034_(x, y, z);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("WarmUp")) {
            this.warmUp = compound.m_128451_("WarmUp");
        }
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = compound.m_128471_("PlayEvent");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("WarmUp", this.warmUp);
        compound.m_128379_("PlayEvent", this.playEvent);
    }

    @Override
    public float radius() {
        return 1.0f;
    }

    @Override
    @Nullable
    public ParticleOptions getParticle() {
        return (ParticleOptions)ModParticleTypes.BURNING.get();
    }

    public void setWarmUp(int warmUp) {
        this.warmUp = warmUp;
        this.setDuration(this.getDuration() + warmUp);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.warmUp <= 0) {
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    if (this.f_19797_ % 5 == 0) {
                        serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.FIERY_PILLAR.get()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.5, 0.0, 1.0);
                    }
                }
                this.setActivated(true);
                if (!this.playEvent) {
                    this.m_5496_((SoundEvent)ModSounds.FIRE_BREATH_START.get(), 0.05f, 1.0f);
                    this.playEvent = true;
                }
                if (this.f_19797_ % 20 == 0) {
                    this.m_5496_((SoundEvent)ModSounds.FIRE_TORNADO_AMBIENT.get(), 1.0f, 1.0f);
                }
                ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82377_(0.0, 8.0, 0.0))) {
                    LivingEntity livingEntity = MobUtil.getLivingTarget(entity);
                    if (livingEntity == null) continue;
                    if (this.m_269323_() != null) {
                        if (livingEntity == this.m_269323_() || MobUtil.areAllies((Entity)this.m_269323_(), (Entity)livingEntity)) continue;
                        targets.add(livingEntity);
                        continue;
                    }
                    targets.add(livingEntity);
                }
                if (!targets.isEmpty()) {
                    for (LivingEntity livingEntity : targets) {
                        Mob mob;
                        LivingEntity livingEntity2;
                        int distance = Math.max((int)(livingEntity.m_20186_() - this.m_20186_()), 1);
                        if (!BlockFinder.emptySpaceBetween(this.f_19853_, this.m_20183_().m_7494_(), Math.min(8, distance), true)) continue;
                        float damage = ((Double)SpellConfig.FlameStrikeDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
                        if (this.m_269323_() != null && (livingEntity2 = this.m_269323_()) instanceof Mob && (mob = (Mob)livingEntity2).m_21051_(Attributes.f_22281_) != null) {
                            damage = (float)mob.m_21133_(Attributes.f_22281_) / 2.0f;
                        }
                        damage += this.getExtraDamage();
                        DamageSource damageSource = ModDamageSource.fireBreath(this, (Entity)this.m_269323_());
                        if (CuriosFinder.hasNetherRobe(this.m_269323_())) {
                            damageSource = ModDamageSource.magicFireBreath(this, (Entity)this.m_269323_());
                        }
                        if (MobUtil.getOwner((Entity)livingEntity) != null && CuriosFinder.hasNetherRobe(MobUtil.getOwner((Entity)livingEntity))) {
                            damageSource = ModDamageSource.magicFireBreath(this, (Entity)this.m_269323_());
                        }
                        if (this.m_269323_() instanceof WitherNecromancer || CuriosFinder.hasUnholySet(this.m_269323_())) {
                            damageSource = ModDamageSource.hellfire(this, (Entity)this.m_269323_());
                        }
                        livingEntity.m_6469_(damageSource, damage);
                        livingEntity.m_20254_(5);
                    }
                }
            } else {
                Level level;
                if (!this.m_20068_()) {
                    MobUtil.moveDownToGround(this);
                }
                if ((level = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    double d2 = this.m_20186_() + 0.5;
                    double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_FIRE_GROUND.get()), d1, d2, d3, 0, 0.0, 0.0, 0.0, 0.5);
                }
                if (this.m_269323_() != null && this.m_269323_().m_21224_()) {
                    this.m_146870_();
                }
                --this.warmUp;
            }
            if (this.f_19797_ >= this.getDuration()) {
                this.m_146870_();
            }
        }
    }
}

