/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.util.CastSpellTrap;
import com.Polarice3.Goety.common.entities.util.ModFallingBlock;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayLoopSoundPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class VoidRift
extends CastSpellTrap {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(VoidRift.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> ID_SIZE = SynchedEntityData.m_135353_(VoidRift.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Goety.location("textures/entity/projectiles/void_rift/open_1.png"));
        map.put(1, Goety.location("textures/entity/projectiles/void_rift/open_2.png"));
        map.put(2, Goety.location("textures/entity/projectiles/void_rift/open_3.png"));
        map.put(3, Goety.location("textures/entity/projectiles/void_rift/rift_1.png"));
        map.put(4, Goety.location("textures/entity/projectiles/void_rift/rift_2.png"));
        map.put(5, Goety.location("textures/entity/projectiles/void_rift/rift_3.png"));
        map.put(6, Goety.location("textures/entity/projectiles/void_rift/rift_4.png"));
        map.put(7, Goety.location("textures/entity/projectiles/void_rift/rift_5.png"));
    });
    public int warmUp;
    public boolean playEvent;
    public boolean isClosing;

    public VoidRift(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.m_20242_(false);
    }

    public VoidRift(Level worldIn, double x, double y, double z) {
        this((EntityType)ModEntityType.VOID_RIFT.get(), worldIn);
        this.m_6034_(x, y, z);
        this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 2.0f, this.f_19796_.m_188501_() + 0.75f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(ID_SIZE, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (ID_SIZE.equals(p_33134_)) {
            this.m_6210_();
        }
        super.m_7350_(p_33134_);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Size")) {
            this.setSize(compound.m_128457_("Size"));
        }
        if (compound.m_128441_("TickTime")) {
            this.f_19797_ = compound.m_128451_("TickTime");
        }
        if (compound.m_128441_("WarmUp")) {
            this.warmUp = compound.m_128451_("WarmUp");
        }
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = compound.m_128471_("PlayEvent");
        }
        if (compound.m_128441_("IsClosing")) {
            this.isClosing = compound.m_128471_("IsClosing");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Size", this.getSize());
        compound.m_128405_("TickTime", this.f_19797_);
        compound.m_128405_("WarmUp", this.warmUp);
        compound.m_128379_("PlayEvent", this.playEvent);
        compound.m_128379_("IsClosing", this.isClosing);
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        float i = this.getSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        return entitydimensions.m_20388_(i);
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getAnimation(), TEXTURE_BY_TYPE.get(0));
    }

    public void setSize(float p_33109_) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Float.valueOf(Mth.m_14036_((float)p_33109_, (float)0.0f, (float)64.0f)));
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(ID_SIZE)).floatValue();
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public void setWarmUp(int warmUp) {
        this.warmUp = warmUp;
        this.setDuration(this.getDuration() + warmUp);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isActivated()) {
            int count = (Integer)SpellConfig.RuptureDuration.get() / 3;
            if (this.f_19797_ % count == 0) {
                if (this.f_19853_.f_46443_ && this.getAnimation() < 2) {
                    this.setAnimation(this.getAnimation() + 1);
                }
                this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 2.0f, this.f_19796_.m_188501_() + 0.75f);
            }
        } else if (this.f_19853_.f_46443_ && this.f_19797_ % 20 == 0) {
            if (this.isClosing) {
                if (this.getAnimation() > 0) {
                    this.setAnimation(this.getAnimation() - 1);
                }
            } else if (this.getAnimation() < 7) {
                this.setAnimation(this.getAnimation() + 1);
            } else {
                this.setAnimation(3);
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.warmUp <= 0) {
                if (!this.isActivated()) {
                    this.setActivated(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)100);
                }
                if (!this.playEvent) {
                    this.m_5496_((SoundEvent)ModSounds.VOID_RIFT_OPEN.get(), 5.0f, 1.0f);
                    ModNetwork.sendToALL(new SPlayLoopSoundPacket(this, (SoundEvent)ModSounds.VOID_RIFT.get(), 5.0f, 1.0f));
                    this.playEvent = true;
                }
                if (this.f_19797_ % 200 == 0) {
                    this.m_5496_(SoundEvents.f_12286_, 5.0f, 0.75f);
                }
                ArrayList<Entity> targets = new ArrayList<Entity>();
                float range = 16.0f * (this.getSize() + 1.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtil.gatheringParticles((ParticleOptions)ParticleTypes.f_123760_, this, serverWorld, (int)range);
                }
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82400_((double)range))) {
                    ModFallingBlock modFallingBlock;
                    if (entity instanceof Endermite) continue;
                    if (entity instanceof ModFallingBlock && (modFallingBlock = (ModFallingBlock)entity).getMode() == ModFallingBlock.FallingBlockMode.DEBRIS) {
                        targets.add(entity);
                        if (entity.m_20270_((Entity)this) <= 1.0f) {
                            entity.m_146870_();
                        }
                    }
                    if (this.m_269323_() != null) {
                        if (entity == this.m_269323_() || MobUtil.areAllies((Entity)this.m_269323_(), entity)) continue;
                        targets.add(entity);
                        continue;
                    }
                    targets.add(entity);
                }
                if (!targets.isEmpty()) {
                    for (Entity entity : targets) {
                        Mob mob;
                        LivingEntity livingEntity;
                        double distance = 1.0 - (double)(entity.m_20270_((Entity)this) / range);
                        double scale = distance * 0.25;
                        Vec3 vec3 = entity.m_20182_().m_82546_(this.m_20182_());
                        vec3 = vec3.m_82541_().m_82490_(scale);
                        MobUtil.pull(entity, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.5);
                        if (!((double)entity.m_20270_((Entity)this) <= this.m_20191_().m_82309_()) || !(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity2 = (LivingEntity)entity;
                        float damage = ((Double)SpellConfig.RuptureDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
                        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) instanceof Mob && (mob = (Mob)livingEntity).m_21051_(Attributes.f_22281_) != null) {
                            damage = (float)mob.m_21133_(Attributes.f_22281_) / 2.0f;
                        }
                        livingEntity2.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.m_269323_()), damage += this.getExtraDamage());
                    }
                }
            } else {
                Level range = this.f_19853_;
                if (range instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)range;
                    double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    double d2 = this.m_20186_() + 0.5;
                    double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, 0, 0.0, 0.0, 0.0, 0.5);
                }
                if (this.m_269323_() != null && this.m_269323_().m_21224_()) {
                    this.m_146870_();
                }
                --this.warmUp;
            }
            if (this.f_19797_ >= this.getDuration()) {
                if (!this.isClosing) {
                    this.isClosing = true;
                    this.f_19853_.m_7605_((Entity)this, (byte)101);
                }
                if (this.f_19797_ >= this.getDuration() + 20) {
                    Level d1 = this.f_19853_;
                    if (d1 instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)d1;
                        ColorUtil colorUtil = new ColorUtil(7542738);
                        float range = 8.0f * (this.getSize() + 1.0f);
                        serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, range, 0, true), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        ServerParticleUtil.createParticleBall((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), serverLevel, 8 + (int)this.getSize());
                        this.m_5496_((SoundEvent)SoundEvents.f_12377_.get(), 5.0f, 0.5f);
                        this.m_5496_(SoundEvents.f_11913_, 5.0f, 0.5f);
                        new SpellExplosion(this.f_19853_, (Entity)(this.m_269323_() != null ? this.m_269323_() : this), this.m_269291_().m_269104_((Entity)this, (Entity)this.m_269323_()), this.m_20183_(), range / 4.0f, 0.0f){

                            @Override
                            public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                                super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                                if (VoidRift.this.isStaff() && EntitySelector.f_20406_.test(target) && target instanceof LivingEntity) {
                                    LivingEntity livingEntity = (LivingEntity)target;
                                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), 2, false, true));
                                }
                            }
                        };
                    }
                    this.m_146870_();
                }
            }
        }
    }

    private void suckBlocks(int x, int y, int z) {
        int MthX = Mth.m_14107_((double)this.m_20185_());
        int MthY = Mth.m_14107_((double)this.m_20186_());
        int MthZ = Mth.m_14107_((double)this.m_20189_());
        if (!this.f_19853_.f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            for (int i = -x; i <= x; ++i) {
                for (int j = -y; j <= y; ++j) {
                    for (int k = -z; k <= z; ++k) {
                        int l = MthX + i;
                        int m = MthY + j;
                        int n = MthZ + k;
                        BlockPos blockpos = new BlockPos(l, m, n);
                        BlockState blockState = this.f_19853_.m_8055_(blockpos);
                        BlockState above = this.f_19853_.m_8055_(blockpos.m_7494_());
                        BlockEntity tileEntity = this.f_19853_.m_7702_(blockpos);
                        if (above != Blocks.f_50016_.m_49966_() && above != Blocks.f_49990_.m_49966_() || blockState == Blocks.f_50016_.m_49966_() || blockState.m_204336_(BlockTags.f_13070_) || blockState.m_204336_(BlockTags.f_13069_) || tileEntity != null || this.f_19796_.m_188503_(2000) != 0) continue;
                        this.f_19853_.m_7471_(blockpos, true);
                        ModFallingBlock fallingBlockEntity = new ModFallingBlock(this.f_19853_, (double)l + 0.5, (double)m + 0.5, (double)n + 0.5, blockState, 5);
                        this.f_19853_.m_7731_(blockpos, blockState.m_60819_().m_76188_(), 3);
                        this.f_19853_.m_7967_((Entity)fallingBlockEntity);
                    }
                }
            }
        }
    }

    public void m_7822_(byte p_19882_) {
        if (p_19882_ == 100) {
            this.setActivated(true);
            this.setAnimation(3);
        } else if (p_19882_ == 101) {
            this.isClosing = true;
            this.setAnimation(2);
        } else {
            super.m_7822_(p_19882_);
        }
    }
}

