/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.items.ItemBase;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class WaystoneItem
extends ItemBase {
    public static final String TAG_OWNER = "Owner";
    public static final String TAG_OWNER_NAME = "Owner_Name";
    public static final String TAG_POS = "Pos";
    public static final String TAG_DIRECTION = "Direction";
    public static final String TAG_FACING = "Facing";
    public static final String TAG_DIMENSION = "Dimension";

    public boolean m_5812_(ItemStack pStack) {
        return WaystoneItem.hasBlock(pStack);
    }

    public static boolean hasBlock(ItemStack p_40737_) {
        CompoundTag compoundtag = p_40737_.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_(TAG_DIMENSION) || compoundtag.m_128441_(TAG_POS));
    }

    private static Optional<ResourceKey<Level>> getBlockDimension(CompoundTag p_40728_) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_40728_.m_128423_(TAG_DIMENSION)).result();
    }

    @Nullable
    public static GlobalPos getPosition(ItemStack itemStack) {
        if (itemStack.m_41619_() || itemStack.m_41783_() == null || !itemStack.m_41783_().m_128441_(TAG_POS) || !itemStack.m_41783_().m_128441_(TAG_DIMENSION)) {
            return null;
        }
        CompoundTag tag = itemStack.m_41784_();
        return WaystoneItem.getPosition(tag);
    }

    @Nullable
    public static GlobalPos getPosition(CompoundTag p_220022_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_220022_.m_128441_(TAG_POS);
        boolean flag1 = p_220022_.m_128441_(TAG_DIMENSION);
        if (flag && flag1 && (optional = WaystoneItem.getBlockDimension(p_220022_)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)p_220022_.m_128469_(TAG_POS));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    @Nullable
    public static BlockPos getBlockPos(ItemStack itemStack) {
        GlobalPos globalPos = WaystoneItem.getPosition(itemStack);
        if (globalPos != null) {
            return globalPos.m_122646_();
        }
        return null;
    }

    @Nullable
    public static BlockEntity getBlockEntity(ItemStack itemStack, Level level) {
        BlockPos blockPos = WaystoneItem.getBlockPos(itemStack);
        if (blockPos == null) {
            return null;
        }
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_61138_((Property)BlockStateProperties.f_61401_) && level.m_7702_(blockPos) == null && blockState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            return level.m_7702_(blockPos.m_7495_());
        }
        return level.m_7702_(blockPos);
    }

    @Nullable
    public static Direction getDirection(ItemStack itemStack) {
        if (itemStack.m_41619_() || itemStack.m_41783_() == null || !itemStack.m_41783_().m_128441_(TAG_DIRECTION)) {
            return null;
        }
        CompoundTag tag = itemStack.m_41784_();
        return WaystoneItem.getDirection(tag);
    }

    @Nullable
    public static Direction getDirection(CompoundTag p_220022_) {
        boolean flag = p_220022_.m_128441_(TAG_DIRECTION);
        if (flag) {
            return Direction.values()[p_220022_.m_128451_(TAG_DIRECTION)];
        }
        return null;
    }

    @Nullable
    public static Direction getFacing(CompoundTag p_220022_) {
        boolean flag = p_220022_.m_128441_(TAG_FACING);
        if (flag) {
            return Direction.values()[p_220022_.m_128451_(TAG_FACING)];
        }
        return null;
    }

    public static boolean isSameDimension(LivingEntity livingEntity, ItemStack stack) {
        GlobalPos globalPos = WaystoneItem.getPosition(stack);
        return globalPos != null && globalPos.m_122640_() == livingEntity.f_19853_.m_46472_();
    }

    public static boolean isSameDimension(BlockEntity blockEntity, ItemStack stack) {
        GlobalPos globalPos = WaystoneItem.getPosition(stack);
        return globalPos != null && blockEntity.m_58904_() != null && globalPos.m_122640_() == blockEntity.m_58904_().m_46472_();
    }

    public static boolean isInRange(Vec3 origin, ItemStack stack, int increase) {
        GlobalPos globalPos = WaystoneItem.getPosition(stack);
        if (globalPos != null) {
            double scale = 6.0 * (double)((float)increase + 1.0f);
            double trueRange = Mth.m_144952_((double)scale) * 2.0;
            return globalPos.m_122646_().m_203193_((Position)origin) <= Mth.m_144952_((double)trueRange);
        }
        return false;
    }

    public static boolean canAffect(LivingEntity livingEntity, ItemStack stack, Vec3 origin, int increase) {
        return stack.m_41720_() instanceof WaystoneItem && WaystoneItem.getPosition(stack) != null && WaystoneItem.isSameDimension(livingEntity, stack) && WaystoneItem.isInRange(origin, stack, increase);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        GlobalPos globalPos;
        IServant owned;
        if (!player.f_19853_.f_46443_ && stack.m_41720_() instanceof WaystoneItem && entity instanceof IServant && (owned = (IServant)entity).getTrueOwner() == player && (globalPos = WaystoneItem.getPosition(stack)) != null && globalPos.m_122640_() == player.f_19853_.m_46472_()) {
            owned.setBoundPos(globalPos.m_122646_());
            owned.setWandering(false);
            owned.setStaying(false);
            player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.guard", (Object[])new Object[]{entity.m_5446_()}), true);
            player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
            ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack held;
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos blockpos = context.m_8083_();
        Direction side = context.m_43719_();
        if (player != null && !(held = player.m_21120_(hand)).m_41619_() && held.m_41720_() instanceof WaystoneItem) {
            player.m_6674_(hand);
            CompoundTag nbt = held.m_41784_();
            nbt.m_128362_(TAG_OWNER, player.m_20148_());
            nbt.m_128359_(TAG_OWNER_NAME, player.m_5446_().getString());
            this.addBlockTags((ResourceKey<Level>)player.f_19853_.m_46472_(), blockpos, nbt);
            nbt.m_128405_(TAG_DIRECTION, side.ordinal());
            nbt.m_128405_(TAG_FACING, player.m_6350_().ordinal());
            player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
            player.f_19853_.m_7785_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 0.45f, false);
            held.m_41751_(nbt);
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() || player.m_6047_()) {
            if (itemstack.m_41720_() instanceof WaystoneItem && WaystoneItem.hasBlock(itemstack) && itemstack.m_41783_() != null) {
                itemstack.m_41751_(new CompoundTag());
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private void addBlockTags(ResourceKey<Level> p_40733_, BlockPos p_40734_, CompoundTag p_40735_) {
        p_40735_.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)p_40734_));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, p_40733_).resultOrPartial(arg_0 -> ((Logger)Goety.LOGGER).error(arg_0)).ifPresent(p_40731_ -> p_40735_.m_128365_(TAG_DIMENSION, p_40731_));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        WaystoneItem.addWaystoneText(stack, tooltip);
    }

    public static void addWaystoneText(ItemStack stack, List<Component> tooltip) {
        if (stack.m_41783_() != null) {
            if (!WaystoneItem.hasBlock(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.noPos2"));
            } else {
                Direction direction;
                GlobalPos globalPos = WaystoneItem.getPosition(stack.m_41783_());
                if (globalPos != null) {
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.Pos2").m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"info.goety.focus.PosNum", (Object[])new Object[]{globalPos.m_122646_().m_123341_(), globalPos.m_122646_().m_123342_(), globalPos.m_122646_().m_123343_()})));
                    tooltip.add((Component)Component.m_237110_((String)"info.goety.focus.PosDim", (Object[])new Object[]{globalPos.m_122640_().m_135782_().toString()}));
                }
                if ((direction = WaystoneItem.getDirection(stack.m_41783_())) != null) {
                    tooltip.add((Component)Component.m_237110_((String)"info.goety.focus.PosDirection", (Object[])new Object[]{direction.m_122433_()}));
                }
            }
        }
    }
}

