/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.curios;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.curios.MagicRobeItem;
import com.Polarice3.Goety.common.items.curios.SingleStackItem;
import com.Polarice3.Goety.common.magic.spells.IronHideSpell;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class WardingCharmItem
extends SingleStackItem {
    private static final String SOULUSE = "Soul Use";

    public boolean SoulDiscount(LivingEntity entityLiving) {
        return CuriosFinder.hasCurio(entityLiving, itemStack -> itemStack.m_41720_() instanceof MagicRobeItem);
    }

    public boolean SoulCostUp(LivingEntity entityLiving) {
        return entityLiving.m_21023_((MobEffect)GoetyEffects.SUMMON_DOWN.get());
    }

    public int SoulCalculation(LivingEntity entityLiving) {
        if (this.SoulCostUp(entityLiving)) {
            int amp = Objects.requireNonNull(entityLiving.m_21124_((MobEffect)GoetyEffects.SUMMON_DOWN.get())).m_19564_() + 2;
            return new IronHideSpell().defaultSoulCost() * amp;
        }
        if (this.SoulDiscount(entityLiving)) {
            return new IronHideSpell().defaultSoulCost() / 2;
        }
        return new IronHideSpell().defaultSoulCost();
    }

    public int SoulUse(LivingEntity entityLiving, ItemStack stack) {
        if (stack.m_41793_()) {
            return (int)((float)(this.SoulCalculation(entityLiving) * 2) * SEHelper.soulDiscount(entityLiving));
        }
        return (int)((float)this.SoulCalculation(entityLiving) * SEHelper.soulDiscount(entityLiving));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof LivingEntity) {
            List mobs;
            Mob hostile;
            Player player;
            LivingEntity livingEntity = (LivingEntity)entityIn;
            CompoundTag compound = stack.m_41784_();
            compound.m_128405_(SOULUSE, this.SoulUse(livingEntity, stack));
            if (!worldIn.f_46443_ && livingEntity instanceof Player && !(player = (Player)livingEntity).m_21023_((MobEffect)GoetyEffects.SOUL_ARMOR.get()) && SEHelper.getSoulsAmount(player, this.SoulUse((LivingEntity)player, stack)) && ((hostile = (Mob)(mobs = worldIn.m_45976_(Mob.class, player.m_20191_().m_82377_(64.0, 16.0, 64.0))).stream().filter(mob -> mob.m_5448_() == player).findFirst().orElse(null)) != null || player.f_20916_ > 0)) {
                SEHelper.decreaseSouls(player, this.SoulUse((LivingEntity)player, stack));
                SEHelper.sendSEUpdatePacket(player);
                int enchantment = 0;
                int duration = 1;
                if (stack.m_41793_()) {
                    enchantment = this.getEnchantmentLevel(stack, (Enchantment)ModEnchantments.POTENCY.get());
                    duration += this.getEnchantmentLevel(stack, (Enchantment)ModEnchantments.DURATION.get());
                }
                player.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SOUL_ARMOR.get(), MathHelper.minutesToTicks(duration), enchantment, false, false, true));
                worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.IRON_HIDE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean m_8120_(ItemStack pStack) {
        return pStack.m_41613_() == 1;
    }

    @Override
    public int m_6473_() {
        return 1;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == ModEnchantments.POTENCY.get() || enchantment == ModEnchantments.DURATION.get();
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41783_() != null) {
            int SoulUse = stack.m_41783_().m_128451_(SOULUSE);
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.cost", (Object[])new Object[]{SoulUse}));
        }
    }
}

