/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.events.ArcaTeleporter;
import com.Polarice3.Goety.common.items.magic.MagicFocus;
import com.Polarice3.Goety.common.magic.spells.void_spells.CallSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class CallFocus
extends MagicFocus {
    public static final String TAG_ENTITY = "Summoned";

    public CallFocus() {
        super(new CallSpell());
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        LivingEntity livingEntity;
        if (!worldIn.f_46443_ && stack.m_41783_() != null && ((livingEntity = CallFocus.getSummon(stack.m_41783_())) == null || livingEntity.m_21224_())) {
            stack.m_41783_().m_128473_(TAG_ENTITY);
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity) {
            IOwned owned;
            LivingEntity target = (LivingEntity)entity;
            if (stack.m_41720_() instanceof CallFocus && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == player && !CallFocus.hasSummon(stack)) {
                CompoundTag compoundTag = new CompoundTag();
                if (stack.m_41782_()) {
                    compoundTag = stack.m_41783_();
                }
                CallFocus.setSummon(compoundTag, target);
                stack.m_41751_(compoundTag);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
            }
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() || player.m_6047_()) {
            if (itemstack.m_41720_() instanceof CallFocus && CallFocus.hasSummon(itemstack) && itemstack.m_41783_() != null) {
                itemstack.m_41783_().m_128473_(TAG_ENTITY);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static void call(ServerPlayer player, ItemStack stack) {
        if (CallFocus.hasSummon(stack) && stack.m_41783_() != null) {
            CompoundTag compoundTag = stack.m_41783_();
            LivingEntity livingEntity = CallFocus.getSummon(compoundTag);
            Level level = player.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (livingEntity != null) {
                    Entity entity;
                    LivingEntity original = null;
                    if (livingEntity.m_20159_() && (entity = livingEntity.m_20202_()) instanceof LivingEntity) {
                        LivingEntity vehicle = (LivingEntity)entity;
                        original = livingEntity;
                        livingEntity = vehicle;
                    }
                    if (!livingEntity.m_21224_()) {
                        ServerLevel serverWorld;
                        BlockPos blockPos = BlockFinder.SummonRadius(player.m_20183_(), (Entity)livingEntity, (Level)serverLevel);
                        if (livingEntity.f_19853_.m_46472_() == player.f_19853_.m_46472_()) {
                            IServant servant;
                            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)livingEntity, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                            if (event.isCanceled()) {
                                return;
                            }
                            livingEntity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                            MobUtil.moveDownToGround((Entity)livingEntity);
                            ModNetwork.sendToALL(new SPlayWorldSoundPacket(player.m_20183_(), SoundEvents.f_11852_, 1.0f, 1.0f));
                            ModNetwork.sendToALL(new SPlayWorldSoundPacket(blockPos, SoundEvents.f_11852_, 1.0f, 1.0f));
                            if (original instanceof IServant) {
                                servant = (IServant)original;
                                servant.setFollowing();
                            }
                            if (livingEntity instanceof IServant) {
                                servant = (IServant)livingEntity;
                                servant.setFollowing();
                            }
                        } else if (player.m_20194_() != null && (serverWorld = player.m_20194_().m_129880_(player.f_19853_.m_46472_())) != null) {
                            IServant servant;
                            Vec3 vec3 = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)livingEntity, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                            if (event.isCanceled()) {
                                return;
                            }
                            livingEntity.changeDimension(serverWorld, (ITeleporter)new ArcaTeleporter(vec3));
                            livingEntity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                            MobUtil.moveDownToGround((Entity)livingEntity);
                            ModNetwork.sendToALL(new SPlayWorldSoundPacket(player.m_20183_(), SoundEvents.f_11852_, 1.0f, 1.0f));
                            if (original instanceof IServant) {
                                servant = (IServant)original;
                                servant.setFollowing();
                            }
                            if (livingEntity instanceof IServant) {
                                servant = (IServant)livingEntity;
                                servant.setFollowing();
                            }
                        }
                    }
                }
            }
        }
    }

    public static boolean hasSummon(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && stack.m_41783_().m_128441_(TAG_ENTITY);
    }

    public static void setSummon(CompoundTag compoundTag, LivingEntity livingEntity) {
        if (compoundTag != null && livingEntity != null) {
            compoundTag.m_128362_(TAG_ENTITY, livingEntity.m_20148_());
        }
    }

    public static LivingEntity getSummon(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return CallFocus.getSummon(stack.m_41783_());
        }
        return null;
    }

    public static LivingEntity getSummon(CompoundTag compoundTag) {
        boolean flag = compoundTag.m_128441_(TAG_ENTITY);
        if (flag) {
            UUID uuid = compoundTag.m_128342_(TAG_ENTITY);
            return EntityFinder.getLivingEntityByUuiD(uuid);
        }
        return null;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CallFocus.addCallText(stack, tooltip);
    }

    public static void addCallText(ItemStack stack, List<Component> tooltip) {
        if (stack.m_41783_() != null) {
            if (!CallFocus.hasSummon(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.noSummon"));
            } else {
                LivingEntity livingEntity = CallFocus.getSummon(stack.m_41783_());
                if (livingEntity != null) {
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.summon").m_130946_(" ").m_7220_(livingEntity.m_7770_() != null ? livingEntity.m_7770_() : livingEntity.m_5446_()).m_130940_(ChatFormatting.GREEN));
                }
            }
        }
    }
}

