/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.blocks.ArcaBlock;
import com.Polarice3.Goety.common.blocks.entities.ArcaBlockEntity;
import com.Polarice3.Goety.common.events.ArcaTeleporter;
import com.Polarice3.Goety.common.items.magic.MagicFocus;
import com.Polarice3.Goety.common.magic.spells.void_spells.RecallSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.init.ModTags;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

public class RecallFocus
extends MagicFocus {
    public static final String TAG_POS = "RecallPos";
    public static final String TAG_DIMENSION = "RecallDimension";

    public RecallFocus() {
        super(new RecallSpell());
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level world = pContext.m_43725_();
        ItemStack stack = pContext.m_43722_();
        Player player = pContext.m_43723_();
        if (player != null && !stack.m_41619_() && !RecallFocus.hasRecall(stack)) {
            CompoundTag compoundTag = stack.m_41784_();
            if (stack.m_41720_() instanceof RecallFocus) {
                BlockState blockstate;
                BlockPos blockpos = pContext.m_8083_();
                BlockEntity tileEntity = world.m_7702_(blockpos);
                if (tileEntity instanceof ArcaBlockEntity) {
                    ArcaBlockEntity arcaTile = (ArcaBlockEntity)tileEntity;
                    if (pContext.m_43723_() == arcaTile.getPlayer() && arcaTile.m_58904_() != null) {
                        this.addRecallTags((ResourceKey<Level>)arcaTile.m_58904_().m_46472_(), arcaTile.m_58899_(), compoundTag);
                        stack.m_41751_(compoundTag);
                        player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                        return InteractionResult.m_19078_((boolean)world.f_46443_);
                    }
                }
                if ((blockstate = world.m_8055_(blockpos)).m_204336_(ModTags.Blocks.RECALL_BLOCKS)) {
                    this.addRecallTags((ResourceKey<Level>)world.m_46472_(), blockpos, compoundTag);
                    stack.m_41751_(compoundTag);
                    player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() || player.m_6047_()) {
            if (itemstack.m_41720_() instanceof RecallFocus && RecallFocus.hasRecall(itemstack) && itemstack.m_41783_() != null) {
                itemstack.m_41783_().m_128473_(TAG_DIMENSION);
                itemstack.m_41783_().m_128473_(TAG_POS);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static boolean recall(LivingEntity livingEntity, ItemStack stack) {
        BlockPos blockPos;
        if (RecallFocus.hasRecall(stack) && stack.m_41783_() != null && RecallFocus.getDimension(stack.m_41783_()).isPresent() && RecallFocus.getRecallBlockPos(stack.m_41783_()) != null && (blockPos = RecallFocus.getRecallBlockPos(stack.m_41783_())) != null) {
            Optional optional;
            ServerLevel serverWorld;
            if (RecallFocus.getDimension(stack.m_41783_()).get() == livingEntity.f_19853_.m_46472_()) {
                Optional optional2 = RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)livingEntity.f_19853_, (BlockPos)blockPos);
                if (optional2.isPresent()) {
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)livingEntity, (double)((Vec3)optional2.get()).f_82479_, (double)((Vec3)optional2.get()).f_82480_, (double)((Vec3)optional2.get()).f_82481_);
                    if (event.isCanceled()) {
                        return false;
                    }
                    livingEntity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    ModNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SPlayWorldSoundPacket(BlockPos.m_274561_((double)livingEntity.f_19854_, (double)livingEntity.f_19855_, (double)livingEntity.f_19856_), SoundEvents.f_11852_, 1.0f, 1.0f));
                    ModNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SPlayWorldSoundPacket(BlockPos.m_274446_((Position)((Position)optional2.get())), SoundEvents.f_11852_, 1.0f, 1.0f));
                    return true;
                }
            } else if (livingEntity.m_20194_() != null && (serverWorld = livingEntity.m_20194_().m_129880_(RecallFocus.getDimension(stack.m_41783_()).get())) != null && (optional = RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)serverWorld, (BlockPos)blockPos)).isPresent()) {
                EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)livingEntity, (double)((Vec3)optional.get()).f_82479_, (double)((Vec3)optional.get()).f_82480_, (double)((Vec3)optional.get()).f_82481_);
                if (event.isCanceled()) {
                    return false;
                }
                livingEntity.changeDimension(serverWorld, (ITeleporter)new ArcaTeleporter((Vec3)optional.get()));
                livingEntity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecall(ItemStack p_40737_) {
        CompoundTag compoundtag = p_40737_.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_(TAG_DIMENSION) || compoundtag.m_128441_(TAG_POS));
    }

    @Nullable
    public static BlockPos getRecallBlockPos(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return RecallFocus.getRecallBlockPos(itemStack.m_41783_());
        }
        return null;
    }

    public static BlockPos getRecallBlockPos(CompoundTag compoundTag) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = compoundTag.m_128441_(TAG_POS);
        boolean flag1 = compoundTag.m_128441_(TAG_DIMENSION);
        if (flag && flag1 && (optional = RecallFocus.getDimension(compoundTag)).isPresent()) {
            return NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(TAG_POS));
        }
        return null;
    }

    public static Optional<ResourceKey<Level>> getDimension(CompoundTag p_40728_) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_40728_.m_128423_(TAG_DIMENSION)).result();
    }

    public void addRecallTags(ResourceKey<Level> p_40733_, BlockPos p_40734_, CompoundTag p_40735_) {
        p_40735_.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)p_40734_));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, p_40733_).resultOrPartial(arg_0 -> ((Logger)Goety.LOGGER).error(arg_0)).ifPresent(p_40731_ -> p_40735_.m_128365_(TAG_DIMENSION, p_40731_));
    }

    public static boolean isValid(ServerLevel serverLevel, ItemStack stack) {
        BlockPos blockPos;
        ServerLevel serverLevel1;
        if (RecallFocus.hasRecall(stack) && stack.m_41783_() != null && RecallFocus.getDimension(stack.m_41783_()).isPresent() && (serverLevel1 = serverLevel.m_7654_().m_129880_(RecallFocus.getDimension(stack.m_41783_()).get())) != null && RecallFocus.getRecallBlockPos(stack.m_41783_()) != null && (blockPos = RecallFocus.getRecallBlockPos(stack.m_41783_())) != null) {
            BlockState blockState = serverLevel1.m_8055_(blockPos);
            Block block = blockState.m_60734_();
            return block instanceof ArcaBlock || blockState.m_204336_(ModTags.Blocks.RECALL_BLOCKS);
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        RecallFocus.addRecallText(stack, tooltip);
    }

    public static void addRecallText(ItemStack stack, List<Component> tooltip) {
        if (stack.m_41783_() != null) {
            if (!RecallFocus.hasRecall(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.noPos"));
            } else {
                BlockPos blockPos = RecallFocus.getRecallBlockPos(stack.m_41783_());
                if (blockPos != null && RecallFocus.getDimension(stack.m_41783_()).isPresent()) {
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.Pos").m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"info.goety.focus.PosNum", (Object[])new Object[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()})));
                    tooltip.add((Component)Component.m_237110_((String)"info.goety.focus.PosDim", (Object[])new Object[]{RecallFocus.getDimension(stack.m_41783_()).get().m_135782_().toString()}));
                }
            }
        }
    }
}

