/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.ChargingSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;

public class FeastSpell
extends ChargingSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(16.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FeastCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.FeastChargeUp.get();
    }

    @Override
    public int Cooldown() {
        return (Integer)SpellConfig.FeastDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11867_;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ILL;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.ABSORB.get());
        return list;
    }

    public List<LivingEntity> getLivingEntities(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        int i = (int)caster.m_20185_();
        int j = (int)caster.m_20186_();
        int k = (int)caster.m_20189_();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            radius *= (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0 + 1.0;
        }
        return worldIn.m_45976_(LivingEntity.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).m_82400_(radius));
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        for (LivingEntity entity : this.getLivingEntities(worldIn, caster, spellStat)) {
            if (entity == caster || MobUtil.areAllies((Entity)entity, (Entity)caster)) continue;
            BlockPos blockPos = BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20186_() - 1.0), (double)entity.m_20189_());
            BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, worldIn.m_8055_(blockPos));
            for (int i = 0; i < 4; ++i) {
                float radius = 1.0f;
                if (this.rightStaff(staff)) {
                    radius = 3.0f;
                }
                ServerParticleUtil.circularParticles(worldIn, (ParticleOptions)option, entity.m_20185_(), entity.m_20186_() + 0.25, entity.m_20189_(), radius);
            }
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int burning = spellStat.getBurning();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
        }
        for (LivingEntity entity : this.getLivingEntities(worldIn, caster, spellStat)) {
            float f = (float)Mth.m_14136_((double)(entity.m_20189_() - caster.m_20189_()), (double)(entity.m_20185_() - caster.m_20185_()));
            if (entity == caster || MobUtil.areAllies((Entity)entity, (Entity)caster)) continue;
            WandUtil.spawnFangs(caster, entity.m_20185_(), entity.m_20189_(), entity.m_20186_(), entity.m_20186_() + 1.0, f, 1, potency, burning);
            if (!this.rightStaff(staff)) continue;
            for (int i1 = 0; i1 < 5; ++i1) {
                float f1 = f + (float)i1 * (float)Math.PI * 0.4f;
                WandUtil.spawnFangs(caster, entity.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, entity.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, entity.m_20186_(), entity.m_20186_() + 1.0, f1, 0, potency, burning);
            }
        }
        for (int i1 = 0; i1 < caster.f_19853_.f_46441_.m_188503_(35) + 10; ++i1) {
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

