/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.BreathingSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BubbleStreamSpell
extends BreathingSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(8);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BubbleStreamCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.BubbleStreamChargeUp.get();
    }

    @Override
    public int shotsNumber() {
        return (Integer)SpellConfig.BubbleStreamDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BubbleStreamCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.BUBBLE_STREAM.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        Mob mob;
        if (caster instanceof Mob && (mob = (Mob)caster).m_5448_() != null) {
            int range = spellStat.getRange();
            if (WandUtil.enchantedFocus(caster)) {
                range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            }
            return mob.m_142582_((Entity)mob.m_5448_()) && (double)mob.m_20270_((Entity)mob.m_5448_()) <= (double)range + 4.0;
        }
        return super.conditionsMet(worldIn, caster, spellStat);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float potency = spellStat.getPotency();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        float damage = ((Double)SpellConfig.BubbleStreamDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        damage += potency;
        if (!worldIn.f_46443_) {
            if (this.rightStaff(staff)) {
                float flameRange = (float)range * ((float)Math.PI / 180);
                for (int i = 0; i < 3; ++i) {
                    Vec3 cast = caster.m_20154_().m_82541_().m_82496_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange).m_82524_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange);
                    BlockHitResult hitResult = worldIn.m_45547_(new ClipContext(caster.m_146892_(), caster.m_146892_().m_82549_(cast.m_82490_(10.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
                    if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
                    Vec3 pos = hitResult.m_82450_().m_82546_(cast.m_82490_(0.5));
                    BlockPos blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
                    this.dowseFire(caster, (Level)worldIn, blockPos);
                }
            }
            for (Entity target : this.getBreathTarget(caster, range)) {
                DamageSource damageSource;
                if (target == null || !target.m_6469_(damageSource = ModDamageSource.bubbleStream((Entity)caster, (Entity)caster), damage)) continue;
                int air = Math.min(target.m_20146_() + 1, target.m_6062_());
                target.m_20301_(air);
            }
        }
        worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)ModSounds.BUBBLE_STREAM.get(), this.getSoundSource(), worldIn.f_46441_.m_188501_() * 0.5f, caster.m_6100_());
    }

    private void dowseFire(LivingEntity caster, Level world, BlockPos blockPos) {
        BlockState blockstate = world.m_8055_(blockPos);
        if (blockstate.m_204336_(BlockTags.f_13076_)) {
            world.m_5898_(null, 1009, blockPos, 0);
            world.m_7471_(blockPos, false);
        } else if (AbstractCandleBlock.m_151933_((BlockState)blockstate)) {
            AbstractCandleBlock.m_151899_(null, (BlockState)blockstate, (LevelAccessor)world, (BlockPos)blockPos);
        } else if (CampfireBlock.m_51319_((BlockState)blockstate)) {
            world.m_5898_(null, 1009, blockPos, 0);
            CampfireBlock.m_152749_((Entity)caster, (LevelAccessor)world, (BlockPos)blockPos, (BlockState)blockstate);
            world.m_46597_(blockPos, (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public void showWandBreath(LivingEntity entityLiving) {
        Player player;
        int range = 0;
        if (entityLiving instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)entityLiving))) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), (LivingEntity)player);
        }
        this.breathAttack((ParticleOptions)ModParticleTypes.BUBBLE_STREAM.get(), entityLiving, true, (double)0.3f + (double)range / 10.0, 0.0);
    }
}

