/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.undead.HauntedSkull;
import com.Polarice3.Goety.common.entities.neutral.Minion;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class HauntedSkullSpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.HauntedSkullCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.HauntedSkullDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.HauntedSkullSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.HauntedSkullCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof HauntedSkull;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.SkullLimit.get();
    }

    @Override
    public void commonResultHit(ServerLevel worldIn, LivingEntity caster) {
        for (int i = 0; i < caster.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11862_);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        int burning = spellStat.getBurning();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
            burning = WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
            radius = WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        if (!this.isShifting(caster)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i = 3;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                BlockPos blockpos = caster.m_20183_().m_7918_(-2 + caster.m_217043_().m_188503_(5), 1, -2 + caster.m_217043_().m_188503_(5));
                HauntedSkull summonedentity = new HauntedSkull((EntityType<? extends Minion>)((EntityType)ModEntityType.HAUNTED_SKULL.get()), (Level)worldIn);
                summonedentity.setTrueOwner(caster);
                summonedentity.m_20035_(blockpos, 0.0f, 0.0f);
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                summonedentity.setBoundOrigin(blockpos);
                summonedentity.setLimitedLife(MathHelper.minutesToTicks(1) * duration);
                this.buffSummon(caster, (LivingEntity)summonedentity, potency);
                if (radius > 0.0) {
                    summonedentity.setExplosionPower((float)(1.0 + radius / 4.0));
                }
                if (burning > 0) {
                    summonedentity.setBurning(burning);
                }
                this.setTarget(caster, (Mob)summonedentity);
                summonedentity.setUpgraded(this.NecroPower(caster));
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(caster, (LivingEntity)summonedentity);
            }
            this.playSound(worldIn, (Entity)caster, SoundEvents.f_11862_);
        }
    }
}

