/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.AbsorbTrailParticleOption;
import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.EverChargeSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LeechingSpell
extends EverChargeSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(8);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.LeechingCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.LeechingChargeUp.get();
    }

    @Override
    public int shotsNumber() {
        return (Integer)SpellConfig.LeechingDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.LeechingCoolDown.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float potency = ((Double)SpellConfig.LeechingDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0f;
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        potency += (float)spellStat.getPotency();
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_RED);
            Vec3 targetVec = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
            Vec3 casterVec = new Vec3(caster.m_20208_(1.0), caster.m_20188_(), caster.m_20262_(1.0));
            worldIn.m_8767_((ParticleOptions)new GatherTrailParticle.Option(colorUtil, casterVec), targetVec.f_82479_, targetVec.f_82480_, targetVec.f_82481_, 0, 0.0, 0.0, 0.0, 0.5);
            for (int i = 0; i < 8; ++i) {
                targetVec = new Vec3(target.m_20208_(1.0), target.m_20187_(), target.m_20262_(1.0));
                worldIn.m_8767_((ParticleOptions)new AbsorbTrailParticleOption(casterVec, 0xAA0000, 10), targetVec.f_82479_, targetVec.f_82480_, targetVec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (target.m_6469_(ModDamageSource.lifeLeech((Entity)caster, (Entity)caster), potency)) {
                if (this.rightStaff(staff)) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 0));
                }
                this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SOUL_EAT.get());
            }
        }
    }
}

