/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.ModWitherSkull;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WitherSkullSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.WitherSkullCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.WitherSkullDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_12558_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.WitherSkullCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        Vec3 vector3d = caster.m_20252_(1.0f);
        float extraBlast = (float)(spellStat.getRadius() + (double)((float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0f));
        ModWitherSkull witherSkull = new ModWitherSkull(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
        witherSkull.m_5602_((Entity)caster);
        if (this.isShifting(caster)) {
            witherSkull.m_37629_(true);
        }
        witherSkull.setExtraDamage(spellStat.getPotency() + WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
        witherSkull.setFiery(spellStat.getBurning() + WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster));
        witherSkull.setExplosionPower(witherSkull.getExplosionPower() + extraBlast);
        worldIn.m_7967_((Entity)witherSkull);
        if (this.rightStaff(staff)) {
            for (int i = 0; i < 2; ++i) {
                ModWitherSkull witherSkull1 = new ModWitherSkull(caster.m_20185_() + vector3d.f_82479_ / 2.0 + worldIn.f_46441_.m_188583_(), caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0 + worldIn.f_46441_.m_188583_(), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
                witherSkull1.m_5602_((Entity)caster);
                if (this.isShifting(caster)) {
                    witherSkull1.m_37629_(true);
                }
                witherSkull1.setExtraDamage(spellStat.getPotency() + WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
                witherSkull1.setFiery(spellStat.getBurning() + WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster));
                witherSkull1.setExplosionPower(witherSkull.getExplosionPower() + extraBlast);
                worldIn.m_7967_((Entity)witherSkull1);
            }
        }
        this.playSound(worldIn, caster, 2.0f, (caster.m_217043_().m_188501_() - caster.m_217043_().m_188501_()) * 0.2f + 1.0f);
    }
}

