/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.util.MagicLightningTrap;
import com.Polarice3.Goety.common.entities.util.VoidLightningTrap;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ThunderstormSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ThunderstormCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.ThunderstormDuration.get();
    }

    @Override
    public int castDuration(LivingEntity caster, ItemStack staff) {
        int i = WandUtil.getStats(caster, this).getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            i += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        return (Integer)SpellConfig.ThunderstormDuration.get() * (i + 1);
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ThunderstormCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            radius += (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        if (castTime >= 20) {
            int amount = this.rightStaff(staff) ? 2 : 1;
            for (int i = 0; i < amount; ++i) {
                BlockPos blockPos = caster.m_20183_();
                LivingEntity target = this.getTarget(caster);
                if (castTime < 40 && target != null) {
                    blockPos = target.m_20183_();
                }
                BlockPos blockPos1 = blockPos.m_7918_(worldIn.m_213780_().m_216339_(-16, 16), 0, worldIn.m_213780_().m_216339_(-16, 16));
                BlockPos blockPos2 = blockPos.m_7918_(worldIn.m_213780_().m_216339_(-16, 16), 0, worldIn.m_213780_().m_216339_(-16, 16));
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                Vec3 vec32 = Vec3.m_82539_((Vec3i)blockPos2);
                MagicLightningTrap trap = new MagicLightningTrap((Level)worldIn, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                if (this.typeStaff(staff, SpellType.VOID)) {
                    trap = new VoidLightningTrap((Level)worldIn, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                trap.setOwner(caster);
                trap.setDuration(40);
                trap.setDamage(trap.getDamage() + (float)potency);
                trap.setRadius((float)((double)trap.radius() + radius / 2.0));
                if (!worldIn.m_45976_(MagicLightningTrap.class, new AABB(blockPos1)).isEmpty()) {
                    trap.m_6034_(vec32.m_7096_(), vec32.m_7098_(), vec32.m_7094_());
                }
                MobUtil.moveDownToGround(trap);
                worldIn.m_7967_((Entity)trap);
            }
        }
        super.useSpell(worldIn, caster, staff, castTime, spellStat);
    }
}

