/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.VoidShock;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VoidShockSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.VoidShockCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.VoidShockDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.VOID_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.VoidShockCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        int tickRate;
        int potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        int n = tickRate = this.rightStaff(staff) ? 2 : 5;
        if (castTime >= 10 && castTime % tickRate == 0) {
            VoidShock voidShock = new VoidShock(caster, this.getTarget(caster), (Level)worldIn);
            voidShock.m_146884_(caster.m_20182_().m_82520_((double)worldIn.m_213780_().m_216339_(-3, 3), 4.0, (double)worldIn.m_213780_().m_216339_(-3, 3)));
            voidShock.setPower(Vec3.f_82478_, 10);
            voidShock.setExtraDamage(potency);
            worldIn.m_7967_((Entity)voidShock);
            this.playSound(worldIn, voidShock, (SoundEvent)ModSounds.TELEPORT_ORB_THROW.get(), 2.0f, caster.m_6100_());
        }
        super.useSpell(worldIn, caster, staff, castTime, spellStat);
    }
}

