/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.ritual;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.blocks.entities.DarkAltarBlockEntity;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.ritual.Ritual;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class SummonRitual
extends Ritual {
    private final boolean tame;

    public SummonRitual(RitualRecipe recipe, boolean tame) {
        super(recipe);
        this.tame = tame;
    }

    @Override
    public boolean isValid(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return super.isValid(world, darkAltarPos, tileEntity, castingPlayer, activationItem, remainingAdditionalIngredients) && RitualRequirements.canSummon(world, castingPlayer, this.recipe.getEntityToSummon());
    }

    public void spawnEntity(Player castingPlayer, Entity entity, Level world) {
        if (castingPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)castingPlayer;
            CriteriaTriggers.f_10580_.m_68256_(serverPlayer, entity);
        }
        world.m_7967_(entity);
    }

    @Override
    public void finish(Level world, BlockPos blockPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem) {
        super.finish(world, blockPos, tileEntity, castingPlayer, activationItem);
        activationItem.m_41774_(1);
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        EntityType<?> entityType = this.recipe.getEntityToSummon();
        if (entityType != null) {
            IOwned owned;
            EntityType<?> entityType1;
            Entity entity = this.createSummonedEntity(entityType, world, blockPos, tileEntity, castingPlayer);
            if (entity instanceof IOwned && (entityType1 = (owned = (IOwned)entity).getVariant(castingPlayer, world, blockPos)) != null) {
                entity = this.createSummonedEntity(entityType1, world, blockPos, tileEntity, castingPlayer);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.prepareLivingEntityForSpawn(living, world, blockPos, tileEntity, castingPlayer, this.tame);
                this.initSummoned(living, world, blockPos, tileEntity, castingPlayer);
                this.spawnEntity(castingPlayer, (Entity)living, world);
            } else {
                entity.m_19890_((double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f), (float)world.f_46441_.m_188503_(360), 0.0f);
                this.spawnEntity(castingPlayer, entity, world);
            }
        }
    }

    public Entity createSummonedEntity(EntityType<?> entityType, Level world, BlockPos goldenBowlPosition, DarkAltarBlockEntity tileEntity, Player castingPlayer) {
        return entityType.m_20615_(world);
    }

    public void initSummoned(LivingEntity living, Level world, BlockPos goldenBowlPosition, DarkAltarBlockEntity tileEntity, Player castingPlayer) {
    }
}

