/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.world.features.trees.features;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.world.features.configs.ModTreeFeatureConfig;
import com.Polarice3.Goety.common.world.features.trees.features.ModTreeFeature;
import com.Polarice3.Goety.common.world.features.utils.ModFeatureLogic;
import com.Polarice3.Goety.common.world.features.utils.ModFeaturePlacers;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;

public class ChorusTreeFeature
extends ModTreeFeature<ModTreeFeatureConfig> {
    public boolean isVoid;

    public ChorusTreeFeature(Codec<ModTreeFeatureConfig> config, boolean isVoid) {
        super(config);
        this.isVoid = isVoid;
    }

    @Override
    public boolean generate(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, BiConsumer<BlockPos, BlockState> decorationPlacer, ModTreeFeatureConfig config) {
        int diameter = 2;
        int height = random.m_188503_(2) + diameter * 4;
        if (world.m_151562_(pos.m_123342_()) || world.m_151562_(pos.m_123342_() + height + diameter)) {
            return false;
        }
        int crownRadius = 8;
        for (int dx = -crownRadius; dx <= crownRadius; ++dx) {
            for (int dz = -crownRadius; dz <= crownRadius; ++dz) {
                for (int dy = 0; dy <= height + crownRadius; ++dy) {
                    Block whatsThere = world.m_8055_(pos.m_7918_(dx, dy, dz)).m_60734_();
                    if (whatsThere.m_49966_().m_60795_() || whatsThere instanceof LeavesBlock) continue;
                    return false;
                }
            }
        }
        BlockState state = world.m_8055_(pos.m_7495_());
        if (!state.m_60734_().canSustainPlant(state, (BlockGetter)world, pos.m_7495_(), Direction.UP, (IPlantable)ModBlocks.CHORUS_SAPLING.get())) {
            return false;
        }
        this.buildTrunk((LevelAccessor)world, trunkPlacer, decorationPlacer, random, pos, diameter, height, config);
        this.buildFullCrown(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, config);
        int numBranches = random.m_188503_(3) + 3;
        for (int i = 0; i <= numBranches; ++i) {
            int branchHeight = (int)((double)height * random.m_188500_() * 0.9) + height / 10;
            double branchRotation = random.m_188500_();
            this.makeSmallBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos, diameter, branchHeight, 4.0, branchRotation, 0.35, true, config);
        }
        return true;
    }

    protected void buildFullCrown(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int height, ModTreeFeatureConfig config) {
        int crownRadius = diameter * 4 + 2;
        int bvar = diameter + 2;
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height - crownRadius / 2, 0, crownRadius, 0.28, bvar, bvar + 2, 0, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, 0, crownRadius, 0.35, 2, 4, 1, true, config);
    }

    protected void buildBranchRing(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, int heightVar, int length, double tilt, int minBranches, int maxBranches, int size, boolean leafy, ModTreeFeatureConfig config) {
        int numBranches = random.m_188503_(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.m_188500_();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.m_188503_(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length - 3, (double)i * branchRotation + branchOffset, tilt, leafy, config);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length - 1, (double)i * branchRotation + branchOffset, tilt, leafy, config);
                continue;
            }
            if (size == 3) continue;
            this.makeSmallBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, config);
        }
    }

    protected void buildTrunk(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> decoPlacer, RandomSource random, BlockPos pos, int diameter, int height, ModTreeFeatureConfig config) {
        int dy;
        int dz;
        int dx;
        int hollow = diameter >> 1;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = -4; dy < 0; ++dy) {
                    BlockPos dPos;
                    int az;
                    int ax = Math.abs(dx);
                    int dist = Math.max(ax, az = Math.abs(dz)) + (Math.min(ax, az) >> 1);
                    if (dist > diameter || !ModFeaturePlacers.hasAirAround(world, dPos = pos.m_7918_(dx, dy, dz))) continue;
                    if (dist > hollow) {
                        ModFeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, dPos, config.trunkProvider);
                        continue;
                    }
                    ModFeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, dPos, config.branchProvider);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = 0; dy <= height; ++dy) {
                    int az;
                    BlockPos dPos = pos.m_7918_(dx, dy, dz);
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= diameter && dist > hollow) {
                        ModFeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, dPos, config.trunkProvider);
                    }
                    if (dist > hollow) continue;
                    if (this.isVoid) {
                        world.m_7731_(dPos, ((LiquidBlock)ModBlocks.VOID_FLUID.get()).m_49966_(), 3);
                        continue;
                    }
                    world.m_7731_(dPos, ((Block)ModBlocks.CORRUPT_CHORUS_LOG.get()).m_49966_(), 3);
                }
            }
        }
    }

    protected void makeMedBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, ModTreeFeatureConfig config) {
        BlockPos src = ModFeatureLogic.translate(pos.m_6630_(branchHeight), diameter, angle, 0.5);
        this.makeMedBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void makeMedBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos src, double length, double angle, double tilt, boolean leafy, ModTreeFeatureConfig config) {
        BlockPos dest = ModFeatureLogic.translate(src, length, angle, tilt);
        ModFeaturePlacers.drawBresenhamBranch(world, trunkPlacer, random, src, dest, config.branchProvider);
        if (leafy) {
            ChorusTreeFeature.makeLeafBlob((LevelSimulatedReader)world, leavesPlacer, random, dest, config);
        }
        int numShoots = random.m_188503_(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.m_188500_() * 0.8 + 0.2;
            double tiltVar = random.m_188500_() * 0.75 + 0.15;
            BlockPos bsrc = ModFeatureLogic.translate(src, length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, trunkPlacer, leavesPlacer, random, bsrc, slength, angle + angleVar, tilt * tiltVar, leafy, config);
        }
    }

    protected void makeSmallBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos src, double length, double angle, double tilt, boolean leafy, ModTreeFeatureConfig config) {
        BlockPos dest = ModFeatureLogic.translate(src, length, angle, tilt);
        ModFeaturePlacers.drawBresenhamBranch(world, trunkPlacer, random, src, dest, config.branchProvider);
        if (leafy) {
            float leafRad = (float)random.m_188503_(2) + 1.5f;
            ChorusTreeFeature.makeLeafBlob((LevelSimulatedReader)world, leavesPlacer, random, dest, config);
        }
    }

    protected void makeSmallBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, ModTreeFeatureConfig config) {
        BlockPos src = ModFeatureLogic.translate(pos.m_6630_(branchHeight), diameter, angle, 0.5);
        this.makeSmallBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void makeLargeBranch(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos src, double length, double angle, double tilt, boolean leafy, ModTreeFeatureConfig config) {
        BlockPos dest = ModFeatureLogic.translate(src, length, angle, tilt);
        ModFeaturePlacers.drawBresenhamBranch((LevelAccessor)world, trunkPlacer, random, src, dest, config.branchProvider);
        int reinforcements = random.m_188503_(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            ModFeaturePlacers.drawBresenhamBranch((LevelAccessor)world, trunkPlacer, random, src.m_7918_(vx, vy, vz), dest, config.branchProvider);
        }
        if (leafy) {
            ModFeaturePlacers.placeSpheroid((LevelSimulatedReader)world, leavesPlacer, ModFeaturePlacers.VALID_TREE_POS, random, dest.m_7494_(), 3.5f, 3.5f, config.leavesProvider);
        }
        int numMedBranches = random.m_188503_((int)(length / 6.0)) + random.m_188503_(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.m_188500_() * 0.3 + 0.3;
            double angleVar = random.m_188500_() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = ModFeatureLogic.translate(src, length * outVar, angle, tilt);
            this.makeMedBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, bsrc, length * 0.6, angle + angleVar, tilt, leafy, config);
        }
        int numSmallBranches = random.m_188503_(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.m_188500_() * 0.25 + 0.25;
            double angleVar = random.m_188500_() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = ModFeatureLogic.translate(src, length * outVar, angle, tilt);
            this.makeSmallBranch((LevelAccessor)world, trunkPlacer, leavesPlacer, random, bsrc, Math.max(length * 0.3, 2.0), angle + angleVar, tilt, leafy, config);
        }
    }

    protected void makeLargeBranch(WorldGenLevel world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, ModTreeFeatureConfig config) {
        BlockPos src = ModFeatureLogic.translate(pos.m_6630_(branchHeight), diameter, angle, 0.5);
        this.makeLargeBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    public static void makeLeafBlob(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> leafPlacer, RandomSource random, BlockPos leafPos, ModTreeFeatureConfig config) {
        ModFeaturePlacers.placeCircleOdd(world, leafPlacer, ModFeaturePlacers.VALID_TREE_POS, random, leafPos.m_7495_(), 2.0f, config.leavesProvider);
        ModFeaturePlacers.placeCircleOdd(world, leafPlacer, ModFeaturePlacers.VALID_TREE_POS, random, leafPos, 3.0f, config.leavesProvider);
        ModFeaturePlacers.placeCircleOdd(world, leafPlacer, ModFeaturePlacers.VALID_TREE_POS, random, leafPos.m_7494_(), 2.0f, config.leavesProvider);
    }
}

