/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class ModDispenserRegister {
    private static final Vector<AlternativeDispenseBehavior> ALTERNATIVE_DISPENSE_BEHAVIORS = new Vector();

    public static void registerAlternativeDispenseBehavior(AlternativeDispenseBehavior behavior) {
        ALTERNATIVE_DISPENSE_BEHAVIORS.add(behavior);
    }

    public static List<AlternativeDispenseBehavior> getSortedAlternativeDispenseBehaviors() {
        ArrayList<AlternativeDispenseBehavior> behaviors = new ArrayList<AlternativeDispenseBehavior>(ALTERNATIVE_DISPENSE_BEHAVIORS);
        Collections.sort(behaviors);
        return behaviors;
    }

    public static BlockPos offsetPos(BlockSource source) {
        return source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DirectionalBlock.f_52588_));
    }

    public static class AlternativeDispenseBehavior
    implements Comparable<AlternativeDispenseBehavior> {
        protected final String modId;
        protected final Item item;
        protected final BiPredicate<BlockSource, ItemStack> condition;
        protected final DispenseItemBehavior behavior;
        protected final Comparator<String> modIdComparator;

        public AlternativeDispenseBehavior(String modId, Item item, BiPredicate<BlockSource, ItemStack> condition, DispenseItemBehavior behavior) {
            this(modId, item, condition, behavior, (id1, id2) -> 0);
        }

        public AlternativeDispenseBehavior(String modId, Item item, BiPredicate<BlockSource, ItemStack> condition, DispenseItemBehavior behavior, Comparator<String> modIdComparator) {
            this.modId = modId;
            this.item = item;
            this.condition = condition;
            this.behavior = behavior;
            this.modIdComparator = modIdComparator;
        }

        @Override
        public int compareTo(AlternativeDispenseBehavior behavior) {
            return this.item == behavior.item ? this.modIdComparator.compare(this.modId, behavior.modId) : 0;
        }

        public void register() {
            DispenseItemBehavior oldBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(this.item);
            DispenserBlock.m_52672_((ItemLike)this.item, (source, stack) -> this.condition.test(source, stack) ? this.behavior.m_6115_(source, stack) : oldBehavior.m_6115_(source, stack));
        }
    }
}

