/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.blocks.entities.ShriekObeliskBlockEntity;
import com.Polarice3.Goety.common.blocks.fluids.ModFluids;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.EventTask;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.fluids.FluidType;

public class BlockFinder {
    private static final Predicate<Block> isAir = block -> block == Blocks.f_50016_ || block == Blocks.f_50627_;

    public static boolean isScytheBreak(BlockState blockState) {
        return (blockState.m_204336_(BlockTags.f_13073_) || blockState.m_60734_() instanceof BushBlock) && !(blockState.m_60734_() instanceof StemBlock);
    }

    public static boolean samePos(BlockPos blockPos1, BlockPos blockPos2) {
        if (blockPos1 == null || blockPos2 == null) {
            return false;
        }
        return blockPos1.m_123341_() == blockPos2.m_123341_() && blockPos1.m_123342_() == blockPos2.m_123342_() && blockPos1.m_123343_() == blockPos2.m_123343_();
    }

    public static double moveDownToGround(Entity entity) {
        BlockHitResult hitResult;
        HitResult rayTrace = BlockFinder.rayTrace(entity);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = entity.f_19853_.m_8055_(hitResult.m_82425_());
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                return (float)hitResult.m_82425_().m_123342_() + 1.0625f - 0.5f;
            }
            return (float)hitResult.m_82425_().m_123342_() + 1.0625f;
        }
        return entity.m_20186_();
    }

    private static HitResult rayTrace(Entity entity) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 endPos = new Vec3(entity.m_20185_(), 0.0, entity.m_20189_());
        return entity.f_19853_.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static boolean canSeeBlock(Entity looker, Vec3 vec31) {
        Vec3 vec3 = new Vec3(looker.m_20185_(), looker.m_20188_(), looker.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return looker.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, looker)).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean canSeeBlock(Entity looker, BlockPos location) {
        return BlockFinder.canSeeBlock(looker, Vec3.m_82539_((Vec3i)location));
    }

    public static double distanceFromGround(Entity entity) {
        BlockHitResult hitResult;
        HitResult rayTrace = BlockFinder.rayTrace(entity);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = entity.f_19853_.m_8055_(hitResult.m_82425_());
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                return entity.m_20186_() - (double)((float)hitResult.m_82425_().m_123342_() - 0.5f);
            }
            return entity.m_20186_() - (double)hitResult.m_82425_().m_123342_();
        }
        return 0.0;
    }

    public static double moveBlockDownToGround(Level level, BlockPos blockPos) {
        BlockHitResult hitResult;
        HitResult rayTrace = BlockFinder.blockRayTrace(level, blockPos);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = level.m_8055_(hitResult.m_82425_());
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                return (float)hitResult.m_82425_().m_123342_() + 1.0625f - 0.5f;
            }
            return (float)hitResult.m_82425_().m_123342_() + 1.0625f;
        }
        return blockPos.m_123342_();
    }

    private static HitResult blockRayTrace(Level level, BlockPos blockPos) {
        Vec3 startPos = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        Vec3 endPos = new Vec3((double)blockPos.m_123341_(), 0.0, (double)blockPos.m_123343_());
        return level.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
    }

    public static boolean hasChunksAt(LivingEntity livingEntity) {
        Level world = livingEntity.f_19853_;
        BlockPos.MutableBlockPos blockpos$mutable = livingEntity.m_20183_().m_122032_().m_122184_(0, 0, 0);
        return world.m_46812_(blockpos$mutable.m_123341_() - 10, blockpos$mutable.m_123342_() - 10, blockpos$mutable.m_123343_() - 10, blockpos$mutable.m_123341_() + 10, blockpos$mutable.m_123342_() + 10, blockpos$mutable.m_123343_() + 10);
    }

    public static boolean isEmptyBlock(BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, EntityType<?> pEntityType, boolean pWater) {
        if (pWater) {
            if (pBlockState.m_60838_(pLevel, pPos)) {
                return false;
            }
            return !pEntityType.m_20630_(pBlockState) || pFluidState.m_76178_();
        }
        if (pBlockState.m_60838_(pLevel, pPos)) {
            return false;
        }
        if (!pFluidState.m_76178_()) {
            return false;
        }
        return !pEntityType.m_20630_(pBlockState);
    }

    public static double spawnWaterY(LivingEntity livingEntity, BlockPos blockPos) {
        BlockPos blockpos = blockPos;
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            FluidState fluidState = livingEntity.f_19853_.m_6425_(blockpos);
            BlockState blockstate = livingEntity.f_19853_.m_8055_(blockpos1);
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                BlockState blockstate12;
                VoxelShape voxelshape2;
                if (!livingEntity.f_19853_.m_46801_(blockpos) && !(voxelshape2 = (blockstate12 = livingEntity.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)livingEntity.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape2.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            }
            if (!blockstate.m_60783_((BlockGetter)livingEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!livingEntity.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = livingEntity.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)livingEntity.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)livingEntity.m_20186_()) - 1);
        if (flag) {
            if (!((double)blockpos.m_123342_() + d0 > livingEntity.m_20186_() + 5.0)) {
                return (double)blockpos.m_123342_() + d0;
            }
            return livingEntity.m_20186_();
        }
        return livingEntity.m_20186_();
    }

    public static BlockPos SummonPosition(Entity entity, BlockPos blockPos) {
        return BlockFinder.SummonPosition(entity, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static BlockPos SummonPosition(Entity entity, double x, double y, double z) {
        double d3 = y;
        boolean flag = false;
        Level level = entity.f_19853_;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (level.m_46749_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > level.m_141937_()) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1 && level.m_45786_(entity) && !level.m_46855_(entity.m_20191_())) {
                flag = true;
            }
        }
        if (!flag) {
            return blockpos;
        }
        return BlockPos.m_274561_((double)x, (double)d3, (double)z);
    }

    public static Vec3 SummonPosition(Entity entity, Vec3 vec3) {
        double d3 = vec3.f_82480_;
        boolean flag = false;
        Level level = entity.f_19853_;
        Vec3 vec31 = new Vec3(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        if (level.m_46749_(BlockPos.m_274446_((Position)vec31))) {
            boolean flag1 = false;
            while (!flag1 && vec31.f_82480_ > (double)level.m_141937_()) {
                BlockPos blockpos1 = BlockPos.m_274446_((Position)vec31).m_7495_();
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                vec31 = blockpos1.m_252807_();
            }
            if (flag1 && level.m_45786_(entity) && !level.m_46855_(entity.m_20191_())) {
                flag = true;
            }
        }
        if (!flag) {
            return vec31;
        }
        return new Vec3(vec3.f_82479_, d3, vec3.f_82481_);
    }

    public static BlockPos SummonRadius(BlockPos blockPos, Entity entity, Level world) {
        return BlockFinder.SummonRadius(blockPos, entity, world, 5);
    }

    public static BlockPos SummonRadius(BlockPos blockPos, Entity entity, Level world, int radius) {
        return BlockFinder.SummonRadius(blockPos, entity, world, 64, radius);
    }

    public static BlockPos SummonRadius(BlockPos blockPos, Entity entity, Level world, int attempts, int radius) {
        for (int i = 0; i < attempts; ++i) {
            BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_().m_122184_(0, 0, 0);
            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + world.f_46441_.m_188503_(radius) - world.f_46441_.m_188503_(radius));
            blockpos$mutable.m_142448_(blockPos.m_123342_());
            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + world.f_46441_.m_188503_(radius) - world.f_46441_.m_188503_(radius));
            if (!world.m_45756_(entity, entity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || world.m_46855_(entity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || !(blockpos$mutable.m_203193_((Position)blockPos.m_252807_()) <= (double)Mth.m_144944_((int)(radius * 2)))) continue;
            blockPos = BlockFinder.SummonPosition(entity, (BlockPos)blockpos$mutable);
            break;
        }
        return blockPos;
    }

    public static BlockPos SummonAwayRadius(BlockPos blockPos, LivingEntity livingEntity, Level world, int attempts, int radius) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        for (int i = 0; i < attempts; ++i) {
            int xOffset = world.f_46441_.m_216332_(-radius, radius);
            int zOffset = world.f_46441_.m_216332_(-radius, radius);
            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + xOffset);
            blockpos$mutable.m_142448_(blockPos.m_123342_());
            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + zOffset);
            if (!world.m_45756_((Entity)livingEntity, livingEntity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || world.m_46855_(livingEntity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || !(blockpos$mutable.m_203193_((Position)blockPos.m_252807_()) >= (double)Mth.m_144944_((int)(radius / 2)))) continue;
            blockPos = BlockFinder.SummonPosition((Entity)livingEntity, (BlockPos)blockpos$mutable);
            break;
        }
        return blockPos;
    }

    public static BlockPos SummonWaterAwayRadius(BlockPos blockPos, LivingEntity livingEntity, Level world, int attempts, int radius) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        for (int i = 0; i < attempts; ++i) {
            int xOffset = world.f_46441_.m_216332_(-radius, radius);
            int yOffset = world.f_46441_.m_216332_(-radius / 2, radius / 2);
            int zOffset = world.f_46441_.m_216332_(-radius, radius);
            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + xOffset);
            blockpos$mutable.m_142448_(blockpos$mutable.m_123342_() + yOffset);
            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + zOffset);
            if (!world.m_45756_((Entity)livingEntity, livingEntity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || !BlockFinder.canSeeBlock((Entity)livingEntity, (BlockPos)blockpos$mutable) || !(blockpos$mutable.m_203193_((Position)blockPos.m_252807_()) >= (double)Mth.m_144944_((int)(radius / 2)))) continue;
            blockPos = blockpos$mutable;
            break;
        }
        return blockPos;
    }

    public static BlockPos SummonRadiusSight(BlockPos blockPos, LivingEntity looker, LivingEntity summoned, Level world, int radius) {
        for (int i = 0; i < 64; ++i) {
            BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_().m_122184_(0, 0, 0);
            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + world.f_46441_.m_188503_(radius) - world.f_46441_.m_188503_(radius));
            blockpos$mutable.m_142448_(blockPos.m_123342_());
            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + world.f_46441_.m_188503_(radius) - world.f_46441_.m_188503_(radius));
            if (!world.m_45756_((Entity)summoned, summoned.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || world.m_46855_(summoned.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || !(blockpos$mutable.m_203193_((Position)blockPos.m_252807_()) <= (double)Mth.m_144944_((int)(radius * 2))) || !BlockFinder.canSeeBlock((Entity)looker, (BlockPos)blockpos$mutable)) continue;
            blockPos = BlockFinder.SummonPosition((Entity)summoned, (BlockPos)blockpos$mutable);
            break;
        }
        return blockPos;
    }

    public static BlockPos SummonFurtherRadius(BlockPos blockPos, LivingEntity livingEntity, Level world) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        for (int i = 0; i < 64; ++i) {
            blockpos$mutable.m_142451_((int)((double)blockpos$mutable.m_123341_() + (world.f_46441_.m_188500_() - 0.5) * 16.0));
            blockpos$mutable.m_142448_(blockPos.m_123342_());
            blockpos$mutable.m_142443_((int)((double)blockpos$mutable.m_123343_() + (world.f_46441_.m_188500_() - 0.5) * 16.0));
            if (!world.m_45756_((Entity)livingEntity, livingEntity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || world.m_46855_(livingEntity.m_20191_().m_82338_((BlockPos)blockpos$mutable))) continue;
            blockPos = BlockFinder.SummonPosition((Entity)livingEntity, (BlockPos)blockpos$mutable);
            break;
        }
        return blockPos;
    }

    public static BlockPos SummonFlyingRadius(BlockPos blockPos, LivingEntity livingEntity, Level world, int radius) {
        for (int i = 0; i < 128; ++i) {
            BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_().m_122184_(0, 0, 0);
            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + world.f_46441_.m_188503_(radius) - world.f_46441_.m_188503_(radius));
            blockpos$mutable.m_142448_(blockPos.m_123342_());
            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + world.f_46441_.m_188503_(radius) - world.f_46441_.m_188503_(radius));
            if (!world.m_45756_((Entity)livingEntity, livingEntity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || world.m_46855_(livingEntity.m_20191_().m_82338_((BlockPos)blockpos$mutable)) || !(blockpos$mutable.m_203193_((Position)Vec3.m_82512_((Vec3i)blockPos)) <= (double)Mth.m_144944_((int)(radius * 2)))) continue;
            blockPos = blockpos$mutable;
            break;
        }
        return blockPos;
    }

    public static BlockPos SummonWaterRadius(LivingEntity entity, Level world) {
        return BlockFinder.SummonWaterRadius(entity.m_20183_(), entity, world);
    }

    public static BlockPos SummonWaterRadius(BlockPos blockPos, LivingEntity entity, Level world) {
        return BlockFinder.SummonWaterRadius(blockPos, entity, world, 5);
    }

    public static BlockPos SummonWaterRadius(BlockPos blockPos, LivingEntity entity, Level world, int radius) {
        return BlockFinder.SummonWaterRadius(blockPos, entity, world, 16, radius);
    }

    public static BlockPos SummonWaterRadius(BlockPos blockPos, LivingEntity livingEntity, Level world, int attempts, int radius) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        for (int i = 0; i < attempts; ++i) {
            int xOffset = world.f_46441_.m_216332_(-radius, radius);
            int yOffset = world.f_46441_.m_216332_(-radius / 2, radius / 2);
            int zOffset = world.f_46441_.m_216332_(-radius, radius);
            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + xOffset);
            blockpos$mutable.m_142448_(blockpos$mutable.m_123342_() + yOffset);
            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + zOffset);
            if (!BlockFinder.hasChunksAt(livingEntity) || !BlockFinder.isEmptyBlock((BlockGetter)world, (BlockPos)blockpos$mutable, world.m_8055_((BlockPos)blockpos$mutable), world.m_6425_((BlockPos)blockpos$mutable), (EntityType)ModEntityType.ZOMBIE_SERVANT.get(), true)) continue;
            blockPos = blockpos$mutable;
            break;
        }
        return blockPos;
    }

    public static Vec3 getRandomSpawnBehindDirection(ServerLevel serverLevel, Random random, Vec3 origin, Vec3 direction, int minRange, int maxRange) {
        direction = direction.m_82490_(-1.0);
        direction = direction.m_82524_((float)Math.toRadians(random.nextFloat(-60.0f, 60.0f)));
        direction = minRange == maxRange ? direction.m_82490_((double)minRange) : direction.m_82490_(maxRange > minRange ? (double)random.nextInt(minRange, maxRange) : (double)random.nextInt(maxRange, minRange));
        BlockPos blockPos = BlockPos.m_274446_((Position)origin.m_82549_(direction));
        BlockState blockState = serverLevel.m_8055_(blockPos);
        while (!blockState.m_60795_()) {
            blockPos = blockPos.m_7494_();
            blockState = serverLevel.m_8055_(blockPos);
            if (blockPos.m_123342_() < serverLevel.m_151558_()) continue;
        }
        BlockState blockStateDown = serverLevel.m_8055_(blockPos.m_7495_());
        while (blockStateDown.m_60795_()) {
            blockPos = blockPos.m_7495_();
            blockStateDown = serverLevel.m_8055_(blockPos.m_7495_());
            if (blockPos.m_123342_() >= serverLevel.m_141937_()) continue;
            break;
        }
        return blockPos.m_252807_();
    }

    public static Vec3 getRandomSpawnBehindDirection(ServerLevel serverLevel, Random random, Vec3 origin, Vec3 direction) {
        return BlockFinder.getRandomSpawnBehindDirection(serverLevel, random, origin, direction, 40, 64);
    }

    public static boolean findStructure(Level level, BlockPos blockPos, ResourceKey<Structure> resourceKey) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return BlockFinder.findStructure(serverLevel, blockPos, resourceKey);
        }
        return false;
    }

    public static boolean findStructure(ServerLevel serverLevel, LivingEntity livingEntity, ResourceKey<Structure> resourceKey) {
        return BlockFinder.findStructure(serverLevel, livingEntity.m_20183_(), resourceKey);
    }

    public static boolean findStructure(ServerLevel serverLevel, BlockPos blockPos, ResourceKey<Structure> resourceKey) {
        StructureStart structureStart;
        Structure structure = (Structure)serverLevel.m_215010_().m_220521_().m_175515_(Registries.f_256944_).m_6246_(resourceKey);
        if (structure != null && !(structureStart = serverLevel.m_215010_().m_220524_(blockPos, structure)).m_73602_().isEmpty()) {
            return structureStart.m_73601_().m_71051_((Vec3i)blockPos);
        }
        return false;
    }

    public static boolean findStructure(Level level, BlockPos blockPos, TagKey<Structure> structureTagKey) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return BlockFinder.findStructure(serverLevel, blockPos, structureTagKey);
        }
        return false;
    }

    public static boolean findStructure(ServerLevel serverLevel, LivingEntity livingEntity, TagKey<Structure> structureTagKey) {
        return serverLevel.m_215010_().m_220491_(livingEntity.m_20183_(), structureTagKey).m_73603_();
    }

    public static boolean findStructure(ServerLevel serverLevel, BlockPos blockPos, TagKey<Structure> structureTagKey) {
        return serverLevel.m_215010_().m_220491_(blockPos, structureTagKey).m_73603_();
    }

    public static boolean findVillageSize(ServerLevel serverLevel, BlockPos blockPos, int size) {
        PoiManager poimanager = serverLevel.m_8904_();
        List<BlockPos> list = poimanager.m_27181_(p_217747_ -> p_217747_.m_203656_(PoiTypeTags.f_215876_), blockPos, 32, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).toList();
        return list.size() >= size;
    }

    public static boolean isEmptyBox(Level level, BlockPos p_46860_) {
        return level.m_46859_(p_46860_) && level.m_46859_(p_46860_.m_7495_()) && level.m_46859_(p_46860_.m_7494_()) && level.m_46859_(p_46860_.m_122024_()) && level.m_46859_(p_46860_.m_122029_()) && level.m_46859_(p_46860_.m_122024_().m_122012_()) && level.m_46859_(p_46860_.m_122024_().m_122019_()) && level.m_46859_(p_46860_.m_122029_().m_122012_()) && level.m_46859_(p_46860_.m_122029_().m_122019_()) && level.m_46859_(p_46860_.m_122012_()) && level.m_46859_(p_46860_.m_122019_()) && level.m_46859_(p_46860_.m_7494_().m_122024_()) && level.m_46859_(p_46860_.m_7494_().m_122029_()) && level.m_46859_(p_46860_.m_7494_().m_122024_().m_122012_()) && level.m_46859_(p_46860_.m_7494_().m_122024_().m_122019_()) && level.m_46859_(p_46860_.m_7494_().m_122029_().m_122012_()) && level.m_46859_(p_46860_.m_7494_().m_122029_().m_122019_()) && level.m_46859_(p_46860_.m_7494_().m_122012_()) && level.m_46859_(p_46860_.m_7494_().m_122019_()) && level.m_46859_(p_46860_.m_7495_().m_122024_()) && level.m_46859_(p_46860_.m_7495_().m_122029_()) && level.m_46859_(p_46860_.m_7495_().m_122024_().m_122012_()) && level.m_46859_(p_46860_.m_7495_().m_122024_().m_122019_()) && level.m_46859_(p_46860_.m_7495_().m_122029_().m_122012_()) && level.m_46859_(p_46860_.m_7495_().m_122029_().m_122019_()) && level.m_46859_(p_46860_.m_7495_().m_122012_()) && level.m_46859_(p_46860_.m_7495_().m_122019_());
    }

    public static boolean emptySpaceBetween(Level level, BlockPos blockPos, int distance, boolean up) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        boolean flag = false;
        if (up) {
            while (blockpos$mutable.m_123342_() < blockPos.m_123342_() + distance && level.m_8055_((BlockPos)blockpos$mutable).m_60812_((BlockGetter)level, (BlockPos)blockpos$mutable).m_83281_()) {
                blockpos$mutable.m_122173_(Direction.UP);
                flag = true;
            }
        } else {
            while (blockpos$mutable.m_123342_() > blockPos.m_123342_() - distance && level.m_8055_((BlockPos)blockpos$mutable).m_60812_((BlockGetter)level, (BlockPos)blockpos$mutable).m_83281_()) {
                blockpos$mutable.m_122173_(Direction.DOWN);
                flag = true;
            }
        }
        if (!level.m_8055_((BlockPos)blockpos$mutable).m_60812_((BlockGetter)level, (BlockPos)blockpos$mutable).m_83281_()) {
            flag = false;
        }
        return flag;
    }

    public static boolean emptySquareSpace(Level level, BlockPos blockPos, int distance, boolean up) {
        return BlockFinder.emptySpaceBetween(level, blockPos, distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122012_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122019_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122024_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122029_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122024_().m_122012_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122024_().m_122019_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122029_().m_122012_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122029_().m_122019_(), distance, up);
    }

    public static boolean getVerticalBlock(Level level, BlockPos blockPos, BlockState blockState, int distance, boolean up) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        boolean flag = false;
        if (up) {
            while (blockpos$mutable.m_123342_() < blockPos.m_123342_() + distance && level.m_8055_((BlockPos)blockpos$mutable).m_60795_()) {
                blockpos$mutable.m_122173_(Direction.UP);
                flag = true;
            }
        } else {
            while (blockpos$mutable.m_123342_() > blockPos.m_123342_() - distance && level.m_8055_((BlockPos)blockpos$mutable).m_60795_()) {
                blockpos$mutable.m_122173_(Direction.DOWN);
                flag = true;
            }
        }
        if (level.m_8055_((BlockPos)blockpos$mutable) != blockState) {
            flag = false;
        }
        return flag;
    }

    public static Iterable<BlockPos> multiBlockBreak(LivingEntity livingEntity, BlockPos blockPos, int x, int y, int z) {
        BlockHitResult blockHitResult = MobUtil.rayTrace((Entity)livingEntity, 10.0, false);
        Direction direction = blockHitResult.m_82434_();
        boolean hasX = direction.m_122429_() == 0;
        boolean hasY = direction.m_122430_() == 0;
        boolean hasZ = direction.m_122431_() == 0;
        Vec3i start = new Vec3i(hasX ? -x : 0, hasY ? -y : 0, hasZ ? -z : 0);
        Vec3i end = new Vec3i(hasX ? x : 0, hasY ? y * 2 - 1 : 0, hasZ ? z : 0);
        return BlockPos.m_121940_((BlockPos)blockPos.m_121955_(start), (BlockPos)blockPos.m_121955_(end));
    }

    public static void spawnRedstoneParticles(Level pLevel, BlockPos pPos) {
        double d0 = 0.5625;
        RandomSource random = pLevel.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pPos.m_121945_(direction);
            if (pLevel.m_8055_(blockpos).m_60804_((BlockGetter)pLevel, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.m_188501_();
            pLevel.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pPos.m_123341_() + d1, (double)pPos.m_123342_() + d2, (double)pPos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    public static BlockState findBlock(Level pLevel, BlockPos initial, int range) {
        return BlockFinder.findBlock(pLevel, initial, range, range, range);
    }

    public static BlockState findBlock(Level pLevel, BlockPos initial, int xRange, int yRange, int zRange) {
        BlockState blockState = pLevel.m_8055_(initial);
        for (int i = -xRange; i <= xRange; ++i) {
            for (int j = -yRange; j <= yRange; ++j) {
                for (int k = -zRange; k <= zRange; ++k) {
                    BlockPos blockpos1 = initial.m_7918_(i, j, k);
                    blockState = pLevel.m_8055_(blockpos1);
                }
            }
        }
        return blockState;
    }

    @Nullable
    public static BlockEntity findBlockEntity(BlockEntityType<?> blockEntityType, Level pLevel, BlockPos initial, int range) {
        return BlockFinder.findBlockEntity(blockEntityType, pLevel, initial, range, range, range);
    }

    @Nullable
    public static BlockEntity findBlockEntity(BlockEntityType<?> blockEntityType, Level pLevel, BlockPos initial, int xRange, int yRange, int zRange) {
        for (int i = -xRange; i <= xRange; ++i) {
            for (int j = -yRange; j <= yRange; ++j) {
                for (int k = -zRange; k <= zRange; ++k) {
                    BlockEntity blockEntity;
                    BlockPos blockPos = initial.m_7918_(i, j, k);
                    if (pLevel.m_7702_(blockPos) == null || (blockEntity = pLevel.m_7702_(blockPos)) == null || blockEntity.m_58903_() != blockEntityType) continue;
                    return blockEntity;
                }
            }
        }
        return null;
    }

    public static void copyValues(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof SlabBlock && newBlock.m_60734_() instanceof SlabBlock) {
            BlockFinder.copySlab(level, blockPos, newBlock, oldBlock);
        } else if (oldBlock.m_60734_() instanceof StairBlock && newBlock.m_60734_() instanceof StairBlock) {
            BlockFinder.copyStairs(level, blockPos, newBlock, oldBlock);
        } else if (oldBlock.m_60734_() instanceof WallBlock && newBlock.m_60734_() instanceof WallBlock) {
            BlockFinder.copyWalls(level, blockPos, newBlock, oldBlock);
        }
    }

    public static void copySlab(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof SlabBlock && newBlock.m_60734_() instanceof SlabBlock) {
            level.m_46597_(blockPos, (BlockState)newBlock.m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)oldBlock.m_61143_((Property)SlabBlock.f_56353_))));
        }
    }

    public static void copyStairs(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof StairBlock && newBlock.m_60734_() instanceof StairBlock) {
            level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)newBlock.m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)oldBlock.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)oldBlock.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)oldBlock.m_61143_((Property)StairBlock.f_56843_))));
        }
    }

    public static void copyWalls(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof WallBlock && newBlock.m_60734_() instanceof WallBlock) {
            level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newBlock.m_61124_((Property)WallBlock.f_57949_, (Comparable)((Boolean)oldBlock.m_61143_((Property)WallBlock.f_57949_)))).m_61124_((Property)WallBlock.f_57953_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57953_)))).m_61124_((Property)WallBlock.f_57950_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57950_)))).m_61124_((Property)WallBlock.f_57951_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57951_)))).m_61124_((Property)WallBlock.f_57952_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57952_))));
        }
    }

    public static boolean canBeReplaced(Level pLevel, BlockPos pReplaceablePos) {
        return BlockFinder.canBeReplaced(pLevel, pReplaceablePos, pReplaceablePos);
    }

    public static boolean canBeReplaced(Level pLevel, BlockPos pReplaceablePos, BlockPos pReplacedBlockPos) {
        return pLevel.m_8055_(pReplaceablePos).m_60629_((BlockPlaceContext)new DirectionalPlaceContext(pLevel, pReplacedBlockPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
    }

    public static Optional<BlockPos> findLightningRod(ServerLevel serverLevel, BlockPos blockPos) {
        return BlockFinder.findLightningRod(serverLevel, blockPos, 128);
    }

    public static Optional<BlockPos> findLightningRod(ServerLevel serverLevel, BlockPos blockPos, int range) {
        Optional optional = serverLevel.m_8904_().m_148658_(poiTypeHolder -> poiTypeHolder.m_203565_(PoiTypes.f_218066_), blockPos1 -> blockPos1.m_123342_() == serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, blockPos1.m_123341_(), blockPos1.m_123343_()) - 1, blockPos, range, PoiManager.Occupancy.ANY);
        return optional.map(blockPos1 -> blockPos1.m_6630_(1));
    }

    public static Optional<BlockPos> findNetherPortal(ServerLevel serverLevel, BlockPos blockPos, int range) {
        return serverLevel.m_8904_().m_27192_(poiTypeHolder -> poiTypeHolder.m_203565_(PoiTypes.f_218064_), blockPos, range, PoiManager.Occupancy.ANY);
    }

    public static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_((Property)BlockStateProperties.f_61401_);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && blockstate.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            pLevel.m_7731_(blockpos, blockstate1, 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public static List<Vec3> buildBlockCircle(double radius) {
        int intRadius = (int)radius;
        double radiusSq = radius * radius;
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        for (int x = -intRadius; x < intRadius; ++x) {
            for (int z = -intRadius; z < intRadius; ++z) {
                Vec3 pos = new Vec3((double)x, 0.0, (double)z);
                if (!(pos.m_82556_() <= radiusSq)) continue;
                points.add(pos);
            }
        }
        return points;
    }

    public static List<Vec3> buildBlockCircle(Vec3 position, double radius) {
        ArrayList<Vec3> properPos = new ArrayList<Vec3>();
        for (Vec3 value : BlockFinder.buildBlockCircle(radius)) {
            properPos.add(position.m_82549_(value));
        }
        return properPos;
    }

    public static List<Vec3> buildOuterBlockCircle(Vec3 position, double radius, double reduction) {
        List<Vec3> properPos = BlockFinder.buildBlockCircle(position, radius);
        for (Vec3 value : BlockFinder.buildBlockCircle(position, reduction)) {
            properPos.remove(value);
        }
        return properPos;
    }

    public static List<Vec3> buildOuterBlockCircle(Vec3 position, double radius) {
        return BlockFinder.buildOuterBlockCircle(position, radius, radius - 1.0);
    }

    public static boolean findIllagerWard(ServerLevel level, Player player, int soulEnergy) {
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                LevelChunk levelchunk = level.m_46745_(player.m_20183_().m_7918_(i * 16, 0, j * 16));
                for (BlockEntity blockentity : levelchunk.m_62954_().values()) {
                    if (!(blockentity instanceof ShriekObeliskBlockEntity)) continue;
                    ShriekObeliskBlockEntity obelisk = (ShriekObeliskBlockEntity)blockentity;
                    int radius = obelisk.getPower();
                    AABB alignedBB = new AABB(obelisk.m_58899_()).m_82400_((double)radius);
                    if (!player.m_20191_().m_82381_(alignedBB)) continue;
                    return obelisk.shriek(level, player, soulEnergy);
                }
            }
        }
        return false;
    }

    public static boolean hasSunlight(Level level, BlockPos blockPos) {
        return level.m_45527_(blockPos) && level.m_46461_();
    }

    public static boolean getNearbyLitCandles(Level pLevel, BlockPos pPos, int range, int totalCount) {
        return BlockFinder.getNearbyLitCandles(pLevel, pPos, range, range, range, totalCount);
    }

    public static boolean getNearbyLitCandles(Level pLevel, BlockPos pPos, int xRange, int yRange, int zRange, int totalCount) {
        int currentCount = 0;
        for (int i = -xRange; i <= xRange; ++i) {
            for (int j = -yRange; j <= yRange; ++j) {
                for (int k = -zRange; k <= zRange; ++k) {
                    BlockPos blockpos1 = pPos.m_7918_(i, j, k);
                    BlockState blockstate = pLevel.m_8055_(blockpos1);
                    if (!blockstate.m_204336_(BlockTags.f_144265_) || !blockstate.m_61138_((Property)CandleBlock.f_152791_) || !((Boolean)blockstate.m_61143_((Property)CandleBlock.f_152791_)).booleanValue() || !blockstate.m_61138_((Property)CandleBlock.f_152790_)) continue;
                    currentCount += ((Integer)blockstate.m_61143_((Property)CandleBlock.f_152790_)).intValue();
                }
            }
        }
        return currentCount >= totalCount;
    }

    public static boolean getNearbyBlocks(Level pLevel, BlockPos pPos, Predicate<BlockState> pPredicate, int range, int totalCount) {
        return BlockFinder.getNearbyBlocks(pLevel, pPos, pPredicate, range, range, range, totalCount);
    }

    public static boolean getNearbyBlocks(Level pLevel, BlockPos pPos, Predicate<BlockState> pPredicate, int xRange, int yRange, int zRange, int totalCount) {
        int currentCount = 0;
        for (int i = -xRange; i <= xRange; ++i) {
            for (int j = -yRange; j <= yRange; ++j) {
                for (int k = -zRange; k <= zRange; ++k) {
                    BlockPos blockpos1 = pPos.m_7918_(i, j, k);
                    BlockState blockstate = pLevel.m_8055_(blockpos1);
                    if (!pPredicate.test(blockstate)) continue;
                    ++currentCount;
                }
            }
        }
        return currentCount >= totalCount;
    }

    public static boolean getNearbyEnchantPower(Level pLevel, BlockPos pPos, int range, int enchantPower) {
        return BlockFinder.getNearbyEnchantPower(pLevel, pPos, range, range, range, enchantPower);
    }

    public static boolean getNearbyEnchantPower(Level pLevel, BlockPos pPos, int xRange, int yRange, int zRange, int enchantPower) {
        int currentCount = 0;
        for (int i = -xRange; i <= xRange; ++i) {
            for (int j = -yRange; j <= yRange; ++j) {
                for (int k = -zRange; k <= zRange; ++k) {
                    BlockPos blockpos1 = pPos.m_7918_(i, j, k);
                    BlockState blockstate = pLevel.m_8055_(blockpos1);
                    if (!(blockstate.getEnchantPowerBonus((LevelReader)pLevel, blockpos1) > 0.0f)) continue;
                    currentCount += (int)blockstate.getEnchantPowerBonus((LevelReader)pLevel, blockpos1);
                }
            }
        }
        return currentCount >= enchantPower;
    }

    public static BlockPos findGroundBelow(Level level, BlockPos pos, Function<BlockPos, Boolean> isOpenBlock) {
        int bottomY = level.m_141937_();
        for (int i = pos.m_123342_(); i >= bottomY + 1; --i) {
            BlockPos tempPos = new BlockPos(pos.m_123341_(), i, pos.m_123343_());
            if (!level.m_8055_(tempPos).m_60659_((BlockGetter)level, tempPos, Direction.UP, SupportType.FULL) || !isOpenBlock.apply(tempPos.m_7494_()).booleanValue()) continue;
            return tempPos;
        }
        return new BlockPos(pos.m_123341_(), bottomY, pos.m_123343_());
    }

    public static boolean breakBlock(Level level, BlockPos blockPos, ItemStack itemStack, @Nullable Entity entity) {
        BlockState blockstate = level.m_8055_(blockPos);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = level.m_6425_(blockPos);
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
        }
        BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(blockPos) : null;
        Block.m_49881_((BlockState)blockstate, (Level)level, (BlockPos)blockPos, (BlockEntity)blockentity, (Entity)entity, (ItemStack)itemStack);
        boolean flag = level.m_6933_(blockPos, fluidstate.m_76188_(), 3, 512);
        if (flag) {
            level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockstate));
        }
        return flag;
    }

    public static boolean isPassableBlock(Level level, BlockPos blockPos) {
        return level.m_8055_(blockPos).m_60812_((BlockGetter)level, blockPos).m_83281_();
    }

    public static void voidedEffect(Level pLevel, BlockState pState, Entity pEntity) {
        LivingEntity livingEntity;
        if (pEntity instanceof LivingEntity && !CuriosFinder.hasVoidRobe(livingEntity = (LivingEntity)pEntity) && !livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.VOID_TOUCHED_IMMUNE) && livingEntity.m_7301_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get()))) {
            livingEntity.m_7601_(pState, new Vec3(0.8, 1.0, 0.8));
            BlockFinder.voidedEffect(pLevel, livingEntity);
        }
    }

    public static void voidedEffect(Level pLevel, LivingEntity pEntity) {
        if (!CuriosFinder.hasVoidRobe(pEntity) && !pEntity.m_6095_().m_204039_(ModTags.EntityTypes.VOID_TOUCHED_IMMUNE) && pEntity.m_7301_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get())) && !pLevel.f_46443_) {
            boolean flag;
            MobEffectInstance instance = pEntity.m_21124_((MobEffect)GoetyEffects.VOID_TOUCHED.get());
            float damage = pEntity.m_21233_() * 0.05f;
            boolean bl = flag = pEntity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || pEntity.m_6095_().m_204039_(ModTags.EntityTypes.MINI_BOSSES) || (double)pEntity.m_21233_() >= 200.0;
            if (flag) {
                damage = 1.0f;
            }
            if (instance == null) {
                if (pEntity.m_6469_(ModDamageSource.getDamageSource(pLevel, ModDamageSource.VOIDED, new EntityType[0]), damage)) {
                    pEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), flag ? 0 : 2, false, true));
                }
            } else if (pEntity.f_19797_ % 20 == 0 && pEntity.m_6469_(ModDamageSource.getDamageSource(pLevel, ModDamageSource.VOIDED, new EntityType[0]), damage)) {
                if (!flag) {
                    EffectsUtil.increaseEffect(pEntity, (MobEffect)GoetyEffects.VOID_TOUCHED.get(), 9, false, true);
                } else {
                    pEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), 0, false, true));
                }
            }
        }
    }

    public static boolean isInVoid(Entity entity) {
        return entity.f_19797_ > 1 && entity.getFluidTypeHeight((FluidType)ModFluids.VOID_FLUID_TYPE.get()) > 0.0;
    }

    public static boolean canTeleportTo(LivingEntity entity, double x, double y, double z) {
        double d3 = y;
        boolean flag = false;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Level level = entity.m_9236_();
        if (level.m_46805_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > level.m_141937_()) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                AABB aabb = entity.m_20191_().m_82386_(x, d3, z);
                EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)entity, (double)x, (double)d3, (double)z);
                if (event.isCanceled()) {
                    return false;
                }
                if (level.m_45772_(aabb) && !level.m_46855_(aabb)) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    public static class ChopTreeTask
    implements EventTask {
        UUID owner;
        ItemStack axe;
        ServerLevel level;
        Int2ObjectMap<Queue<BlockPos>> hits = new Int2ObjectOpenHashMap();
        int ticks = 0;

        public ChopTreeTask(UUID owner, ItemStack axe, ServerLevel level, BlockPos pos) {
            this.owner = owner;
            this.axe = axe;
            this.level = level;
            ((Queue)this.hits.computeIfAbsent(pos.m_123342_(), i -> new ArrayDeque())).add(pos);
        }

        @Override
        public boolean getAsBoolean() {
            if (++this.ticks % 2 != 0) {
                return false;
            }
            if (this.axe.m_41619_()) {
                return true;
            }
            int minY = this.hits.keySet().intStream().min().getAsInt();
            Queue queue = (Queue)this.hits.get(minY);
            int breaks = 0;
            while (!queue.isEmpty()) {
                BlockPos pos = (BlockPos)queue.poll();
                for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                    BlockState state;
                    if (blockPos.equals((Object)pos) || !(state = this.level.m_8055_(blockPos)).m_204336_(BlockTags.f_13106_)) continue;
                    ChopTreeTask.breakExtraBlock(this.level, blockPos, this.axe, this.owner);
                    if (this.level.m_8055_(blockPos).m_204336_(BlockTags.f_13106_)) continue;
                    ((Queue)this.hits.computeIfAbsent(blockPos.m_123342_(), i -> new ArrayDeque())).add(blockPos.m_7949_());
                    ++breaks;
                }
                if (breaks <= 5) continue;
                break;
            }
            if (queue.isEmpty()) {
                this.hits.remove(minY);
            }
            return this.hits.isEmpty();
        }

        public static boolean breakExtraBlock(ServerLevel world, BlockPos pos, ItemStack mainhand, @Nullable UUID source) {
            boolean removed;
            FakePlayer player;
            BlockState blockstate = world.m_8055_(pos);
            if (source != null) {
                player = FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(source, UsernameCache.getLastKnownUsername((UUID)source)));
                Player realPlayer = world.m_46003_(source);
                if (realPlayer != null) {
                    player.m_146884_(realPlayer.m_20182_());
                }
            } else {
                player = FakePlayerFactory.getMinecraft((ServerLevel)world);
            }
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainhand);
            if (blockstate.m_60800_((BlockGetter)world, pos) < 0.0f || !blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player)) {
                return false;
            }
            GameType type = player.m_150110_().f_35937_ ? GameType.CREATIVE : GameType.SURVIVAL;
            int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
            if (exp == -1) {
                return false;
            }
            BlockEntity tileentity = world.m_7702_(pos);
            Block block = blockstate.m_60734_();
            if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.m_36337_()) {
                world.m_7260_(pos, blockstate, blockstate, 3);
                return false;
            }
            if (mainhand.onBlockStartBreak(pos, (Player)player)) {
                return false;
            }
            if (player.m_36187_((Level)world, pos, type)) {
                return false;
            }
            ItemStack itemstack1 = mainhand.m_41777_();
            boolean canHarvest = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
            mainhand.m_41686_((Level)world, blockstate, pos, (Player)player);
            if (mainhand.m_41619_() && !itemstack1.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            if ((removed = ChopTreeTask.removeBlock(world, (ServerPlayer)player, pos, canHarvest)) && canHarvest) {
                block.m_6240_((Level)world, (Player)player, pos, blockstate, tileentity, itemstack1);
            }
            if (removed && exp > 0) {
                blockstate.m_60734_().m_49805_(world, pos, exp);
            }
            return true;
        }

        public static boolean removeBlock(ServerLevel world, ServerPlayer player, BlockPos pos, boolean canHarvest) {
            BlockState state = world.m_8055_(pos);
            boolean removed = state.onDestroyedByPlayer((Level)world, pos, (Player)player, canHarvest, world.m_6425_(pos));
            if (removed) {
                state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
            }
            return removed;
        }
    }
}

