/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ColorUtil {
    public static ColorUtil WHITE = new ColorUtil(0xFFFFFF);
    public static ColorUtil BLACK = new ColorUtil(0);
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public ColorUtil(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public ColorUtil(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 1.0f;
    }

    public ColorUtil(int red, int green, int blue, float alpha) {
        this.red = (float)red / 255.0f;
        this.green = (float)green / 255.0f;
        this.blue = (float)blue / 255.0f;
        this.alpha = alpha;
    }

    public ColorUtil(int colorCode) {
        Color color = Color.decode(String.valueOf(colorCode));
        this.red = (float)color.getRed() / 255.0f;
        this.green = (float)color.getGreen() / 255.0f;
        this.blue = (float)color.getBlue() / 255.0f;
        this.alpha = 1.0f;
    }

    public ColorUtil(MapColor mapColor) {
        this(mapColor.f_283871_);
    }

    public ColorUtil(ChatFormatting format) {
        this(format.m_126665_() != null ? format.m_126665_() : 0);
    }

    public float red() {
        return this.red;
    }

    public float green() {
        return this.green;
    }

    public float blue() {
        return this.blue;
    }

    public float alpha() {
        return this.alpha;
    }

    public static class ARGB {
        public static int alpha(int i) {
            return i >>> 24;
        }

        public static int red(int i) {
            return i >> 16 & 0xFF;
        }

        public static int green(int i) {
            return i >> 8 & 0xFF;
        }

        public static int blue(int i) {
            return i & 0xFF;
        }

        public static int color(int alpha, int red, int green, int blue) {
            return alpha << 24 | red << 16 | green << 8 | blue;
        }

        public static int color(int red, int green, int blue) {
            return ARGB.color(255, red, green, blue);
        }

        public static int color(Vec3 vec3) {
            return ARGB.color(ARGB.as8BitChannel((float)vec3.m_7096_()), ARGB.as8BitChannel((float)vec3.m_7098_()), ARGB.as8BitChannel((float)vec3.m_7094_()));
        }

        public static int multiply(int color, int alpha) {
            if (color == -1) {
                return alpha;
            }
            return alpha == -1 ? color : ARGB.color(ARGB.alpha(color) * ARGB.alpha(alpha) / 255, ARGB.red(color) * ARGB.red(alpha) / 255, ARGB.green(color) * ARGB.green(alpha) / 255, ARGB.blue(color) * ARGB.blue(alpha) / 255);
        }

        public static int scaleRGB(int color, float alpha) {
            return ARGB.scaleRGB(color, alpha, alpha, alpha);
        }

        public static int scaleRGB(int color, float redAlpha, float greenAlpha, float blueAlpha) {
            return ARGB.color(ARGB.alpha(color), Mth.m_14045_((int)((int)((float)ARGB.red(color) * redAlpha)), (int)0, (int)255), Mth.m_14045_((int)((int)((float)ARGB.green(color) * greenAlpha)), (int)0, (int)255), Mth.m_14045_((int)((int)((float)ARGB.blue(color) * blueAlpha)), (int)0, (int)255));
        }

        public static int scaleRGB(int color, int alpha) {
            return ARGB.color(ARGB.alpha(color), Mth.m_14045_((int)(ARGB.red(color) * alpha / 255), (int)0, (int)255), Mth.m_14045_((int)(ARGB.green(color) * alpha / 255), (int)0, (int)255), Mth.m_14045_((int)(ARGB.blue(color) * alpha / 255), (int)0, (int)255));
        }

        public static int greyscale(int color) {
            int j = (int)((float)ARGB.red(color) * 0.3f + (float)ARGB.green(color) * 0.59f + (float)ARGB.blue(color) * 0.11f);
            return ARGB.color(j, j, j);
        }

        public static int lerp(float partialTick, int colorFrom, int colorTo) {
            return FastColor.ARGB32.m_269105_((float)partialTick, (int)colorFrom, (int)colorTo);
        }

        public static int opaque(int color) {
            return FastColor.ABGR32.m_267818_((int)color);
        }

        public static int transparent(int color) {
            return FastColor.ABGR32.m_266533_((int)color);
        }

        public static int color(int alpha, int color) {
            return alpha << 24 | color & 0xFFFFFF;
        }

        public static int white(float alpha) {
            return ARGB.as8BitChannel(alpha) << 24 | 0xFFFFFF;
        }

        public static int colorFromFloat(float alpha, float red, float green, float blue) {
            return ARGB.color(ARGB.as8BitChannel(alpha), ARGB.as8BitChannel(red), ARGB.as8BitChannel(green), ARGB.as8BitChannel(blue));
        }

        public static Vector3f vector3fFromRGB24(int color) {
            float f = (float)ARGB.red(color) / 255.0f;
            float g = (float)ARGB.green(color) / 255.0f;
            float h = (float)ARGB.blue(color) / 255.0f;
            return new Vector3f(f, g, h);
        }

        public static int average(int color, int color2) {
            return ARGB.color((ARGB.alpha(color) + ARGB.alpha(color2)) / 2, (ARGB.red(color) + ARGB.red(color2)) / 2, (ARGB.green(color) + ARGB.green(color2)) / 2, (ARGB.blue(color) + ARGB.blue(color2)) / 2);
        }

        public static int as8BitChannel(float f) {
            return Mth.m_14143_((float)(f * 255.0f));
        }

        public static float alphaFloat(int i) {
            return ARGB.from8BitChannel(ARGB.alpha(i));
        }

        public static float redFloat(int i) {
            return ARGB.from8BitChannel(ARGB.red(i));
        }

        public static float greenFloat(int i) {
            return ARGB.from8BitChannel(ARGB.green(i));
        }

        public static float blueFloat(int i) {
            return ARGB.from8BitChannel(ARGB.blue(i));
        }

        private static float from8BitChannel(int i) {
            return (float)i / 255.0f;
        }

        public static int toABGR(int i) {
            return i & 0xFF00FF00 | (i & 0xFF0000) >> 16 | (i & 0xFF) << 16;
        }

        public static int fromABGR(int i) {
            return ARGB.toABGR(i);
        }
    }
}

