/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.entities;

import com.Polarice3.Goety.api.blocks.entities.IOwnedBlock;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServantUtil;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public interface IOwned {
    public static final UUID SPEED_MODIFIER_UUID = UUID.fromString("9c47949c-b896-4802-8e8a-f08c50791a8a");
    public static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_UUID, "Staying speed penalty", -1.0, AttributeModifier.Operation.ADDITION);

    public LivingEntity getTrueOwner();

    public UUID getOwnerId();

    public void setOwnerId(@Nullable UUID var1);

    default public void setOwnerClientId(int id) {
    }

    default public void setTrueOwner(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setOwnerId(livingEntity.m_20148_());
            this.setOwnerClientId(livingEntity.m_19879_());
        }
    }

    default public void copyTrueOwner(IOwned owned) {
        if (owned.getOwnerId() != null) {
            this.setOwnerId(owned.getOwnerId());
        }
        this.setOwnerClientId(owned.getOwnerClientId());
    }

    default public void copyTrueOwner(IOwnedBlock owned) {
        if (owned.getOwnerUUID() != null) {
            this.setOwnerId(owned.getOwnerUUID());
        }
        this.setOwnerClientId(owned.getOwnerId());
    }

    public void setHostile(boolean var1);

    public boolean isHostile();

    @Nullable
    default public EntityType<?> getVariant(@Nullable Player player, Level level, BlockPos blockPos) {
        return this.getVariant(level, blockPos);
    }

    @Nullable
    default public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        return null;
    }

    default public LivingEntity getMasterOwner() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof IOwned) {
            IOwned owned = (IOwned)livingEntity;
            return owned.getTrueOwner();
        }
        return this.getTrueOwner();
    }

    default public int getOwnerClientId() {
        return -1;
    }

    default public void convertNewEquipment(Entity entity) {
    }

    default public void setLimitedLife(int limitedLifeTicksIn) {
        this.setHasLifespan(true);
        this.setLifespan(limitedLifeTicksIn);
    }

    default public void setHasLifespan(boolean lifespan) {
    }

    default public boolean hasLifespan() {
        return false;
    }

    default public void setLifespan(int lifespan) {
    }

    default public int getLifespan() {
        return 0;
    }

    default public boolean isLimitedLife() {
        return this.getLifespan() > 0;
    }

    default public void setNatural(boolean natural) {
    }

    default public boolean isNatural() {
        return false;
    }

    default public boolean isChargingCrossbow() {
        return false;
    }

    default public void setFamiliar() {
    }

    default public boolean isFamiliar() {
        return false;
    }

    default public boolean canBeFamiliar() {
        return false;
    }

    default public void onCeaseFire(ServerPlayer player) {
    }

    default public void onStopAttack() {
        IOwned iOwned = this;
        if (iOwned instanceof Entity) {
            Entity entity = (Entity)iOwned;
            Level level = entity.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7605_(entity, (byte)20);
            }
        }
    }

    default public void checkHostility() {
        IOwned iOwned = this;
        if (iOwned instanceof Entity) {
            Entity entity = (Entity)iOwned;
            if (!entity.f_19853_.f_46443_) {
                IOwned owned;
                LivingEntity livingEntity;
                if (this.getTrueOwner() instanceof Enemy) {
                    this.setHostile(true);
                }
                if ((livingEntity = this.getTrueOwner()) instanceof IOwned && (owned = (IOwned)livingEntity).isHostile()) {
                    this.setHostile(true);
                }
                if (this instanceof Enemy) {
                    this.setHostile(true);
                }
            }
        }
    }

    default public void ownedTick() {
        IOwned iOwned = this;
        if (iOwned instanceof Mob) {
            Mob mob = (Mob)iOwned;
            if (!mob.f_19853_.f_46443_) {
                LivingEntity livingEntity;
                if (!mob.m_21023_((MobEffect)GoetyEffects.WILD_RAGE.get())) {
                    livingEntity = mob.m_5448_();
                    if (livingEntity instanceof IOwned) {
                        IOwned ownedEntity = (IOwned)livingEntity;
                        if (this.getTrueOwner() != null && ownedEntity.getTrueOwner() == this.getTrueOwner()) {
                            mob.m_6710_(null);
                            if (mob.m_21188_() == ownedEntity) {
                                mob.m_6703_(null);
                            }
                        }
                        if (ownedEntity.getTrueOwner() == this) {
                            mob.m_6710_(null);
                            if (mob.m_21188_() == ownedEntity) {
                                mob.m_6703_(null);
                            }
                        }
                        if (MobUtil.ownerStack(this, ownedEntity)) {
                            mob.m_6710_(null);
                            if (mob.m_21188_() == ownedEntity) {
                                mob.m_6703_(null);
                            }
                        }
                    }
                    if (this.getTrueOwner() != null && mob.m_21188_() == this.getTrueOwner()) {
                        mob.m_6703_(null);
                    }
                }
                if (this.getTrueOwner() != null) {
                    Object apostle;
                    this.ownerCheck();
                    livingEntity = this.getTrueOwner();
                    if (livingEntity instanceof Mob) {
                        Mob mobOwner = (Mob)livingEntity;
                        if (mobOwner.m_5448_() != null && mob.m_5448_() == null) {
                            mob.m_6710_(mobOwner.m_5448_());
                        }
                        if (mobOwner instanceof Apostle && mob.m_20270_((Entity)(apostle = (Apostle)mobOwner)) > 32.0f) {
                            this.teleportTowards((Entity)apostle);
                        }
                        if ((mobOwner.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || mobOwner.m_6095_().m_204039_(ModTags.EntityTypes.SUMMON_KILL)) && (mobOwner.m_213877_() || mobOwner.m_21224_())) {
                            mob.m_6074_();
                        }
                    }
                    if ((apostle = this.getTrueOwner()) instanceof IOwned) {
                        IOwned owned = (IOwned)apostle;
                        if (this.getTrueOwner().m_21224_() || !this.getTrueOwner().m_6084_()) {
                            if (owned.getTrueOwner() != null) {
                                this.setTrueOwner(owned.getTrueOwner());
                            } else if (!(this.isHostile() || this.isNatural() || owned instanceof Enemy || owned.isHostile())) {
                                mob.m_6074_();
                            }
                        }
                    }
                    for (Mob target : mob.f_19853_.m_45976_(Mob.class, mob.m_20191_().m_82400_(mob.m_21133_(Attributes.f_22277_)))) {
                        if (!(target instanceof IOwned)) continue;
                        IOwned owned = (IOwned)target;
                        if (this.getTrueOwner() == owned.getTrueOwner() || target.m_5448_() != this.getTrueOwner()) continue;
                        mob.m_6710_((LivingEntity)target);
                    }
                }
                if (mob.m_5448_() != null && (mob.m_5448_().m_213877_() || mob.m_5448_().m_21224_())) {
                    mob.m_6710_(null);
                }
                this.mobSense();
                if (this.hasLifespan()) {
                    this.setLifespan(this.getLifespan() - 1);
                    if (this.getLifespan() <= 1) {
                        this.lifeSpanDamage();
                    }
                }
            }
        }
    }

    default public void ownerCheck() {
        IOwned iOwned = this;
        if (iOwned instanceof Mob) {
            Mob mob = (Mob)iOwned;
            if (!mob.f_19853_.f_46443_ && this.getTrueOwner() != null && this.getTrueOwner().f_19797_ < 20) {
                Entity entity = mob.f_19853_.m_6815_(this.getOwnerClientId());
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (livingEntity != this.getTrueOwner()) {
                        this.setOwnerClientId(this.getTrueOwner().m_19879_());
                    }
                } else {
                    this.setOwnerClientId(this.getTrueOwner().m_19879_());
                }
            }
        }
    }

    default public void mobSense() {
        IOwned iOwned = this;
        if (iOwned instanceof Mob) {
            Mob mob;
            LivingEntity livingEntity;
            Mob owned = (Mob)iOwned;
            if (((Boolean)MobsConfig.MobSense.get()).booleanValue() && owned.m_6084_() && owned.m_5448_() != null && (livingEntity = owned.m_5448_()) instanceof Mob && !((mob = (Mob)livingEntity) instanceof Guardian)) {
                LivingEntity livingEntity2 = owned.m_5448_();
                if (livingEntity2 instanceof Animal) {
                    Animal animal = (Animal)livingEntity2;
                    animal.m_6703_((LivingEntity)owned);
                } else if (mob.m_5448_() == null || mob.m_5448_().m_21224_()) {
                    Mob target = owned;
                    if (mob.m_6095_().m_204039_(ModTags.EntityTypes.IGNORE_SERVANTS) && this.getTrueOwner() != null && mob.m_6779_(this.getTrueOwner()) && EntitySelector.f_20406_.test(mob)) {
                        target = this.getTrueOwner();
                    }
                    mob.m_6710_((LivingEntity)target);
                }
                if (!mob.m_6274_().m_21954_(Activity.f_37988_) && !(mob instanceof Warden)) {
                    Mob target = owned;
                    if (mob.m_6095_().m_204039_(ModTags.EntityTypes.IGNORE_SERVANTS) && this.getTrueOwner() != null && mob.m_6779_(this.getTrueOwner()) && EntitySelector.f_20406_.test(mob)) {
                        target = this.getTrueOwner();
                    }
                    mob.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)target.m_20148_(), 600L);
                    mob.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)target, 600L);
                }
            }
        }
    }

    default public void lifeSpanDamage() {
        IOwned iOwned = this;
        if (iOwned instanceof LivingEntity) {
            LivingEntity owned = (LivingEntity)iOwned;
            this.setLifespan(20);
            owned.m_6469_(owned.m_269291_().m_269064_(), 1.0f);
        }
    }

    default public void teleportTowards(Entity entity) {
        this.teleportTowards(entity, 16.0);
    }

    default public void teleportTowards(Entity entity, double range) {
        IOwned iOwned = this;
        if (iOwned instanceof LivingEntity) {
            LivingEntity owned = (LivingEntity)iOwned;
            if (!owned.f_19853_.m_5776_() && owned.m_6084_()) {
                for (int i = 0; i < 128; ++i) {
                    double d3;
                    double d2;
                    Vec3 vector3d = new Vec3(owned.m_20185_() - entity.m_20185_(), owned.m_20227_(0.5) - entity.m_20188_(), owned.m_20189_() - entity.m_20189_());
                    vector3d = vector3d.m_82541_();
                    double d1 = owned.m_20185_() + (owned.m_217043_().m_188500_() - 0.5) * (range / 2.0) - vector3d.f_82479_ * range;
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)owned, (double)d1, (double)(d2 = owned.m_20186_() + ((double)owned.m_217043_().m_188503_(Mth.m_14107_((double)range)) - range / 2.0) - vector3d.f_82480_ * range), (double)(d3 = owned.m_20189_() + (owned.m_217043_().m_188500_() - 0.5) * (range / 2.0) - vector3d.f_82481_ * range));
                    if (event.isCanceled()) break;
                    if (!this.ownedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ())) continue;
                    this.teleportHits();
                    break;
                }
            }
        }
    }

    default public boolean ownedTeleport(Vec3 vec3) {
        return this.ownedTeleport(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    default public boolean ownedTeleport(double x, double y, double z) {
        IOwned iOwned = this;
        if (iOwned instanceof LivingEntity) {
            LivingEntity owned = (LivingEntity)iOwned;
            return owned.m_20984_(x, y, z, false);
        }
        return false;
    }

    default public void teleportHits() {
        IOwned iOwned = this;
        if (iOwned instanceof LivingEntity) {
            LivingEntity owned = (LivingEntity)iOwned;
            owned.f_19853_.m_7605_((Entity)owned, (byte)46);
            if (!owned.m_20067_()) {
                owned.f_19853_.m_6263_((Player)null, owned.f_19854_, owned.f_19855_, owned.f_19856_, SoundEvents.f_11852_, owned.m_5720_(), 1.0f, 1.0f);
                owned.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
    }

    default public boolean preventsSleep(Player p_33036_) {
        return this.isHostile();
    }

    default public Predicate<Entity> summonPredicate() {
        IOwned iOwned = this;
        if (iOwned instanceof Mob) {
            Mob mob = (Mob)iOwned;
            return entity -> mob.getClass().isAssignableFrom(entity.getClass());
        }
        return entity -> entity instanceof IOwned;
    }

    default public int getSummonLimit(LivingEntity owner) {
        return 64;
    }

    default public void uncreditedKill(LivingEntity target) {
    }

    default public boolean canRevive(DamageSource damageSource) {
        return false;
    }

    default public void reviveOwned() {
        ServantUtil.teleportToRevive(this);
        IOwned iOwned = this;
        if (iOwned instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)iOwned;
            living.m_21153_(1.0f);
            living.m_21219_();
        }
    }

    @Nullable
    default public BlockPos getRevivePos() {
        return null;
    }

    @Nullable
    default public Vec3 vec3RevivePos() {
        if (this.getRevivePos() != null) {
            return Vec3.m_82539_((Vec3i)this.getRevivePos());
        }
        return null;
    }

    default public void setRevivePos(BlockPos blockPos) {
        IOwned iOwned = this;
        if (iOwned instanceof Entity) {
            Entity entity = (Entity)iOwned;
            this.setReviveDim((ResourceKey<Level>)entity.f_19853_.m_46472_());
        }
    }

    default public ResourceKey<Level> getReviveLevel() {
        ResourceLocation resourcelocation = new ResourceLocation(this.getReviveDim());
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)resourcelocation);
    }

    default public String getReviveDim() {
        return Level.f_46428_.m_135782_().toString();
    }

    default public void setReviveDim(ResourceKey<Level> resourceKey) {
        this.setReviveDim(resourceKey.m_135782_().toString());
    }

    default public void setReviveDim(String string) {
    }

    default public void readOwnedData(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.setOwnerId(compound.m_128342_("Owner"));
        }
        if (compound.m_128441_("OwnerClient")) {
            this.setOwnerClientId(compound.m_128451_("OwnerClient"));
        }
        if (compound.m_128441_("isHostile")) {
            this.setHostile(compound.m_128471_("isHostile"));
        } else {
            this.checkHostility();
        }
        if (compound.m_128441_("isNatural")) {
            this.setNatural(compound.m_128471_("isNatural"));
        }
        if (compound.m_128441_("LifeTicks")) {
            this.setLimitedLife(compound.m_128451_("LifeTicks"));
        }
        if (compound.m_128441_("RevivePos")) {
            this.setRevivePos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("RevivePos")));
            if (compound.m_128441_("ReviveDim")) {
                this.setReviveDim(compound.m_128461_("ReviveDim"));
            } else {
                IOwned iOwned = this;
                if (iOwned instanceof Entity) {
                    Entity entity = (Entity)iOwned;
                    this.setReviveDim((ResourceKey<Level>)entity.f_19853_.m_46472_());
                }
            }
        }
    }

    default public void saveOwnedData(CompoundTag compound) {
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getOwnerClientId() > -1) {
            compound.m_128405_("OwnerClient", this.getOwnerClientId());
        }
        if (this.isHostile()) {
            compound.m_128379_("isHostile", this.isHostile());
        }
        if (this.isNatural()) {
            compound.m_128379_("isNatural", this.isNatural());
        }
        if (this.isLimitedLife()) {
            compound.m_128405_("LifeTicks", this.getLifespan());
        }
        if (this.getRevivePos() != null) {
            compound.m_128365_("RevivePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getRevivePos()));
            compound.m_128359_("ReviveDim", this.getReviveDim());
        }
    }
}

