/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.gui.screen.inventory;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.events.ClientEvents;
import com.Polarice3.Goety.client.gui.radial.GenericRadialMenu;
import com.Polarice3.Goety.client.gui.radial.IRadialMenuHost;
import com.Polarice3.Goety.client.gui.radial.ItemStackRadialMenuItem;
import com.Polarice3.Goety.common.items.handler.BrewBagItemHandler;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.client.brew.CThrowBrewKeyPacket;
import com.Polarice3.Goety.init.ModKeybindings;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BrewRadialMenuScreen
extends Screen {
    private ItemStack stackEquipped;
    private IItemHandler brewBagHandler;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final GenericRadialMenu menu;

    public BrewRadialMenuScreen() {
        super((Component)Component.m_237113_((String)"BREW RADIAL MENU"));
        this.stackEquipped = CuriosFinder.findBrewBag((Player)Minecraft.m_91087_().f_91074_);
        this.brewBagHandler = this.stackEquipped.m_41613_() > 0 ? BrewBagItemHandler.get(this.stackEquipped) : null;
        this.menu = new GenericRadialMenu(Minecraft.m_91087_(), Goety.location("textures/gui/brew_wheel.png"), new IRadialMenuHost(){

            @Override
            public void renderTooltip(GuiGraphics matrixStack, ItemStack stack, int mouseX, int mouseY) {
                matrixStack.m_280153_(BrewRadialMenuScreen.this.f_96547_, stack, mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return BrewRadialMenuScreen.this;
            }

            @Override
            public Font getFontRenderer() {
                return BrewRadialMenuScreen.this.f_96547_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof BrewRadialMenuScreen) {
            event.setCanceled(true);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        ClientEvents.wipeOpen();
    }

    public void m_86600_() {
        super.m_86600_();
        this.menu.tick();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_6084_()) {
            boolean noBrewInBag;
            boolean hasBrewInBag = this.brewBagHandler != null && CuriosFinder.hasBrewInBag((Player)player);
            boolean bl = noBrewInBag = this.brewBagHandler == null || !hasBrewInBag;
            if (this.menu.isClosed() || noBrewInBag) {
                Minecraft.m_91087_().m_91152_(null);
                ClientEvents.wipeOpen();
            }
            if (!this.menu.isReady() || noBrewInBag) {
                return;
            }
            ItemStack stack = CuriosFinder.findBrewBag((Player)player);
            if (stack.m_41613_() <= 0) {
                this.brewBagHandler = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.stackEquipped = stack;
                this.brewBagHandler = BrewBagItemHandler.get(stack);
                this.needsRecheckStacks = true;
            }
            if (ModKeybindings.brewCircle() != null && !ClientEvents.isKeyDown(ModKeybindings.brewCircle())) {
                this.processClick();
            }
        } else {
            Minecraft.m_91087_().m_91152_(null);
            ClientEvents.wipeOpen();
        }
    }

    public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
        this.processClick();
        return super.m_6348_(p_94722_, p_94723_, p_94724_);
    }

    protected void processClick() {
        this.menu.clickItem();
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_280168_().m_85836_();
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_280168_().m_85849_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_6084_()) {
            boolean hasBrewInBag;
            boolean bl = hasBrewInBag = this.brewBagHandler != null && CuriosFinder.hasBrewInBag((Player)player);
            if (this.brewBagHandler == null || !hasBrewInBag) {
                return;
            }
            if (this.needsRecheckStacks) {
                this.cachedMenuItems.clear();
                if (this.brewBagHandler != null) {
                    for (int i = 1; i < this.brewBagHandler.getSlots(); ++i) {
                        ItemStack inSlot = this.brewBagHandler.getStackInSlot(i);
                        ItemStackRadialMenuItem item = new ItemStackRadialMenuItem(this.menu, i, inSlot, (Component)Component.m_237115_((String)"tooltip.goety.focusBag.empty")){

                            @Override
                            public boolean onClick() {
                                return BrewRadialMenuScreen.this.throwBrew(this.getSlot(), this.getStack());
                            }
                        };
                        item.setVisible(inSlot.m_41613_() > 0);
                        this.cachedMenuItems.add(item);
                    }
                }
                this.menu.clear();
                this.menu.addAll(this.cachedMenuItems);
                this.needsRecheckStacks = false;
            }
            this.menu.setCentralItem(ItemStack.f_41583_);
            this.menu.draw(matrixStack, partialTicks, mouseX, mouseY);
        } else {
            this.menu.close();
        }
    }

    private boolean throwBrew(int slotNumber, ItemStack itemMouseOver) {
        if (itemMouseOver.m_41613_() > 0) {
            ModNetwork.sendToServer(new CThrowBrewKeyPacket(slotNumber));
        }
        this.menu.close();
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

