/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.Goety;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class WindTrailParticle
extends Particle {
    private static final ResourceLocation TEXTURE = Goety.location("textures/particle/trail.png");
    public final Vec3[] trailPositions = new Vec3[64];
    public int trailPointer = -1;
    public float trailA = 1.0f;

    public WindTrailParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, float red, float green, float blue) {
        super(world, x, y, z);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
    }

    public void m_5989_() {
        this.trail();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107215_ *= 0.99;
        this.f_107216_ *= 0.99;
        this.f_107217_ *= 0.99;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)this.f_107226_;
        }
    }

    public void trail() {
        Vec3 trailAt = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.trailPointer == -1) {
            Arrays.fill(this.trailPositions, trailAt);
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        if (this.trailPointer > -1) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTexture()));
            Vec3 cameraPos = camera.m_90583_();
            double x = Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
            double y = Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
            double z = Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
            PoseStack poseStack = new PoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            Vec3 drawFrom = new Vec3(x, y, z);
            float zRot = this.getCameraRot(camera);
            Vec3 topAngleVec = new Vec3(0.0, (double)this.getTrailHeight() / 2.0, 0.0).m_82535_(zRot);
            Vec3 bottomAngleVec = new Vec3(0.0, (double)this.getTrailHeight() / -2.0, 0.0).m_82535_(zRot);
            for (int samples = 0; samples < this.sampleSize(); ++samples) {
                Vec3 sample = this.getTrailPosition(samples * this.sampleStep(), partialTick);
                Vec3 draw1 = drawFrom;
                float u1 = (float)samples / (float)this.sampleSize();
                float u2 = u1 + 1.0f / (float)this.sampleSize();
                PoseStack.Pose last = poseStack.m_85850_();
                Matrix4f matrix4f = last.m_252922_();
                Matrix3f matrix3f = last.m_252943_();
                vertexConsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.trailA).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTick)).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)bottomAngleVec.f_82479_, (float)sample.f_82480_ + (float)bottomAngleVec.f_82480_, (float)sample.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.trailA).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTick)).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, (float)sample.f_82479_ + (float)topAngleVec.f_82479_, (float)sample.f_82480_ + (float)topAngleVec.f_82480_, (float)sample.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.trailA).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTick)).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.trailA).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTick)).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                drawFrom = sample;
            }
            bufferSource.m_109911_();
            poseStack.m_85849_();
        }
    }

    public float getCameraRot(Camera camera) {
        return (float)(-Math.PI / 180 * (double)camera.m_90589_());
    }

    public float getTrailHeight() {
        return 0.5f;
    }

    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    public int sampleSize() {
        return 1;
    }

    public int sampleStep() {
        return 1;
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.f_107220_) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean shouldCull() {
        return false;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }
}

