/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.capabilities.witchbarter;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.capabilities.witchbarter.WitchBarterProvider;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class WBUpdatePacket {
    private final int witchId;
    private CompoundTag tag;

    public WBUpdatePacket(int witchId, CompoundTag tag) {
        this.witchId = witchId;
        this.tag = tag;
    }

    public WBUpdatePacket(LivingEntity livingEntity) {
        this.witchId = livingEntity.m_19879_();
        livingEntity.getCapability(WitchBarterProvider.CAPABILITY, null).ifPresent(barter -> {
            this.tag = WitchBarterProvider.save(new CompoundTag(), barter);
        });
    }

    public static void encode(WBUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.witchId);
        buffer.m_130079_(packet.tag);
    }

    public static WBUpdatePacket decode(FriendlyByteBuf buffer) {
        return new WBUpdatePacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void consume(WBUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel clientLevel;
            Entity entity;
            Level level;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (level = Goety.PROXY.getLevel()) instanceof ClientLevel && (entity = (clientLevel = (ClientLevel)level).m_6815_(packet.witchId)) != null) {
                entity.getCapability(WitchBarterProvider.CAPABILITY).ifPresent(barter -> WitchBarterProvider.load(packet.tag, barter));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

