/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.common.entities.hostile.servants.Malghast;
import com.Polarice3.Goety.common.entities.neutral.SummonedFlying;
import com.Polarice3.Goety.common.entities.projectiles.Lavaball;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.MobUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class GhastServant
extends Malghast {
    public GhastServant(EntityType<? extends Malghast> type, Level worldIn) {
        super((EntityType<? extends SummonedFlying>)type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    @Override
    public void addFireballGoal() {
        this.f_21345_.m_25352_(7, (Goal)new FireballAttackGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.GhastServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.GhastServantHealth.get());
    }

    @Override
    protected float m_6431_(Pose p_32741_, EntityDimensions p_32742_) {
        return 2.6f;
    }

    @Override
    protected float m_6121_() {
        return 5.0f;
    }

    @Override
    public float m_6100_() {
        return 1.0f;
    }

    @Override
    public void setGhastSpawn() {
        if (this.getTrueOwner() == null) {
            this.setBoundPos(this.m_20183_());
            this.setWandering(false);
            this.setStaying(false);
        }
    }

    @Override
    public void m_7334_(Entity entity) {
        if (!this.f_19853_.f_46443_ && !MobUtil.areAllies((Entity)this, entity)) {
            super.m_7334_(entity);
        }
    }

    @Override
    protected void m_7324_(Entity entity) {
        if (!this.f_19853_.f_46443_ && !MobUtil.areAllies((Entity)this, entity)) {
            super.m_7324_(entity);
        }
    }

    @Override
    public boolean m_7337_(Entity entity) {
        if (!MobUtil.areAllies((Entity)this, entity)) {
            return super.m_7337_(entity);
        }
        return false;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Malghast ghast;
        private int floatDuration;

        public MoveHelperController(Malghast p_i45838_1_) {
            super((Mob)p_i45838_1_);
            this.ghast = p_i45838_1_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.m_217043_().m_188503_(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.ghast.m_20185_(), this.f_24976_ - this.ghast.m_20186_(), this.f_24977_ - this.ghast.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.canReach(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.ghast.m_20256_(this.ghast.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.ghast.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.ghast.f_19853_.m_45756_((Entity)this.ghast, axisalignedbb = axisalignedbb.m_82383_(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class FireballAttackGoal
    extends Goal {
        private final GhastServant ghast;
        public int chargeTime;

        public FireballAttackGoal(GhastServant p_i45837_1_) {
            this.ghast = p_i45837_1_;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.ghast.setCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ghast.m_5448_();
            float d0 = 64.0f;
            if (livingentity != null && livingentity.m_20280_((Entity)this.ghast) < (double)Mth.m_14207_((float)d0) && this.ghast.m_142582_((Entity)livingentity)) {
                Level world = this.ghast.f_19853_;
                ++this.chargeTime;
                if (this.chargeTime == 10 && !this.ghast.m_20067_()) {
                    world.m_5898_((Player)null, 1015, this.ghast.m_20183_(), 0);
                }
                if (this.chargeTime == 20) {
                    Vec3 vec3 = this.ghast.m_20252_(1.0f);
                    double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vec3.m_7096_() * 4.0);
                    double d3 = livingentity.m_20227_(0.25) - this.ghast.m_20227_(0.25);
                    double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vec3.m_7094_() * 4.0);
                    if (!this.ghast.m_20067_()) {
                        world.m_5898_((Player)null, 1016, this.ghast.m_20183_(), 0);
                    }
                    Lavaball largefireball = new Lavaball(world, (LivingEntity)this.ghast, d2, d3, d4);
                    largefireball.setExplosionPower(this.ghast.getExplosionPower());
                    largefireball.setDamage(((Double)AttributesConfig.GhastServantDamage.get()).floatValue() + this.ghast.getFireBallDamage());
                    largefireball.m_6034_(this.ghast.m_20185_() + vec3.m_7096_() * 4.0, this.ghast.m_20186_() + 0.25, this.ghast.m_20189_() + vec3.m_7094_() * 4.0);
                    largefireball.setDangerous(ForgeEventFactory.getMobGriefingEvent((Level)world, (Entity)this.ghast));
                    world.m_7967_((Entity)largefireball);
                    this.chargeTime = -40;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.ghast.setCharging(this.chargeTime > 10);
        }
    }
}

