/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.illager.ILooter;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.IllagerChestGoal;
import com.Polarice3.Goety.common.entities.ai.IllagerStoreChestGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.WaystoneItem;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.client.CPrisonerMinePacket;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.RandomUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Prisoner
extends RaiderServant
implements VillagerDataHolder,
ILooter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Float> LOOK_ANGLE = SynchedEntityData.m_135353_(Prisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_TRADER = SynchedEntityData.m_135353_(Prisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_MINING = SynchedEntityData.m_135353_(Prisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_LOOK = SynchedEntityData.m_135353_(Prisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.m_135353_(Prisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135043_);
    private final DynamicGameEventListener<GameEventListener> gameEventListener;
    @Nullable
    private Tag gossips;
    @Nullable
    private CompoundTag tradeOffers;
    private int villagerXp;
    public int toMineTick;
    public int noBlockTick;
    public int mineTimes;
    public int updateList;
    public List<BlockPos> blockPosList = new ArrayList<BlockPos>();
    public List<BlockPos> rareList = new ArrayList<BlockPos>();
    public boolean isChained;
    @Nullable
    public BlockPos chestPos;
    public String chestDim = Level.f_46428_.m_135782_().toString();
    @Nullable
    public BlockPos dumpChestPos;
    public String dumpChestDim = Level.f_46428_.m_135782_().toString();
    private final SimpleContainer inventory = new SimpleContainer(8);
    public AnimationState miningAnimationState = new AnimationState();

    public Prisoner(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.gameEventListener = new DynamicGameEventListener(new GameEventListener(){

            @NotNull
            public PositionSource m_142460_() {
                return new BlockPositionSource(Prisoner.this.m_20183_());
            }

            public int m_142078_() {
                return (Integer)MobsConfig.PrisonerMiningRange.get() * 2;
            }

            public boolean m_214068_(ServerLevel serverLevel, GameEvent p_282184_, GameEvent.Context p_283014_, Vec3 p_282350_) {
                if (!Prisoner.this.m_213877_() && (Prisoner.this.m_21205_().m_204117_(ItemTags.f_271360_) || Prisoner.this.m_21205_().m_41720_() instanceof PickaxeItem) && p_282184_.m_204528_(ModTags.GameEvents.BLOCK_EVENTS)) {
                    Prisoner.this.updateList = 5;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, new PrisonerPutLootChestGoal<Prisoner>(this));
        this.f_21345_.m_25352_(1, (Goal)new GiveMinedGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MiningGoal(this));
        this.f_21345_.m_25352_(3, new PrisonerGetPickChestGoal<Prisoner>(this));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(6, (Goal)new Summoned.FollowOwnerGoal<Prisoner>(this, 0.6, 6.0f, 2.0f){

            @Override
            public boolean m_8036_() {
                if (Prisoner.this.getLeader() != null) {
                    RaiderServant livingentity = Prisoner.this.getLeader();
                    if (livingentity == null) {
                        return false;
                    }
                    if (livingentity.m_5833_()) {
                        return false;
                    }
                    if (Prisoner.this.m_20280_((Entity)livingentity) < (double)Mth.m_14207_((float)this.startDistance)) {
                        return false;
                    }
                    if (!Prisoner.this.isFollowing() || Prisoner.this.isCommanded()) {
                        return false;
                    }
                    if (Prisoner.this.m_5448_() != null) {
                        return false;
                    }
                    this.owner = livingentity;
                    return true;
                }
                return super.m_8036_();
            }
        });
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, new Summoned.ReturnToGuardPos<Prisoner>(this, 0.6, 2));
        this.f_21345_.m_25352_(8, (Goal)new RaiderServant.RaiderWanderGoal<Prisoner>(this, 0.6){

            @Override
            public Vec3 randomBoundPos() {
                return ((Prisoner)this.summonedEntity).vec3BoundPos();
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOOK_ANGLE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_TRADER, (Object)false);
        this.f_19804_.m_135372_(IS_MINING, (Object)false);
        this.f_19804_.m_135372_(HAS_LOOK, (Object)false);
        this.f_19804_.m_135372_(DATA_VILLAGER_DATA, (Object)new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35585_, 1));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        VillagerData.f_35550_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.m_7141_()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_204072_ -> compound.m_128365_("VillagerData", p_204072_));
        if (this.tradeOffers != null) {
            compound.m_128365_("Offers", (Tag)this.tradeOffers);
        }
        if (this.gossips != null) {
            compound.m_128365_("Gossips", this.gossips);
        }
        if (this.hasCustomLook()) {
            compound.m_128350_("CustomLookAngle", this.getCustomLook());
        }
        compound.m_128405_("Xp", this.villagerXp);
        compound.m_128405_("MineTimes", this.mineTimes);
        compound.m_128379_("Trader", this.isTrader());
        compound.m_128379_("Mining", this.isMining());
        this.saveLooterData(compound);
        this.m_252802_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("VillagerData", 10)) {
            DataResult dataresult = VillagerData.f_35550_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("VillagerData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::m_34375_);
        }
        if (compound.m_128425_("Offers", 10)) {
            this.tradeOffers = compound.m_128469_("Offers");
        }
        if (compound.m_128425_("Gossips", 9)) {
            this.gossips = compound.m_128437_("Gossips", 10);
        }
        if (compound.m_128441_("CustomLookAngle")) {
            this.setCustomLook(compound.m_128457_("CustomLookAngle"));
        }
        if (compound.m_128425_("Xp", 3)) {
            this.villagerXp = compound.m_128451_("Xp");
        }
        if (compound.m_128441_("MineTimes")) {
            this.mineTimes = compound.m_128451_("MineTimes");
        }
        if (compound.m_128441_("Trader")) {
            this.setIsTrader(compound.m_128471_("Trader"));
        }
        if (compound.m_128441_("Mining")) {
            this.setMining(compound.m_128471_("Mining"));
        }
        this.readLooterData(compound);
        this.m_253224_(compound);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (IS_MINING.equals(accessor) && this.f_19853_.f_46443_) {
            if (this.isMining()) {
                this.miningAnimationState.m_216982_(this.f_19797_);
            } else {
                this.miningAnimationState.m_216973_();
            }
        }
        super.m_7350_(accessor);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public SlotAccess m_141942_(int p_149995_) {
        int i = p_149995_ - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(p_149995_);
    }

    public boolean inventoryFull() {
        int i = 0;
        for (int j = 0; j < this.m_35311_().m_6643_(); ++j) {
            ItemStack itemStack = this.m_35311_().m_8020_(j);
            if (!itemStack.m_41619_()) continue;
            ++i;
        }
        return i == 0;
    }

    @Override
    @Nullable
    public BlockPos getChestPos() {
        return this.chestPos;
    }

    @Override
    public void setChestPos(@Nullable BlockPos chestPos) {
        this.chestPos = chestPos;
    }

    @Override
    public String getChestDim() {
        return this.chestDim;
    }

    @Override
    public void setChestDim(String string) {
        this.chestDim = string;
    }

    @Override
    @Nullable
    public BlockPos getDumpChestPos() {
        return this.dumpChestPos;
    }

    @Override
    public void setDumpChestPos(@Nullable BlockPos chestPos) {
        this.dumpChestPos = chestPos;
    }

    @Override
    public String getDumpChestDim() {
        return this.dumpChestDim;
    }

    @Override
    public void setDumpChestDim(String string) {
        this.dumpChestDim = string;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason != MobSpawnType.CONVERSION) {
            this.m_34375_(this.m_7141_().m_35567_(VillagerType.m_204073_((Holder)pLevel.m_204166_(this.m_20183_()))));
        }
        return pSpawnData;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.isTrader()) {
            return SoundEvents.f_12588_;
        }
        return SoundEvents.f_12507_;
    }

    protected SoundEvent m_7975_(DamageSource p_35498_) {
        if (this.isTrader()) {
            return SoundEvents.f_12587_;
        }
        return SoundEvents.f_12506_;
    }

    protected SoundEvent m_5592_() {
        if (this.isTrader()) {
            return SoundEvents.f_12583_;
        }
        return SoundEvents.f_12505_;
    }

    @Override
    public List<ItemStack> itemsInInv(Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        SimpleContainer simplecontainer = this.m_35311_();
        int i = simplecontainer.m_6643_();
        for (int j = 0; j < i; ++j) {
            ItemStack itemStack = simplecontainer.m_8020_(j);
            if (!predicate.test(itemStack)) continue;
            list.add(itemStack);
        }
        return list;
    }

    @Nullable
    public Tag getGossips() {
        return this.gossips;
    }

    @Nullable
    public CompoundTag getOffers() {
        return this.tradeOffers;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = pCause.m_7639_();
            if (entity instanceof Zombie) {
                ZombieVillager zombievillager;
                Zombie zombie = (Zombie)entity;
                if (!(zombie.f_19853_.m_46791_() != Difficulty.NORMAL && zombie.f_19853_.m_46791_() != Difficulty.HARD || !ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20530_, timer -> {}) || zombie.f_19853_.m_46791_() != Difficulty.HARD && this.f_19796_.m_188499_() || (zombievillager = (ZombieVillager)this.m_21406_(EntityType.f_20530_, false)) == null)) {
                    zombievillager.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(zombievillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), (CompoundTag)null);
                    zombievillager.m_34375_(this.m_7141_());
                    if (this.getGossips() != null) {
                        zombievillager.m_34391_(this.getGossips());
                    }
                    if (this.getOffers() != null) {
                        zombievillager.m_34411_(this.getOffers());
                    }
                    zombievillager.m_34373_(this.getVillagerXp());
                    ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zombievillager);
                    if (!this.m_20067_()) {
                        serverLevel.m_5898_(null, 1026, this.m_20183_(), 0);
                    }
                }
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.miningAnimationState.m_216984_()) {
                ++this.toMineTick;
                if (this.toMineTick == 26) {
                    this.m_216990_((SoundEvent)ModSounds.VILLAGER_CHOP.get());
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.VILLAGER_CHOP.get(), this.m_5720_(), 1.0f, 1.0f, false);
                    ModNetwork.sendToServer(new CPrisonerMinePacket(this.m_19879_()));
                }
                if (this.toMineTick >= 55) {
                    this.toMineTick = 0;
                }
            } else {
                this.toMineTick = 0;
            }
        }
        if (!this.f_19853_.f_46443_) {
            Level d02;
            float f;
            RaiderServant raider;
            if (this.isFollowing()) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)5);
            }
            LivingEntity livingEntity = this.getTrueOwner();
            if (livingEntity instanceof RaiderServant && (raider = (RaiderServant)livingEntity).getLeader() != null && this.getLeader() != raider.getLeader()) {
                this.setLeader(raider.getLeader());
                if (raider.getLeader().getTrueOwner() != null) {
                    this.setTrueOwner(raider.getLeader().getTrueOwner());
                }
            }
            if (this.getLeader() == null && this.getMasterOwner() != null && this.isFollowing() && (f = this.m_20270_((Entity)this.getMasterOwner())) > 6.0f) {
                double d02 = (this.getMasterOwner().m_20185_() - this.m_20185_()) / (double)f;
                double d1 = (this.getMasterOwner().m_20186_() - this.m_20186_()) / (double)f;
                double d2 = (this.getMasterOwner().m_20189_() - this.m_20189_()) / (double)f;
                this.m_20256_(this.m_20184_().m_82520_(Math.copySign(d02 * d02 * 0.4, d02), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
                this.m_245125_();
            }
            if ((d02 = this.f_19853_) instanceof ServerLevel) {
                Item item;
                ServerLevel serverLevel = (ServerLevel)d02;
                if (this.noBlockTick > 0) {
                    --this.noBlockTick;
                }
                if (this.updateList > 0) {
                    --this.updateList;
                }
                if (this.m_21205_().m_204117_(ItemTags.f_271360_) && (item = this.m_21205_().m_41720_()) instanceof PickaxeItem) {
                    PickaxeItem pickaxe = (PickaxeItem)item;
                    int range = (Integer)MobsConfig.PrisonerMiningRange.get();
                    if (this.blockPosList.isEmpty() || this.updateList > 0) {
                        if (!this.blockPosList.isEmpty()) {
                            this.blockPosList.clear();
                        }
                        if (!this.rareList.isEmpty()) {
                            this.rareList.clear();
                        }
                        for (int i = -range; i < range; ++i) {
                            for (int j = -range; j < range; ++j) {
                                for (int k = -range; k < range; ++k) {
                                    BlockPos blockPos = this.m_20183_().m_7918_(i, j, k);
                                    BlockState blockState = serverLevel.m_8055_(blockPos);
                                    boolean hasSight = true;
                                    if (((Boolean)MobsConfig.PrisonerMiningSeeBlocks.get()).booleanValue()) {
                                        Direction direction;
                                        hasSight = false;
                                        Direction[] directionArray = Direction.values();
                                        int n = directionArray.length;
                                        for (int i2 = 0; i2 < n && !(hasSight = BlockFinder.canSeeBlock((Entity)this, blockPos.m_121945_(direction = directionArray[i2]))); ++i2) {
                                        }
                                    }
                                    if (!hasSight || !blockState.m_204336_(ModTags.Blocks.PRISONER_MINEABLE) || blockState.m_204336_(ModTags.Blocks.PRISONER_UNMINEABLE)) continue;
                                    this.blockPosList.add(blockPos);
                                    if (!blockState.m_204336_(ModTags.Blocks.PRISONER_RARE_ORES)) continue;
                                    this.rareList.add(blockPos);
                                }
                            }
                        }
                    }
                    if (!this.blockPosList.isEmpty()) {
                        if (this.mineTimes >= (Integer)MobsConfig.PrisonerMiningSwings.get()) {
                            Object blockPos = this.blockPosList.get(RandomUtil.nextInt(serverLevel.m_213780_(), this.blockPosList.size()));
                            boolean isRare = false;
                            if (!this.rareList.isEmpty() && this.rareList.contains(blockPos)) {
                                isRare = true;
                                if ((Integer)MobsConfig.PrisonerMiningRareChance.get() != 0 && RandomUtil.nextInt(serverLevel.m_213780_(), (Integer)MobsConfig.PrisonerMiningRareChance.get()) != 0) {
                                    ArrayList<BlockPos> newBlockList = new ArrayList<BlockPos>(this.blockPosList);
                                    newBlockList.removeIf(this.rareList::contains);
                                    blockPos = newBlockList.size() > 1 ? this.blockPosList.get(RandomUtil.nextInt(serverLevel.m_213780_(), newBlockList.size())) : null;
                                }
                            }
                            if (!isRare && (Integer)MobsConfig.PrisonerMiningChance.get() != 0 && RandomUtil.nextInt(serverLevel.m_213780_(), (Integer)MobsConfig.PrisonerMiningChance.get()) != 0) {
                                blockPos = null;
                            }
                            if (blockPos != null) {
                                BlockState blockState = serverLevel.m_8055_(blockPos);
                                if (TierSortingRegistry.isCorrectTierForDrops((Tier)pickaxe.m_43314_(), (BlockState)blockState)) {
                                    for (ItemStack itemStack : Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)blockPos, (BlockEntity)this.f_19853_.m_7702_(blockPos), (Entity)this, (ItemStack)this.m_21205_())) {
                                        this.m_35311_().m_19173_(itemStack);
                                    }
                                }
                                if (((Boolean)MobsConfig.PrisonerMiningBreakBlocks.get()).booleanValue()) {
                                    serverLevel.m_46953_(blockPos, false, (Entity)this);
                                }
                            }
                            this.mineTimes = 0;
                        }
                    } else {
                        this.noBlockTick = 100;
                        this.mineTimes = 0;
                    }
                } else {
                    if (!this.blockPosList.isEmpty()) {
                        this.blockPosList.clear();
                    }
                    if (!this.rareList.isEmpty()) {
                        this.rareList.clear();
                    }
                }
            }
        }
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> p_218348_) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            p_218348_.accept(this.gameEventListener, serverlevel);
        }
    }

    public VillagerData m_7141_() {
        return (VillagerData)this.f_19804_.m_135370_(DATA_VILLAGER_DATA);
    }

    public void m_34375_(VillagerData p_34376_) {
        VillagerData villagerdata = this.m_7141_();
        if (villagerdata.m_35571_() != p_34376_.m_35571_()) {
            this.tradeOffers = null;
        }
        this.f_19804_.m_135381_(DATA_VILLAGER_DATA, (Object)p_34376_);
    }

    @Override
    public void setHostile(boolean hostile) {
    }

    @Override
    public boolean isHostile() {
        return false;
    }

    @Override
    public void onStopAttack() {
    }

    public boolean isTrader() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRADER);
    }

    public void setIsTrader(boolean isTrader) {
        this.f_19804_.m_135381_(IS_TRADER, (Object)isTrader);
    }

    public boolean isMining() {
        return (Boolean)this.f_19804_.m_135370_(IS_MINING);
    }

    public void setMining(boolean mining) {
        this.f_19804_.m_135381_(IS_MINING, (Object)mining);
    }

    public void setTradeOffers(CompoundTag p_34412_) {
        this.tradeOffers = p_34412_;
    }

    public void setGossips(Tag p_34392_) {
        this.gossips = p_34392_;
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int p_34374_) {
        this.villagerXp = p_34374_;
    }

    public float getCustomLook() {
        return ((Float)this.f_19804_.m_135370_(LOOK_ANGLE)).floatValue();
    }

    public void setCustomLook(float angle) {
        this.f_19804_.m_135381_(LOOK_ANGLE, (Object)Float.valueOf(angle));
        this.f_19804_.m_135381_(HAS_LOOK, (Object)true);
    }

    public boolean hasCustomLook() {
        return (Boolean)this.f_19804_.m_135370_(HAS_LOOK);
    }

    @Override
    public void mobSense() {
    }

    @Override
    @Nullable
    public LivingEntity getMarked() {
        return null;
    }

    @Override
    @Nullable
    public BlockPos getRaidPos() {
        return null;
    }

    @Override
    public boolean isRaiding() {
        return false;
    }

    @Override
    public boolean isCapturing() {
        return false;
    }

    @Override
    public boolean canCelebrate() {
        return false;
    }

    @Override
    public boolean canJoinPatrol() {
        return false;
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public boolean isWithinDistance(Entity entity, double distance) {
        if (entity == null) {
            return false;
        }
        BlockPos blockpos = entity.m_20183_();
        BlockPos blockpos1 = this.m_20183_();
        return blockpos1.m_123314_((Vec3i)blockpos, distance);
    }

    public boolean isWithinThrowingDistance(Entity entity) {
        return this.isWithinDistance(entity, 5.0);
    }

    public boolean m_21531_() {
        return true;
    }

    public boolean m_7243_(ItemStack itemStack) {
        return (Boolean)MobsConfig.PrisonerPickUpPickaxe.get() != false && itemStack.m_204117_(ItemTags.f_271360_);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)MobsConfig.PrisonerUnshackleDamage.get()).booleanValue() && source.m_7639_() != null) {
            boolean flag = false;
            RaiderServant owner = this.getLeader();
            if (this.getLeader() == null || (double)this.getLeader().m_20270_((Entity)this) >= 8.0) {
                owner = this.getMasterOwner();
            }
            if (owner != null && !MobUtil.areAllies(source.m_7639_(), (Entity)owner) && (double)this.m_20270_((Entity)owner) >= 8.0) {
                flag = true;
            }
            if (flag && this.m_21223_() - amount > 0.0f && this.f_19853_.m_213780_().m_188501_() <= amount / this.m_21223_()) {
                Player player = null;
                Entity entity = source.m_7639_();
                if (entity instanceof Player) {
                    Player player1;
                    player = player1 = (Player)entity;
                }
                this.unshackle(player);
            }
        }
        return super.m_6469_(source, amount);
    }

    public void unshackle(@Nullable Player player) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11794_, this.m_5720_(), 1.0f, 2.0f);
            AbstractVillager villager = this.isTrader() ? (AbstractVillager)this.m_21406_(EntityType.f_20494_, true) : (AbstractVillager)this.m_21406_(EntityType.f_20492_, true);
            if (villager == null) {
                return;
            }
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                ItemStack itemstack = this.m_6844_(equipmentslot);
                if (itemstack.m_41619_()) continue;
                if (EnchantmentHelper.m_44920_((ItemStack)itemstack)) {
                    villager.m_141942_(equipmentslot.m_20749_() + 300).m_142104_(itemstack);
                    continue;
                }
                double d0 = this.m_21519_(equipmentslot);
                if (!(d0 > 1.0)) continue;
                this.m_19983_(itemstack);
            }
            if (villager instanceof Villager) {
                LivingEntity livingEntity;
                Villager villager1 = (Villager)villager;
                villager1.m_34375_(this.m_7141_());
                if (this.gossips != null) {
                    villager1.m_35455_(this.gossips);
                }
                if (this.tradeOffers != null) {
                    villager1.m_35476_(new MerchantOffers(this.tradeOffers));
                }
                villager1.m_35546_(this.villagerXp);
                villager1.m_35483_(serverLevel);
                if (player instanceof ServerPlayer && player != this.getMasterOwner() && !MobUtil.areAllies((Entity)player, (Entity)this.getMasterOwner())) {
                    serverLevel.m_8670_(ReputationEventType.f_26985_, (Entity)player, (ReputationEventHandler)villager1);
                    villager1.m_216990_(SoundEvents.f_12504_);
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, (Entity)villager1);
                }
                if ((livingEntity = this.getMasterOwner()) instanceof Player) {
                    Player player1 = (Player)livingEntity;
                    villager1.m_35517_().m_26191_(player1.m_20148_(), GossipType.MAJOR_NEGATIVE, 200);
                }
            } else if (villager instanceof WanderingTrader) {
                LivingEntity livingEntity;
                if (player instanceof ServerPlayer && player != this.getMasterOwner() && !MobUtil.areAllies((Entity)player, (Entity)this.getMasterOwner())) {
                    villager.m_216990_(SoundEvents.f_12539_);
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, (Entity)villager);
                }
                if ((livingEntity = this.getMasterOwner()) instanceof Player) {
                    Player player1 = (Player)livingEntity;
                    villager.m_6598_(player1);
                } else if (this.getMasterOwner() != null) {
                    villager.m_6703_(this.getMasterOwner());
                }
            }
            if (player != null) {
                ItemStack offhand = ItemStack.f_41583_;
                if (this.m_21206_().m_150930_((Item)ModItems.OMINOUS_SHACKLES.get())) {
                    offhand = this.m_21206_().m_278832_();
                } else if (villager.m_21206_().m_150930_((Item)ModItems.OMINOUS_SHACKLES.get())) {
                    offhand = villager.m_21206_().m_278832_();
                }
                if (!(offhand.m_41619_() || player != this.getMasterOwner() && player != this.getTrueOwner())) {
                    if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                        player.m_21008_(InteractionHand.MAIN_HAND, offhand);
                    } else if (!player.m_36356_(offhand)) {
                        this.m_19983_(offhand);
                    }
                }
            }
            ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50184_.m_49966_()), (Entity)villager);
            villager.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(villager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
            villager.m_21153_(this.m_21223_());
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)villager);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        Item item = itemInHand.m_41720_();
        ItemStack mainHandItem = this.m_21205_();
        if (pPlayer.m_6047_()) {
            this.unshackle(pPlayer);
            return InteractionResult.SUCCESS;
        }
        if (this.getMasterOwner() != null && this.getMasterOwner() == pPlayer) {
            OwnableEntity ownable;
            if (((Boolean)MobsConfig.PrisonerMining.get()).booleanValue() && (item instanceof PickaxeItem || itemInHand.m_204117_(ItemTags.f_271360_))) {
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                this.m_8061_(EquipmentSlot.MAINHAND, itemInHand.m_255036_(1));
                this.dropEquipment(EquipmentSlot.MAINHAND, mainHandItem);
                this.m_21508_(EquipmentSlot.MAINHAND);
                if (!pPlayer.m_150110_().f_35937_) {
                    itemInHand.m_41774_(1);
                }
                this.updateList = 5;
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21205_().m_150930_(Items.f_42398_)) {
                this.dropEquipment(EquipmentSlot.MAINHAND, this.m_21205_());
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21205_().m_150930_((Item)ModItems.WAYSTONE.get())) {
                BlockPos blockPos;
                ChestBlockEntity chestBlock;
                BlockEntity blockEntity;
                if (WaystoneItem.isSameDimension((LivingEntity)this, pPlayer.m_21205_()) && (blockEntity = WaystoneItem.getBlockEntity(pPlayer.m_21205_(), this.f_19853_)) instanceof ChestBlockEntity && (chestBlock = (ChestBlockEntity)blockEntity).m_7525_(pPlayer) && !this.f_19853_.f_46443_ && (blockPos = WaystoneItem.getBlockPos(pPlayer.m_21205_())) != null) {
                    this.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    if (chestBlock.m_58900_().m_204336_(ModTags.Blocks.RAIDING_CHESTS)) {
                        this.setDumpChestPos(blockPos);
                        this.setDumpChestDim(this.f_19853_.m_46472_());
                    } else {
                        this.setChestPos(blockPos);
                        this.setChestDim(this.f_19853_.m_46472_());
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            if (pPlayer.m_21205_().m_41619_() && this.isMining()) {
                float f = (float)Mth.m_14143_((float)((Mth.m_14177_((float)(pPlayer.m_146908_() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                this.m_146922_(f);
                this.m_5618_(f);
                this.m_5616_(f);
                this.setCustomLook(f);
                this.m_5496_(SoundEvents.f_12507_, 1.0f, 0.75f);
                return InteractionResult.SUCCESS;
            }
            if (this.getLeader() != null) {
                this.setLeader(null);
                this.setFollowing();
                return InteractionResult.SUCCESS;
            }
            LivingEntity livingEntity = this.getTrueOwner();
            if (livingEntity instanceof OwnableEntity && (ownable = (OwnableEntity)livingEntity).m_269323_() == pPlayer) {
                this.setTrueOwner((LivingEntity)pPlayer);
                this.setFollowing();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.isChained = true;
        } else if (p_21375_ == 5) {
            this.isChained = false;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public static class PrisonerPutLootChestGoal<T extends Prisoner>
    extends IllagerStoreChestGoal<T> {
        public PrisonerPutLootChestGoal(T prisoner) {
            super(prisoner);
            this.predicate = itemStack -> !itemStack.m_41619_();
            this.chestPredicate = itemStack -> true;
        }

        @Override
        public boolean m_8036_() {
            if (((Prisoner)this.illager).isMining()) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public void chestInteract(Container container) {
            Optional optional = ((Prisoner)this.illager).itemsInInv(this.predicate).stream().findFirst();
            if (optional.isPresent()) {
                ItemStack itemStack = (ItemStack)optional.get();
                for (int i = 0; i < container.m_6643_(); ++i) {
                    int l;
                    ItemStack containerItem = container.m_8020_(i);
                    if (itemStack.m_41619_()) continue;
                    if (containerItem.m_41619_()) {
                        container.m_6836_(i, itemStack.m_278832_());
                        container.m_6596_();
                        return;
                    }
                    if (containerItem.m_41720_() != itemStack.m_41720_()) continue;
                    int j = Math.min(container.m_6893_(), containerItem.m_41741_());
                    int k = Math.min(itemStack.m_41613_(), j - containerItem.m_41613_());
                    if (k <= 0) continue;
                    for (l = 0; l < k && containerItem.m_41613_() < containerItem.m_41741_(); ++l) {
                        containerItem.m_41769_(1);
                        itemStack.m_41774_(1);
                    }
                    if ((l >= k || containerItem.m_41613_() == containerItem.m_41741_()) && !itemStack.m_41619_() && ((Prisoner)this.illager).m_35311_().m_19183_(itemStack)) {
                        ((Prisoner)this.illager).m_35311_().m_19173_(itemStack);
                    }
                    container.m_6596_();
                    return;
                }
            }
        }
    }

    public static class GiveMinedGoal
    extends ThrowItemGoal {
        public GiveMinedGoal(Prisoner prisoner) {
            super(prisoner);
            this.predicate = itemStack -> !itemStack.m_41619_();
            this.targetPredicate = living -> {
                AbstractIllagerServant servant1;
                return living instanceof AbstractIllagerServant && (servant1 = (AbstractIllagerServant)living).getTrueOwner() == prisoner.getTrueOwner() && !servant1.inventoryFull() && !servant1.m_6162_() || prisoner.getTrueOwner() instanceof Player && living == prisoner.getTrueOwner();
            };
        }

        @Override
        public boolean m_8036_() {
            if (this.prisoner.isMining()) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public boolean isWithinThrowingDistance() {
            if (this.target == null) {
                return false;
            }
            if (this.target instanceof InventoryCarrier) {
                return this.prisoner.isWithinDistance((Entity)this.target, 2.0);
            }
            return super.isWithinThrowingDistance();
        }

        @Override
        public void throwItem() {
            if (this.target == null) {
                this.m_8041_();
            }
            SimpleContainer simpleContainer = this.prisoner.m_35311_();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < simpleContainer.m_6643_(); ++i) {
                ItemStack itemstack1 = simpleContainer.m_8020_(i);
                if (itemstack1.m_41619_()) continue;
                list.add(itemstack1.m_278832_());
            }
            if (!list.isEmpty()) {
                for (ItemStack itemStack : list) {
                    LivingEntity livingEntity = this.target;
                    if (livingEntity instanceof InventoryCarrier) {
                        InventoryCarrier carrier = (InventoryCarrier)livingEntity;
                        if (!carrier.m_35311_().m_19183_(itemStack)) continue;
                        carrier.m_35311_().m_19173_(itemStack.m_278832_());
                        this.target.m_216990_(SoundEvents.f_12019_);
                        continue;
                    }
                    BehaviorUtils.m_22613_((LivingEntity)this.prisoner, (ItemStack)itemStack.m_278832_(), (Vec3)this.target.m_20182_());
                }
            }
        }
    }

    public static class MiningGoal
    extends Goal {
        public Prisoner prisoner;

        public MiningGoal(Prisoner prisoner) {
            this.prisoner = prisoner;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (((Boolean)MobsConfig.PrisonerMining.get()).booleanValue() && this.prisoner.m_21205_().m_204117_(ItemTags.f_271360_)) {
                if (this.prisoner.isGuardingArea() && this.prisoner.m_20238_(this.prisoner.vec3BoundPos()) > (double)Mth.m_144944_((int)2)) {
                    return false;
                }
                return this.prisoner.itemsInInv(itemStack -> !itemStack.m_41619_()).size() < 64 && !this.prisoner.isFollowing() && !this.prisoner.isCommanded() && this.prisoner.noBlockTick <= 0 && this.prisoner.m_5448_() == null && this.prisoner.f_20916_ <= 0;
            }
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.prisoner.m_21573_().m_26573_();
            this.prisoner.m_21566_().m_24988_(0.0f, 0.0f);
            this.prisoner.setMining(true);
            if (this.prisoner.hasCustomLook()) {
                this.prisoner.m_146922_(this.prisoner.getCustomLook());
                this.prisoner.m_5618_(this.prisoner.getCustomLook());
                this.prisoner.m_5616_(this.prisoner.getCustomLook());
            }
            if (this.prisoner.isGuardingArea() && this.prisoner.m_20238_(this.prisoner.vec3BoundPos()) <= Mth.m_144952_((double)2.0)) {
                BlockPos blockPos = this.prisoner.getBoundPos();
                if (!BlockFinder.isPassableBlock(this.prisoner.f_19853_, blockPos)) {
                    blockPos = blockPos.m_7494_();
                }
                if (BlockFinder.isPassableBlock(this.prisoner.f_19853_, blockPos)) {
                    this.prisoner.m_20035_(blockPos, this.prisoner.m_146908_(), this.prisoner.m_146909_());
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.prisoner.setMining(false);
        }

        public void m_8037_() {
            super.m_8037_();
            Level level = this.prisoner.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.prisoner.f_19797_ % 5 == 0) {
                    ColorUtil colorUtil = new ColorUtil(16776026);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.RISING_SPIRAL.get()), this.prisoner.m_20208_(1.0), this.prisoner.m_20188_(), this.prisoner.m_20262_(1.0), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
                }
            }
            this.prisoner.m_21573_().m_26573_();
            this.prisoner.m_21566_().m_24988_(0.0f, 0.0f);
        }
    }

    public static class PrisonerGetPickChestGoal<T extends Prisoner>
    extends IllagerChestGoal<T> {
        public PrisonerGetPickChestGoal(T prisoner) {
            super(prisoner);
            this.predicate = itemStack -> true;
            this.chestPredicate = itemStack -> itemStack.m_204117_(ItemTags.f_271360_) || itemStack.m_41720_() instanceof PickaxeItem;
        }

        @Override
        public boolean m_8036_() {
            if (((Prisoner)this.illager).isMining()) {
                return false;
            }
            if (((Prisoner)this.illager).getChestPos() == null) {
                return false;
            }
            if (((Prisoner)this.illager).getChestLevel() != ((Prisoner)this.illager).f_19853_.m_46472_()) {
                return false;
            }
            if (((Prisoner)this.illager).getBoundPos() != null && ((Prisoner)this.illager).getChestPos() != null && !((Prisoner)this.illager).isWithinGuard(((Prisoner)this.illager).getChestPos())) {
                return false;
            }
            if (this.getChest((LevelReader)((Prisoner)this.illager).f_19853_, ((Prisoner)this.illager).getChestPos()) == null) {
                return false;
            }
            if (!((Prisoner)this.illager).m_21205_().m_41619_()) {
                return false;
            }
            if (!this.isChestRaidable((LevelReader)((Prisoner)this.illager).f_19853_, ((Prisoner)this.illager).getChestPos())) {
                return false;
            }
            if (((Prisoner)this.illager).f_19853_.m_6443_(LivingEntity.class, ((Prisoner)this.illager).m_20191_().m_82400_(16.0), livingEntity -> {
                IOwned owned;
                return (livingEntity instanceof IOwned && (owned = (IOwned)livingEntity).getTrueOwner() == ((Prisoner)this.illager).getTrueOwner() || ((Prisoner)this.illager).getMasterOwner() == livingEntity) && ((Prisoner)this.illager).m_142582_((Entity)livingEntity);
            }).isEmpty()) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public void chestInteract(Container container) {
            for (ItemStack itemStack : this.getItems(container)) {
                if (!((Prisoner)this.illager).m_21205_().m_41619_()) continue;
                ((Prisoner)this.illager).m_8061_(EquipmentSlot.MAINHAND, itemStack.m_278832_());
                container.m_6596_();
            }
        }
    }

    public static abstract class ThrowItemGoal
    extends Goal {
        public Prisoner prisoner;
        public LivingEntity target;
        public Predicate<ItemStack> predicate = itemStack -> false;
        public Predicate<LivingEntity> targetPredicate = living -> false;
        public int throwTime;

        public ThrowItemGoal(Prisoner prisoner) {
            this.prisoner = prisoner;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.hasItem()) {
                this.target = this.getThrowTarget();
                if (this.target != null) {
                    if (this.prisoner.isStaying()) {
                        return this.prisoner.isWithinThrowingDistance((Entity)this.target) && this.prisoner.m_142582_((Entity)this.target);
                    }
                    return (double)this.target.m_20270_((Entity)this.prisoner) <= 8.0 && this.prisoner.m_142582_((Entity)this.target);
                }
            }
            return false;
        }

        public void m_8041_() {
            this.target = null;
            this.throwTime = 0;
        }

        public boolean isWithinThrowingDistance() {
            if (this.target == null) {
                return false;
            }
            return this.prisoner.isWithinThrowingDistance((Entity)this.target);
        }

        public void m_8037_() {
            LivingEntity livingEntity;
            if (this.target == null) {
                this.m_8041_();
            }
            this.prisoner.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.prisoner.m_8132_());
            if (this.isWithinThrowingDistance()) {
                this.prisoner.m_21573_().m_26573_();
                ++this.throwTime;
                if (this.throwTime > 20) {
                    this.throwItem();
                    this.throwTime = 0;
                }
            } else {
                this.prisoner.m_21573_().m_5624_((Entity)this.target, (double)0.6f);
            }
            if ((livingEntity = this.target) instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_21563_().m_148051_((Entity)this.prisoner);
                mob.m_21573_().m_26573_();
            }
        }

        public void throwItem() {
            if (this.target == null) {
                this.m_8041_();
            }
            for (ItemStack itemstack : this.prisoner.itemsInInv(this.predicate)) {
                BehaviorUtils.m_22613_((LivingEntity)this.prisoner, (ItemStack)itemstack.m_278832_(), (Vec3)this.target.m_20182_());
            }
        }

        public boolean hasItem() {
            return !this.prisoner.itemsInInv(this.predicate).isEmpty();
        }

        @Nullable
        public LivingEntity getThrowTarget() {
            List list = this.prisoner.f_19853_.m_45976_(LivingEntity.class, this.prisoner.m_20191_().m_82400_(16.0));
            list.sort(Comparator.comparingDouble(arg_0 -> ((Prisoner)this.prisoner).m_20280_(arg_0)));
            LivingEntity target = null;
            for (LivingEntity servant : list) {
                if (servant == this.prisoner || !this.targetPredicate.test(servant) || !this.prisoner.m_142582_((Entity)servant)) continue;
                target = servant;
            }
            return target;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

