/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.skeleton;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.neutral.IRavager;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VanguardServant
extends AbstractSkeletonServant {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(VanguardServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HAS_SHIELD = SynchedEntityData.m_135353_(VanguardServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int attackTick;
    public int shieldHealth = 1;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState stayingAnimationState = new AnimationState();

    public VanguardServant(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(4, (Goal)new VanguardAttackGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.VanguardServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.VanguardServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.VanguardServantArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.VanguardServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.VanguardServantDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.VanguardServantArmor.get());
    }

    @Override
    public void reassessWeaponGoal() {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_SHIELD, (Object)true);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("hasShield")) {
            this.setShield(pCompound.m_128471_("hasShield"));
        }
        if (pCompound.m_128441_("ShieldHeath")) {
            this.setShieldHealth(pCompound.m_128451_("ShieldHeath"));
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("hasShield", this.hasShield());
        pCompound.m_128405_("ShieldHeath", this.getShieldHealth());
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof VanguardServant;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.VanguardLimit.get();
    }

    private boolean getVanguardFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setVanguardFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean hasShield() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SHIELD);
    }

    public void setShield(boolean shield) {
        this.f_19804_.m_135381_(HAS_SHIELD, (Object)shield);
    }

    public int getShieldHealth() {
        return this.shieldHealth;
    }

    public void setShieldHealth(int shieldHealth) {
        this.shieldHealth = shieldHealth;
    }

    public void destroyShield() {
        if (this.hasShield()) {
            if (this.getShieldHealth() > 1) {
                this.setShieldHealth(this.getShieldHealth() - 1);
                this.m_216990_(SoundEvents.f_12346_);
            } else {
                this.setShieldHealth(0);
                this.setShield(false);
                this.m_216990_(SoundEvents.f_12347_);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42700_)), (Entity)this);
                }
            }
        }
    }

    public boolean isMeleeAttacking() {
        return this.getVanguardFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setVanguardFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.VANGUARD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.VANGUARD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.VANGUARD_DEATH.get();
    }

    @Override
    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSounds.VANGUARD_STEP.get();
    }

    @Override
    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
    }

    @Override
    public EntityType<?> getVariant(@Nullable Player player, Level level, BlockPos blockPos) {
        return (EntityType)ModEntityType.VANGUARD_SERVANT.get();
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.stayingAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_6084_()) {
            if (!this.isMeleeAttacking()) {
                this.attackAnimationState.m_216973_();
                if (!this.isMoving()) {
                    this.walkAnimationState.m_216973_();
                    if (this.isStaying() && !this.m_20159_()) {
                        this.idleAnimationState.m_216973_();
                        this.stayingAnimationState.m_216982_(this.f_19797_);
                    } else {
                        this.idleAnimationState.m_216982_(this.f_19797_);
                        this.stayingAnimationState.m_216973_();
                    }
                } else {
                    this.idleAnimationState.m_216973_();
                    this.stayingAnimationState.m_216973_();
                    this.walkAnimationState.m_216982_(this.f_19797_);
                }
            } else {
                this.idleAnimationState.m_216973_();
                this.walkAnimationState.m_216973_();
                this.stayingAnimationState.m_216973_();
            }
        }
        if (this.isMeleeAttacking()) {
            ++this.attackTick;
        }
        if (this.attackTick > 20) {
            this.setMeleeAttacking(false);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_) {
            Entity entity;
            if (this.hasShield() && !source.m_269533_(DamageTypeTags.f_268738_)) {
                this.destroyShield();
                return false;
            }
            if (this.m_5448_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                double d0 = this.m_20270_((Entity)this.m_5448_());
                double d1 = this.m_20270_((Entity)livingEntity);
                if (MobUtil.ownedCanAttack(this, livingEntity) && livingEntity != this.getTrueOwner() && d0 > d1) {
                    this.m_6710_(livingEntity);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        if (!this.hasShield()) {
            super.m_147240_(p_147241_, p_147242_, p_147243_);
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.stopAllAnimations();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 5) {
            this.attackTick = 0;
        } else if (p_21375_ == 6) {
            this.setShield(true);
            this.setShieldHealth(1);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    @Override
    public boolean m_7327_(Entity p_21372_) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (p_21372_ instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)p_21372_).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            p_21372_.m_20254_(i * 4);
        }
        if (flag = p_21372_.m_6469_(this.getServantAttack(), f)) {
            if (f1 > 0.0f && p_21372_ instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)p_21372_;
                living.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            }
            this.m_19970_((LivingEntity)this, p_21372_);
            this.m_21335_(p_21372_);
        }
        return flag;
    }

    protected double getAttackReachSqr(LivingEntity enemy) {
        if (this.m_20202_() instanceof IRavager) {
            float f = this.m_20202_().m_20205_() - 0.1f;
            return f * 2.0f * f * 2.0f + enemy.m_20205_();
        }
        return this.m_20205_() * 6.0f * this.m_20205_() * 6.0f + enemy.m_20205_();
    }

    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        return distToEnemySqr <= this.getAttackReachSqr(enemy) || this.m_20191_().m_82381_(enemy.m_20191_());
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (item == Items.f_42500_ && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_12383_, 1.0f, 1.25f);
                this.m_5634_(2.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_ && !this.hasShield() && itemstack.m_204117_(ItemTags.f_13168_) && this.m_5448_() == null && this.f_20916_ <= 0) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.setShield(true);
                this.setShieldHealth(1);
                this.f_19853_.m_7605_((Entity)this, (byte)6);
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return VanguardServant.this.m_5448_() != null && VanguardServant.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return VanguardServant.this.attackTick < 20;
        }

        public void m_8056_() {
            VanguardServant.this.setMeleeAttacking(true);
            VanguardServant.this.f_19853_.m_7605_((Entity)VanguardServant.this, (byte)4);
        }

        public void m_8041_() {
            VanguardServant.this.setMeleeAttacking(false);
        }

        public void m_8037_() {
            if (VanguardServant.this.m_5448_() != null && VanguardServant.this.m_5448_().m_6084_()) {
                LivingEntity livingentity = VanguardServant.this.m_5448_();
                double d0 = VanguardServant.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                VanguardServant.this.m_21563_().m_24960_((Entity)livingentity, (float)VanguardServant.this.m_8085_(), (float)VanguardServant.this.m_8132_());
                VanguardServant.this.m_5618_(VanguardServant.this.m_6080_());
                if (VanguardServant.this.attackTick == 8 && VanguardServant.this.targetClose(livingentity, d0) && VanguardServant.this.m_7327_((Entity)livingentity)) {
                    VanguardServant.this.m_216990_((SoundEvent)ModSounds.VANGUARD_SPEAR.get());
                    for (Entity entity : MeleeGoal.getTargets(VanguardServant.this.f_19853_, (LivingEntity)VanguardServant.this, 3.0)) {
                        LivingEntity living;
                        if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).m_7307_((Entity)VanguardServant.this) || VanguardServant.this.m_7307_((Entity)living) || living == livingentity || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !VanguardServant.this.m_6779_(livingentity)) continue;
                        VanguardServant.this.m_7327_((Entity)living);
                    }
                }
            }
        }

        public static List<Entity> getTargets(Level level, LivingEntity pSource, double pRange) {
            ArrayList<Entity> list = new ArrayList<Entity>();
            Vec3 lookVec = pSource.m_20252_(1.0f);
            double[] lookRange = new double[]{lookVec.m_7096_() * pRange, lookVec.m_7098_() * pRange, lookVec.m_7094_() * pRange};
            List possibleList = level.m_45933_((Entity)pSource, pSource.m_20191_().m_82363_(lookRange[0], lookRange[1], lookRange[2]));
            for (Entity hit : possibleList) {
                if (!hit.m_6087_() || hit == pSource || !EntitySelector.f_20406_.and(EntitySelector.f_20403_).test(hit)) continue;
                list.add(hit);
            }
            return list;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class VanguardAttackGoal
    extends MeleeAttackGoal {
        private int delayCounter;
        private static final float SPEED = 1.25f;

        public VanguardAttackGoal() {
            super((PathfinderMob)VanguardServant.this, 1.25, true);
        }

        public boolean m_8036_() {
            return VanguardServant.this.m_5448_() != null && VanguardServant.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            VanguardServant.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = VanguardServant.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            VanguardServant.this.f_21365_.m_24960_((Entity)livingentity, 30.0f, 30.0f);
            double d0 = VanguardServant.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            if (--this.delayCounter <= 0 && !VanguardServant.this.targetClose(livingentity, d0)) {
                this.delayCounter = 10;
                VanguardServant.this.m_21573_().m_5624_((Entity)livingentity, 1.25);
            }
            this.m_6739_(livingentity, VanguardServant.this.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (VanguardServant.this.targetClose(enemy, distToEnemySqr) && !VanguardServant.this.isMeleeAttacking()) {
                VanguardServant.this.setMeleeAttacking(true);
            }
        }

        public void m_8041_() {
            VanguardServant.this.m_21573_().m_26573_();
            if (VanguardServant.this.m_5448_() == null) {
                VanguardServant.this.m_21561_(false);
            }
        }
    }
}

