/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.zombie;

import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class ZombieVillagerServant
extends ZombieServant
implements InventoryCarrier,
VillagerDataHolder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(ZombieVillagerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.m_135353_(ZombieVillagerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135043_);
    private static final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)Items.f_42620_, (Object)Items.f_42619_, (Object)Items.f_42405_, (Object)Items.f_42404_, (Object)Items.f_42732_, (Object)Items.f_42733_, (Object[])new Item[]{Items.f_271133_, Items.f_276594_});
    public int villagerConversionTime;
    @Nullable
    private UUID conversionStarter;
    @Nullable
    private Tag gossips;
    @Nullable
    private CompoundTag tradeOffers;
    private int villagerXp;
    private final SimpleContainer inventory = new SimpleContainer(8);

    public ZombieVillagerServant(EntityType<? extends ZombieVillagerServant> p_34368_, Level p_34369_) {
        super((EntityType<? extends Summoned>)p_34368_, p_34369_);
        BuiltInRegistries.f_256735_.m_213642_(this.f_19796_).ifPresent(p_255550_ -> this.m_34375_(this.m_7141_().m_35565_((VillagerProfession)p_255550_.m_203334_())));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_VILLAGER_DATA, (Object)new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35585_, 1));
    }

    @Override
    public void m_7380_(CompoundTag p_34397_) {
        super.m_7380_(p_34397_);
        VillagerData.f_35550_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.m_7141_()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_204072_ -> p_34397_.m_128365_("VillagerData", p_204072_));
        if (this.tradeOffers != null) {
            p_34397_.m_128365_("Offers", (Tag)this.tradeOffers);
        }
        if (this.gossips != null) {
            p_34397_.m_128365_("Gossips", this.gossips);
        }
        p_34397_.m_128405_("ConversionTime", this.isConverting() ? this.villagerConversionTime : -1);
        if (this.conversionStarter != null) {
            p_34397_.m_128362_("ConversionPlayer", this.conversionStarter);
        }
        p_34397_.m_128405_("Xp", this.villagerXp);
        this.m_252802_(p_34397_);
    }

    @Override
    public void m_7378_(CompoundTag p_34387_) {
        super.m_7378_(p_34387_);
        if (p_34387_.m_128425_("VillagerData", 10)) {
            DataResult dataresult = VillagerData.f_35550_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_34387_.m_128423_("VillagerData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::m_34375_);
        }
        if (p_34387_.m_128425_("Offers", 10)) {
            this.tradeOffers = p_34387_.m_128469_("Offers");
        }
        if (p_34387_.m_128425_("Gossips", 9)) {
            this.gossips = p_34387_.m_128437_("Gossips", 10);
        }
        if (p_34387_.m_128425_("ConversionTime", 99) && p_34387_.m_128451_("ConversionTime") > -1) {
            this.startConverting(p_34387_.m_128403_("ConversionPlayer") ? p_34387_.m_128342_("ConversionPlayer") : null, p_34387_.m_128451_("ConversionTime"));
        }
        if (p_34387_.m_128425_("Xp", 3)) {
            this.villagerXp = p_34387_.m_128451_("Xp");
        }
        this.m_253224_(p_34387_);
    }

    @Override
    public void m_8119_() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_6084_() && this.isConverting()) {
                int i = this.getConversionProgress();
                this.villagerConversionTime -= i;
                if (this.villagerConversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                    this.villagerConversionTime = timer;
                })) {
                    this.finishConversion(serverLevel);
                }
            }
        }
        super.m_8119_();
    }

    public boolean canConvert() {
        return this.isNatural();
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!this.f_19853_.f_46443_ && this.canConvert() && itemstack.m_150930_(Items.f_42436_)) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.startConverting(pPlayer.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    public boolean m_6785_(double p_34414_) {
        return !this.isConverting() && this.villagerXp == 0;
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID p_34384_, int p_34385_) {
        this.conversionStarter = p_34384_;
        this.villagerConversionTime = p_34385_;
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, p_34385_, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.f_19853_.m_7605_((Entity)this, (byte)16);
    }

    public void m_7822_(byte p_34372_) {
        if (p_34372_ == 16) {
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(p_34372_);
        }
    }

    private void finishConversion(ServerLevel p_34399_) {
        Player player;
        Villager villager = (Villager)this.m_21406_(EntityType.f_20492_, false);
        if (villager == null) {
            return;
        }
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            ItemStack itemstack = this.m_6844_(equipmentslot);
            if (itemstack.m_41619_()) continue;
            if (EnchantmentHelper.m_44920_((ItemStack)itemstack)) {
                villager.m_141942_(equipmentslot.m_20749_() + 300).m_142104_(itemstack);
                continue;
            }
            double d0 = this.m_21519_(equipmentslot);
            if (!(d0 > 1.0)) continue;
            this.m_19983_(itemstack);
        }
        villager.m_34375_(this.m_7141_());
        if (this.gossips != null) {
            villager.m_35455_(this.gossips);
        }
        if (this.tradeOffers != null) {
            villager.m_35476_(new MerchantOffers(this.tradeOffers));
        }
        villager.m_35546_(this.villagerXp);
        villager.m_6518_((ServerLevelAccessor)p_34399_, p_34399_.m_6436_(villager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
        villager.m_35483_(p_34399_);
        if (this.conversionStarter != null && (player = p_34399_.m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
            p_34399_.m_8670_(ReputationEventType.f_26985_, (Entity)player, (ReputationEventHandler)villager);
        }
        villager.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!this.m_20067_()) {
            p_34399_.m_5898_((Player)null, 1027, this.m_20183_(), 0);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)villager);
    }

    private int getConversionProgress() {
        int i = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.m_20189_() - 4; i1 < (int)this.m_20189_() + 4 && j < 14; ++i1) {
                        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k, l, i1));
                        if (!blockstate.m_60713_(Blocks.f_50183_) && !(blockstate.m_60734_() instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public SlotAccess m_141942_(int p_149995_) {
        int i = p_149995_ - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(p_149995_);
    }

    protected void m_7581_(ItemEntity p_35467_) {
        InventoryCarrier.m_219611_((Mob)this, (InventoryCarrier)this, (ItemEntity)p_35467_);
    }

    public boolean m_21531_() {
        return super.m_21531_() || this.m_7141_().m_35571_() == VillagerProfession.f_35590_;
    }

    public boolean m_7243_(ItemStack p_35543_) {
        Item item = p_35543_.m_41720_();
        return (WANTED_ITEMS.contains(item) || this.m_7141_().m_35571_().f_35602_().contains((Object)item)) && this.m_35311_().m_19183_(p_35543_);
    }

    public boolean hasFarmSeeds() {
        return this.m_35311_().m_216874_(p_281096_ -> p_281096_.m_204117_(ItemTags.f_279581_));
    }

    public float m_6100_() {
        return this.m_6162_() ? (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 2.0f : (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEvent m_7515_() {
        return SoundEvents.f_12615_;
    }

    @Override
    public SoundEvent m_7975_(DamageSource p_34404_) {
        return SoundEvents.f_12646_;
    }

    @Override
    public SoundEvent m_5592_() {
        return SoundEvents.f_12645_;
    }

    @Override
    public SoundEvent getStepSound() {
        return SoundEvents.f_12647_;
    }

    public void setTradeOffers(CompoundTag p_34412_) {
        this.tradeOffers = p_34412_;
    }

    public void setGossips(Tag p_34392_) {
        this.gossips = p_34392_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34378_, DifficultyInstance p_34379_, MobSpawnType p_34380_, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag p_34382_) {
        spawnDataIn = super.m_6518_(p_34378_, p_34379_, p_34380_, spawnDataIn, p_34382_);
        this.m_34375_(this.m_7141_().m_35567_(VillagerType.m_204073_((Holder)p_34378_.m_204166_(this.m_20183_()))));
        return spawnDataIn;
    }

    public void m_34375_(VillagerData p_34376_) {
        VillagerData villagerdata = this.m_7141_();
        if (villagerdata.m_35571_() != p_34376_.m_35571_()) {
            this.tradeOffers = null;
        }
        this.f_19804_.m_135381_(DATA_VILLAGER_DATA, (Object)p_34376_);
    }

    public VillagerData m_7141_() {
        return (VillagerData)this.f_19804_.m_135370_(DATA_VILLAGER_DATA);
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int p_34374_) {
        this.villagerXp = p_34374_;
    }
}

