/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.cultists;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ai.WitchBarterGoal;
import com.Polarice3.Goety.common.entities.ally.MagmaCubeServant;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.hostile.servants.ObsidianMonolith;
import com.Polarice3.Goety.common.entities.neutral.BlazeServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinServant;
import com.Polarice3.Goety.common.entities.projectiles.HellChant;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class Heretic
extends Cultist {
    private static final EntityDataAccessor<Boolean> CHANTING = SynchedEntityData.m_135353_(Heretic.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CASTING = SynchedEntityData.m_135353_(Heretic.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final DynamicGameEventListener<GameEventListener> gameEventListener;
    private ObsidianMonolith monolith;
    public List<Vec3> convokePos = new ArrayList<Vec3>();
    public int chantCoolDown;
    public int chantTimes;
    public int castCoolDown;
    public float castAmount = 0.125f;
    public float castOld;
    public float cast;

    public Heretic(EntityType<? extends Cultist> type, Level worldIn) {
        super(type, worldIn);
        this.gameEventListener = new DynamicGameEventListener(new GameEventListener(){

            public PositionSource m_142460_() {
                return new BlockPositionSource(Heretic.this.m_20183_());
            }

            public int m_142078_() {
                return 32;
            }

            public GameEventListener.DeliveryMode m_247514_() {
                return GameEventListener.DeliveryMode.BY_DISTANCE;
            }

            public boolean m_214068_(ServerLevel serverLevel, GameEvent p_282184_, GameEvent.Context p_283014_, Vec3 p_282350_) {
                Mob mob;
                Entity sourceEntity;
                if (!Heretic.this.m_213877_() && p_282184_ == GameEvent.f_223707_ && (sourceEntity = p_283014_.f_223711_()) instanceof Mob && !((mob = (Mob)sourceEntity) instanceof IOwned) && !(mob instanceof Heretic)) {
                    Heretic.this.getConvokePos().add(mob.m_20182_());
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PrayToMonolithGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WitchBarterGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ChantAtTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CastingGoal(this));
        this.f_21345_.m_25352_(4, AvoidTargetGoal.newGoal((PathfinderMob)this, 4.0f, 1.0, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableWitchTargetGoal((Raider)this, Player.class, 10, true, false, null));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.HereticHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.HereticArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.HereticDamage.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.HereticHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.HereticArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.HereticDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CHANTING, (Object)false);
        this.m_20088_().m_135372_(CASTING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ChantCoolDown", this.getChantCoolDown());
        pCompound.m_128405_("ChantTimes", this.getChantTimes());
        pCompound.m_128405_("CastCoolDown", this.getCastCoolDown());
        if (!this.getConvokePos().isEmpty()) {
            ListTag listTag = new ListTag();
            for (Vec3 vec3 : this.getConvokePos()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128347_("PosX", vec3.f_82479_);
                tag.m_128347_("PosY", vec3.f_82480_);
                tag.m_128347_("PosZ", vec3.f_82481_);
                listTag.add((Object)tag);
            }
            pCompound.m_128365_("ConvokePos", (Tag)listTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ChantCoolDown")) {
            this.setChantCoolDown(pCompound.m_128451_("ChantCoolDown"));
        }
        if (pCompound.m_128441_("ChantTimes")) {
            this.setChantTimes(pCompound.m_128451_("ChantTimes"));
        }
        if (pCompound.m_128441_("CastCoolDown")) {
            this.setCastCoolDown(pCompound.m_128451_("CastCoolDown"));
        }
        if (pCompound.m_128441_("ConvokePos")) {
            ListTag listTag = pCompound.m_128437_("ConvokePos", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.m_128728_(i);
                Vec3 vec3 = new Vec3(tag.m_128459_("PosX"), tag.m_128459_("PosY"), tag.m_128459_("PosZ"));
                this.getConvokePos().add(vec3);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.HERETIC_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        return (SoundEvent)ModSounds.HERETIC_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.HERETIC_DEATH.get();
    }

    @Override
    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.HERETIC_CELEBRATE.get();
    }

    public void setChanting(boolean chanting) {
        this.m_20088_().m_135381_(CHANTING, (Object)chanting);
    }

    public boolean isChanting() {
        return (Boolean)this.m_20088_().m_135370_(CHANTING);
    }

    public int getChantCoolDown() {
        return this.chantCoolDown;
    }

    public void setChantCoolDown(int chantCoolDown) {
        this.chantCoolDown = chantCoolDown;
    }

    public int getChantTimes() {
        return this.chantTimes;
    }

    public void setChantTimes(int chantTimes) {
        this.chantTimes = chantTimes;
    }

    public void setCasting(boolean casting) {
        this.m_20088_().m_135381_(CASTING, (Object)casting);
    }

    public boolean isCasting() {
        return (Boolean)this.m_20088_().m_135370_(CASTING);
    }

    public int getCastCoolDown() {
        return this.castCoolDown;
    }

    public void setCastCoolDown(int castCoolDown) {
        this.castCoolDown = castCoolDown;
    }

    public List<Vec3> getConvokePos() {
        return this.convokePos;
    }

    public void setMonolith(@Nullable ObsidianMonolith monolith) {
        this.monolith = monolith;
    }

    @Nullable
    public ObsidianMonolith getMonolith() {
        return this.monolith;
    }

    @Override
    public boolean m_7307_(Entity entityIn) {
        if (entityIn instanceof ObsidianMonolith) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        if (entityIn instanceof ZombifiedPiglin) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn);
    }

    public void m_7334_(Entity p_21294_) {
        if (!this.f_19853_.f_46443_ && !this.isCasting() && this.f_19797_ >= 20) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_7324_(Entity p_20971_) {
        if (!this.f_19853_.f_46443_ && !this.isCasting() && this.f_19797_ >= 20) {
            super.m_7324_(p_20971_);
        }
    }

    public boolean m_7337_(Entity p_20303_) {
        if (!this.isCasting() && this.f_19797_ >= 20) {
            return super.m_7337_(p_20303_);
        }
        return false;
    }

    @Override
    public boolean isBarterable() {
        return !this.isCasting();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.chantCoolDown > 0) {
                --this.chantCoolDown;
            }
            if (this.castCoolDown > 0) {
                --this.castCoolDown;
            }
            if (this.getMonolith() == null) {
                Entity entity = this.getLeader();
                if (entity instanceof ObsidianMonolith) {
                    ObsidianMonolith obsidianMonolith = (ObsidianMonolith)entity;
                    this.setMonolith(obsidianMonolith);
                } else {
                    for (ObsidianMonolith monolith1 : this.f_19853_.m_45976_(ObsidianMonolith.class, this.m_20191_().m_82377_(64.0, 8.0, 64.0))) {
                        if (monolith1.getTrueOwner() != null && !(monolith1.getTrueOwner() instanceof Cultist)) continue;
                        this.setMonolith(monolith1);
                    }
                }
            } else if (this.getMonolith() != null && this.getLeader() != this.getMonolith()) {
                this.setLeader((Entity)this.getMonolith());
            }
        } else {
            this.castOld = this.cast;
            if (this.isCasting()) {
                this.casting();
            } else {
                this.cast = Mth.m_14036_((float)(this.cast - 0.1f), (float)0.0f, (float)1.0f);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19796_.m_188501_() < 7.5E-4f) {
            this.f_19853_.m_7605_((Entity)this, (byte)15);
        }
    }

    public void casting() {
        this.cast = Mth.m_14036_((float)(this.cast + this.castAmount), (float)0.0f, (float)1.0f);
        if (this.cast == 0.0f || this.cast == 1.0f) {
            this.castAmount *= -1.0f;
        }
    }

    public float getCast(float p_268054_) {
        return Mth.m_14179_((float)p_268054_, (float)this.castOld, (float)this.cast);
    }

    protected float m_6515_(DamageSource damageSource, float damage) {
        damage = super.m_6515_(damageSource, damage);
        if (damageSource.m_7639_() == this) {
            damage = 0.0f;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268731_) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            damage *= 0.15f;
        }
        return damage;
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> p_218348_) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            p_218348_.accept(this.gameEventListener, serverlevel);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.setChanting(true);
        } else if (pId == 5) {
            this.setChanting(false);
        } else if (pId == 6) {
            this.setCasting(true);
        } else if (pId == 7) {
            this.setCasting(false);
        } else if (pId == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.RISING_ENCHANT.get(), this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + 0.5 + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue());
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public static class PrayToMonolithGoal
    extends Goal {
        public Heretic heretic;

        public PrayToMonolithGoal(Heretic heretic) {
            this.heretic = heretic;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.heretic.getMonolith() != null && this.heretic.getMonolith().m_6084_() && this.heretic.m_21223_() == this.heretic.m_21233_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.heretic.isCasting()) {
                this.heretic.setCasting(false);
            }
        }

        public void m_8037_() {
            if (this.heretic.getMonolith() != null) {
                if ((double)this.heretic.m_20270_((Entity)this.heretic.getMonolith()) <= 8.0 && this.heretic.m_142582_((Entity)this.heretic.getMonolith())) {
                    this.heretic.m_6710_(null);
                    if (!this.heretic.isCasting()) {
                        this.heretic.setCasting(true);
                    }
                    MobUtil.instaLook((Mob)this.heretic, (Entity)this.heretic.getMonolith());
                    this.drawParticleBeam((LivingEntity)this.heretic, (LivingEntity)this.heretic.getMonolith());
                    if (this.heretic.f_19797_ % 20 == 0) {
                        this.heretic.getMonolith().m_5634_(1.0f);
                    }
                    this.heretic.getMonolith().empowered = 10;
                    this.heretic.m_21573_().m_26573_();
                    this.heretic.f_20891_ = 0;
                } else {
                    if (this.heretic.isCasting()) {
                        this.heretic.setCasting(false);
                    }
                    Vec3 vec3 = this.heretic.getMonolith().m_20182_();
                    this.heretic.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                }
            }
        }

        private void drawParticleBeam(LivingEntity pSource, LivingEntity pTarget) {
            double d0 = pTarget.m_20185_() - pSource.m_20185_();
            double d1 = pTarget.m_20186_() + (double)pTarget.m_20206_() * 0.5 - (pSource.m_20186_() + (double)pSource.m_20206_() * 0.5);
            double d2 = pTarget.m_20189_() - pSource.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d0 /= d3;
            d1 /= d3;
            d2 /= d3;
            double d4 = pSource.f_19853_.f_46441_.m_188500_();
            if (!pSource.f_19853_.f_46443_) {
                ServerLevel serverWorld = (ServerLevel)pSource.f_19853_;
                while (d4 < d3) {
                    serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.CHANT.get()), pSource.m_20185_() + d0 * (d4 += 0.5), pSource.m_20186_() + d1 * d4 + (double)pSource.m_20192_(), pSource.m_20189_() + d2 * d4, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static class ChantAtTargetGoal
    extends Goal {
        public Heretic heretic;
        public int chantTime;

        public ChantAtTargetGoal(Heretic heretic) {
            this.heretic = heretic;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.heretic.getChantCoolDown() > 0) {
                return false;
            }
            LivingEntity target = this.heretic.m_5448_();
            return target != null && target.m_6084_() && (double)this.heretic.m_20270_((Entity)target) <= this.heretic.m_21133_(Attributes.f_22277_) && this.heretic.m_142582_((Entity)target);
        }

        public boolean m_8045_() {
            return this.chantTime < 60;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.chantTime = 0;
            this.heretic.m_21573_().m_26573_();
            this.heretic.setChanting(true);
            this.heretic.f_19853_.m_7605_((Entity)this.heretic, (byte)4);
            this.heretic.setChantTimes(0);
            this.heretic.m_5496_((SoundEvent)ModSounds.HERETIC_CHANT.get(), 2.0f, 0.5f);
        }

        public void m_8041_() {
            super.m_8041_();
            this.heretic.setChanting(false);
            this.heretic.f_19853_.m_7605_((Entity)this.heretic, (byte)5);
            this.heretic.setChantCoolDown(100);
            this.heretic.setChantTimes(0);
        }

        public void m_8037_() {
            HellChant hellChant;
            ++this.chantTime;
            this.heretic.m_21573_().m_26573_();
            this.heretic.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.heretic.m_5448_() != null) {
                MobUtil.instaLook((Mob)this.heretic, (Entity)this.heretic.m_5448_());
            }
            if (this.chantTime % 10 == 0 && (hellChant = (HellChant)((EntityType)ModEntityType.HELL_CHANT.get()).m_20615_(this.heretic.f_19853_)) != null) {
                hellChant.setExtraDamage(3.0f);
                if (this.heretic.f_19853_.m_46791_() == Difficulty.HARD) {
                    hellChant.setBurning(1);
                }
                hellChant.chant((LivingEntity)this.heretic);
                this.heretic.f_19853_.m_7967_((Entity)hellChant);
            }
            super.m_8037_();
        }
    }

    public static class CastingGoal
    extends Goal {
        public Heretic heretic;
        public int movingTime;
        public int castingTime;
        public Vec3 targetPos = null;
        public static int TOTAL_CAST_TIME = 30;

        public CastingGoal(Heretic heretic) {
            this.heretic = heretic;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.heretic.m_5448_();
            return target != null && target.m_6084_() && !this.heretic.getConvokePos().isEmpty() && this.heretic.getCastCoolDown() <= 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.movingTime <= 100 && this.castingTime <= TOTAL_CAST_TIME;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.movingTime = 0;
            this.castingTime = 0;
            this.findTargetPos();
        }

        public void m_8041_() {
            super.m_8041_();
            this.heretic.setCasting(false);
            this.heretic.f_19853_.m_7605_((Entity)this.heretic, (byte)7);
        }

        public void findTargetPos() {
            block9: {
                double hitDist = 0.0;
                if (!this.heretic.getConvokePos().isEmpty()) {
                    for (Vec3 vec31 : this.heretic.getConvokePos()) {
                        double possibleDist;
                        if (!this.heretic.m_21573_().m_6342_(BlockPos.m_274446_((Position)vec31))) continue;
                        Optional interceptPos = this.heretic.m_20191_().m_82371_(vec31, vec31.m_82520_(1.0, 1.0, 1.0));
                        if (this.heretic.m_20191_().m_82400_(this.heretic.m_21133_(Attributes.f_22277_)).m_82390_(vec31)) {
                            if (!(0.0 <= hitDist)) continue;
                            this.targetPos = vec31;
                            hitDist = 0.0;
                            continue;
                        }
                        if (!interceptPos.isPresent() || !((possibleDist = vec31.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
                        this.targetPos = vec31;
                        hitDist = possibleDist;
                    }
                    try {
                        if (this.targetPos == null) break block9;
                        try {
                            for (Heretic heretic1 : this.heretic.f_19853_.m_45976_(Heretic.class, this.heretic.m_20191_().m_82400_(this.heretic.m_21133_(Attributes.f_22277_)))) {
                                if (heretic1 == this.heretic || heretic1.getConvokePos().isEmpty()) continue;
                                heretic1.getConvokePos().remove(this.targetPos);
                            }
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                        }
                    }
                    catch (NullPointerException nullPointerException) {}
                } else {
                    this.targetPos = null;
                }
            }
        }

        public void m_8037_() {
            if (this.targetPos != null) {
                Level level = this.heretic.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.RISING_ENCHANT.get(), this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, colorUtil.red, colorUtil.green, colorUtil.blue, 1.0f);
                }
                if (this.heretic.m_20238_(this.targetPos) > Mth.m_144952_((double)4.0)) {
                    ++this.movingTime;
                    this.heretic.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, 1.0);
                } else {
                    MobUtil.instaLook((Mob)this.heretic, this.targetPos);
                    ++this.castingTime;
                    if (!this.heretic.isCasting()) {
                        this.heretic.setCasting(true);
                        this.heretic.f_19853_.m_7605_((Entity)this.heretic, (byte)6);
                    }
                    if (this.castingTime == TOTAL_CAST_TIME) {
                        Summoned summon = new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), this.heretic.f_19853_);
                        if (this.heretic.f_19796_.m_188501_() <= 0.25f) {
                            summon = new MagmaCubeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.MAGMA_CUBE_SERVANT.get()), this.heretic.f_19853_);
                        } else if (this.heretic.f_19796_.m_188501_() <= 0.05f) {
                            summon = new BlazeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.BLAZE_SERVANT.get()), this.heretic.f_19853_);
                        }
                        summon.m_20219_(this.targetPos);
                        summon.setTrueOwner((LivingEntity)this.heretic);
                        Level level2 = this.heretic.f_19853_;
                        if (level2 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level2;
                            summon.m_6518_((ServerLevelAccessor)serverLevel, this.heretic.f_19853_.m_6436_(BlockPos.m_274446_((Position)this.targetPos)), MobSpawnType.MOB_SUMMONED, null, null);
                            ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123744_, (Entity)summon);
                        }
                        if (summon instanceof MagmaCubeServant) {
                            MagmaCubeServant cube = (MagmaCubeServant)summon;
                            cube.setSize(2, true);
                        }
                        if (this.heretic.m_5448_() != null) {
                            summon.m_6710_(this.heretic.m_5448_());
                        }
                        summon.setLimitedLife(MathHelper.minecraftDayToTicks(5));
                        if (this.heretic.f_19853_.m_7967_((Entity)summon)) {
                            summon.m_5496_((SoundEvent)ModSounds.SUMMON_SPELL_FIERY.get(), 1.0f, 1.0f);
                            this.heretic.getConvokePos().remove(this.targetPos);
                            this.heretic.setCastCoolDown(100);
                        }
                    }
                }
            } else {
                this.findTargetPos();
            }
            super.m_8037_();
        }
    }
}

