/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.projectiles.IllBomb;
import com.Polarice3.Goety.common.entities.projectiles.MagicBolt;
import com.Polarice3.Goety.common.entities.projectiles.ViciousTooth;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Minister
extends HuntingIllagerEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> HAS_STAFF = SynchedEntityData.m_135353_(Minister.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(Minister.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Goety.location("textures/entity/illagers/minister/minister.png"));
        map.put(1, Goety.location("textures/entity/illagers/minister/minister_2.png"));
        map.put(2, Goety.location("textures/entity/illagers/minister/minister_3.png"));
    });
    private final ModServerBossInfo bossInfo;
    public float staffDamage;
    public int coolDown;
    public int deathTime = 0;
    public float deathRotation = 0.0f;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState castAnimationState = new AnimationState();
    public AnimationState laughAnimationState = new AnimationState();
    public AnimationState laughTargetAnimationState = new AnimationState();
    public AnimationState commandAnimationState = new AnimationState();
    public AnimationState blockAnimationState = new AnimationState();
    public AnimationState smashedAnimationState = new AnimationState();
    public AnimationState speechAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public static final Predicate<AbstractIllager> NOT_THEMSELVES = p_20434_ -> !(p_20434_ instanceof Minister) && !(p_20434_.m_5448_() instanceof Minister);

    public Minister(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
        this.bossInfo = new ModServerBossInfo((Mob)this, BossEvent.BossBarColor.PURPLE, false, false);
        this.f_21364_ = 99;
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getOutfitType(), TEXTURE_BY_TYPE.get(0));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new SpeechGoal());
        this.f_21345_.m_25352_(4, (Goal)new LaughTargetGoal());
        this.f_21345_.m_25352_(5, (Goal)new CommandGoal());
        this.f_21345_.m_25352_(6, (Goal)new TeethSpellGoal());
        this.f_21345_.m_25352_(7, AvoidTargetGoal.newGoal((PathfinderMob)this, 4.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new MinisterRangedGoal(this, 1.0, 20, 16.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !Minister.this.hasNearbyIllagers();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new MinisterRangedGoal(this, 1.0, 20, 60, 16.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Minister.this.hasNearbyIllagers();
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.MinisterHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.MinisterDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.MinisterHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.MinisterDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)1);
        this.f_19804_.m_135372_(HAS_STAFF, (Object)true);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("HasStaff", this.hasStaff());
        pCompound.m_128350_("StaffDamage", this.staffDamage);
        pCompound.m_128405_("Outfit", this.getOutfitType());
        pCompound.m_128405_("CoolDown", this.coolDown);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("HasStaff")) {
            this.setHasStaff(pCompound.m_128471_("HasStaff"));
        }
        if (pCompound.m_128441_("StaffDamage")) {
            this.staffDamage = pCompound.m_128457_("StaffDamage");
        }
        if (pCompound.m_128441_("Outfit")) {
            this.setOutfitType(pCompound.m_128451_("Outfit"));
        }
        if (pCompound.m_128441_("CoolDown")) {
            this.coolDown = pCompound.m_128451_("CoolDown");
        }
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public int getOutfitType() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setOutfitType(int pType) {
        if (pType < 0 || pType >= this.OutfitTypeNumber() + 1) {
            pType = this.f_19796_.m_188503_(this.OutfitTypeNumber());
        }
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public int OutfitTypeNumber() {
        return TEXTURE_BY_TYPE.size();
    }

    public boolean hasStaff() {
        return (Boolean)this.f_19804_.m_135370_(HAS_STAFF);
    }

    public void setHasStaff(boolean staff) {
        this.f_19804_.m_135381_(HAS_STAFF, (Object)staff);
    }

    public List<AbstractIllager> getNearbyIllagers() {
        return this.f_19853_.m_6443_(AbstractIllager.class, this.m_20191_().m_82377_(32.0, 16.0, 32.0), NOT_THEMSELVES);
    }

    public boolean hasNearbyIllagers() {
        return !this.getNearbyIllagers().isEmpty();
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_() || this.m_37888_() || this.m_21224_() || this.isCasting()) {
            return AbstractIllager.IllagerArmPose.NEUTRAL;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.castAnimationState);
        animationStates.add(this.laughAnimationState);
        animationStates.add(this.laughTargetAnimationState);
        animationStates.add(this.commandAnimationState);
        animationStates.add(this.blockAnimationState);
        animationStates.add(this.smashedAnimationState);
        animationStates.add(this.speechAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MINISTER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MINISTER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.MINISTER_HURT.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.MINISTER_CELEBRATE.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @org.jetbrains.annotations.Nullable SpawnGroupData p_37859_, @org.jetbrains.annotations.Nullable CompoundTag p_37860_) {
        this.setOutfitType(this.f_19796_.m_188503_(this.OutfitTypeNumber()));
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    public boolean m_21526_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (!this.f_19853_.f_46443_ && this.hasStaff() && this.m_5912_() && !this.isCasting() && this.coolDown <= 10) {
            if (this.staffDamage >= 64.0f) {
                this.setHasStaff(false);
                this.f_19853_.m_7605_((Entity)this, (byte)13);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 20; ++i) {
                        ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModItems.DARK_FABRIC.get())), (Entity)this);
                    }
                }
                if (p_37849_.m_7639_() != null) {
                    MobUtil.knockBack((Entity)this, p_37849_.m_7639_(), 4.0, 0.2, 4.0);
                }
                this.m_5496_(SoundEvents.f_12018_, 4.0f, 1.0f);
                return false;
            }
            if (!(p_37849_.m_269533_(DamageTypeTags.f_268738_) || p_37849_.m_269533_(DamageTypeTags.f_268437_) || p_37849_.m_269533_(DamageTypeTags.f_268413_) || p_37849_.m_269533_(DamageTypeTags.f_268415_) || p_37849_.m_19390_() || p_37849_.m_7639_() == null)) {
                Vec3 vec32 = p_37849_.m_7270_();
                if (vec32 != null) {
                    MobUtil.instaLook((Mob)this, vec32);
                    if (ModDamageSource.toolAttack(p_37849_, item -> item instanceof AxeItem)) {
                        p_37850_ *= 2.0f;
                    }
                    this.staffDamage += p_37850_;
                    this.f_19853_.m_7605_((Entity)this, (byte)8);
                    this.m_216990_(SoundEvents.f_12346_);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 5; ++i) {
                            ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModItems.DARK_FABRIC.get())), (Entity)this);
                        }
                    }
                    if (this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
                        this.m_216990_((SoundEvent)ModSounds.MINISTER_LAUGH.get());
                    }
                }
                return false;
            }
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime == 40) {
            this.m_21373_();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        this.f_19853_.m_7605_((Entity)this, (byte)10);
        this.deathRotation = this.m_146908_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Player player : serverLevel.m_45976_(Player.class, this.m_20191_().m_82400_(32.0))) {
                SEHelper.setRestPeriod(player, MathHelper.minecraftDayToTicks((Integer)MobsConfig.IllagerAssaultRestMinister.get()));
            }
        }
        super.m_6667_(p_21014_);
    }

    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        super.m_7472_(p_21385_, p_21386_, p_21387_);
        if (this.hasStaff()) {
            ItemStack itemStack = ((Item)ModItems.OMINOUS_ORB.get()).m_7968_();
            ItemEntity itementity = this.m_19983_(itemStack);
            if (itementity != null) {
                itementity.m_32064_();
            }
        } else {
            ItemStack itemStack = ((Item)ModItems.OMINOUS_SHARD.get()).m_7968_();
            ItemEntity itementity = this.m_19983_(itemStack);
            if (itementity != null) {
                itementity.m_32064_();
            }
        }
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack itemStack, float p_19986_) {
        if (itemStack.m_41619_()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)p_19986_, this.m_20189_(), itemStack, this.f_19796_.m_188500_() * 0.4 - 0.2, 0.4, this.f_19796_.m_188500_() * 0.4 - 0.2);
        itementity.m_32060_();
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.f_19853_.m_7967_((Entity)itementity);
        }
        return itementity;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_8321_((Boolean)MainConfig.SpecialBossBar.get());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossInfo.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    @Override
    public void m_8119_() {
        Object object;
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.m_37888_() && this.f_19797_ % 100 == 0 && this.f_20916_ <= 0) {
            this.laughAnimationState.m_216977_(this.f_19797_);
            this.f_19853_.m_7605_((Entity)this, (byte)6);
        }
        if (this.m_21224_()) {
            for (AnimationState animationState : this.getAnimations()) {
                if (animationState == this.deathAnimationState) continue;
                animationState.m_216973_();
            }
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        }
        if ((object = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            if (this.hasStaff() && !this.m_21205_().m_41619_()) {
                if (this.m_21206_().m_41619_()) {
                    this.m_8061_(EquipmentSlot.OFFHAND, this.m_21206_());
                } else {
                    this.m_19983_(this.m_21205_());
                }
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
            ServerParticleUtil.addAuraParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123809_, (Entity)this, 8.0f);
            for (LivingEntity living : serverLevel.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                if (living.m_6336_() != MobType.f_21643_ || living == this) continue;
                boolean flag = false;
                if (living instanceof Mob) {
                    Mob mob = (Mob)living;
                    if (mob.m_5448_() != this) {
                        flag = true;
                    }
                } else {
                    flag = true;
                }
                if (!flag) continue;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 0, false, false));
            }
            if (this.coolDown > 0) {
                --this.coolDown;
            }
            if (this.m_5448_() != null) {
                serverLevel.m_7605_((Entity)this, (byte)14);
            } else {
                serverLevel.m_7605_((Entity)this, (byte)15);
            }
            this.m_21561_(this.m_5448_() != null);
        }
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        if (this.hasStaff()) {
            Vec3 vector3d = this.m_20252_(1.0f);
            double d1 = p_33317_.m_20185_() - this.m_20185_();
            double d2 = p_33317_.m_20227_(0.5) - this.m_20227_(0.5);
            double d3 = p_33317_.m_20189_() - this.m_20189_();
            MagicBolt magicBolt = new MagicBolt(this.f_19853_, (LivingEntity)this, d1, d2, d3);
            magicBolt.m_146922_(this.m_146908_());
            magicBolt.m_146926_(this.m_146909_());
            magicBolt.m_6034_(this.m_20185_() + vector3d.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + vector3d.f_82481_ / 2.0);
            this.m_5496_((SoundEvent)ModSounds.CAST_SPELL.get(), 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)magicBolt);
        } else {
            IllBomb snowball = new IllBomb((LivingEntity)this, this.f_19853_);
            double d0 = p_33317_.m_20188_() - (double)1.1f;
            double d1 = p_33317_.m_20185_() - this.m_20185_();
            double d2 = d0 - snowball.m_20186_();
            double d3 = p_33317_.m_20189_() - this.m_20189_();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            float velocity = p_33317_.m_20270_((Entity)this) >= 10.0f ? 1.0f : 0.5f;
            snowball.m_6686_(d1, d2 + d4, d3, velocity, 0.5f);
            this.m_5496_(SoundEvents.f_12553_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)snowball);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 5) {
            this.castAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 6) {
            this.laughAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 7) {
            this.laughTargetAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 8) {
            this.blockAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 10) {
            this.deathAnimationState.m_216977_(this.f_19797_);
            this.deathRotation = this.m_146908_();
            this.m_5496_((SoundEvent)ModSounds.MINISTER_DEATH.get(), 4.0f, 1.0f);
        } else if (pId == 11) {
            this.speechAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 12) {
            this.commandAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 13) {
            this.smashedAnimationState.m_216977_(this.f_19797_);
            this.setHasStaff(false);
        } else if (pId == 14) {
            this.m_21561_(true);
        } else if (pId == 15) {
            this.m_21561_(false);
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_6072_() {
        return false;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private CastingSpellGoal() {
            super((SpellcasterIllager)Minister.this);
        }

        public void m_8037_() {
            if (Minister.this.m_5448_() != null) {
                MobUtil.instaLook((Mob)Minister.this, (Entity)Minister.this.m_5448_());
                Minister.this.m_21563_().m_24960_((Entity)Minister.this.m_5448_(), 500.0f, (float)Minister.this.m_8132_());
            }
        }
    }

    class SpeechGoal
    extends CastingGoal {
        private SpeechGoal() {
            this.hasCastSound = false;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && Minister.this.hasNearbyIllagers();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Minister.this.speechAnimationState.m_216977_(Minister.this.f_19797_);
            Minister.this.f_19853_.m_7605_((Entity)Minister.this, (byte)11);
        }

        protected int m_8089_() {
            return MathHelper.secondsToTicks(3);
        }

        protected int m_8067_() {
            return MathHelper.secondsToTicks(10);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            for (AbstractIllager abstractIllager : Minister.this.getNearbyIllagers()) {
                if (!abstractIllager.m_6084_() || !(abstractIllager.m_21233_() < Minister.this.m_21233_()) || abstractIllager.m_5448_() == Minister.this || abstractIllager.m_21188_() != null && abstractIllager.m_7307_((Entity)abstractIllager.m_21188_())) continue;
                abstractIllager.m_6710_(null);
                abstractIllager.m_21561_(false);
                abstractIllager.m_21573_().m_26573_();
                MobUtil.instaLook((Mob)abstractIllager, (Entity)Minister.this);
                abstractIllager.m_21563_().m_24960_((Entity)Minister.this, 500.0f, (float)abstractIllager.m_8132_());
            }
        }

        protected void m_8130_() {
            if (Minister.this.hasNearbyIllagers()) {
                for (AbstractIllager abstractIllager : Minister.this.getNearbyIllagers()) {
                    if (!abstractIllager.m_6084_() || abstractIllager.m_5448_() == Minister.this || !(abstractIllager.m_21233_() < Minister.this.m_21233_())) continue;
                    abstractIllager.m_7292_(new MobEffectInstance(MobEffects.f_19596_, MathHelper.secondsToTicks(30)));
                }
            }
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModSounds.MINISTER_SPEECH.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    class LaughTargetGoal
    extends CastingGoal {
        private LaughTargetGoal() {
            this.hasCastSound = false;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity livingentity = Minister.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                return !livingentity.m_21023_(MobEffects.f_19613_) && livingentity.m_7301_(new MobEffectInstance(MobEffects.f_19613_)) && livingentity.m_20270_((Entity)Minister.this) <= 16.0f && super.m_8036_();
            }
            return false;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Minister.this.f_19853_.m_7605_((Entity)Minister.this, (byte)7);
        }

        protected int m_8089_() {
            return 20;
        }

        protected int m_8067_() {
            return MathHelper.secondsToTicks(15);
        }

        protected void m_8130_() {
            LivingEntity livingentity = Minister.this.m_5448_();
            if (livingentity != null) {
                livingentity.m_147207_(new MobEffectInstance(MobEffects.f_19613_, MathHelper.secondsToTicks(30)), (Entity)Minister.this);
            }
        }

        @Nullable
        protected SoundEvent m_7030_() {
            return (SoundEvent)ModSounds.MINISTER_LAUGH.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    class CommandGoal
    extends CastingGoal {
        private CommandGoal() {
            this.hasCastSound = false;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && Minister.this.hasNearbyIllagers() && Minister.this.m_21188_() != null && Minister.this.m_5448_() == Minister.this.m_21188_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Minister.this.commandAnimationState.m_216977_(Minister.this.f_19797_);
            Minister.this.f_19853_.m_7605_((Entity)Minister.this, (byte)12);
        }

        protected int m_8089_() {
            return MathHelper.secondsToTicks(1);
        }

        protected int m_8067_() {
            return 100;
        }

        protected void m_8130_() {
            if (Minister.this.hasNearbyIllagers()) {
                for (AbstractIllager abstractIllager : Minister.this.getNearbyIllagers()) {
                    if (!(abstractIllager.m_21233_() < Minister.this.m_21233_()) || Minister.this.m_5448_() == null || abstractIllager.m_5448_() == Minister.this.m_5448_()) continue;
                    abstractIllager.m_6710_(Minister.this.m_5448_());
                }
            }
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModSounds.MINISTER_COMMAND.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class TeethSpellGoal
    extends CastingGoal {
        public int teethAmount;

        private TeethSpellGoal() {
            this.hasCastSound = true;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Minister.this.castAnimationState.m_216977_(Minister.this.f_19797_);
            Minister.this.f_19853_.m_7605_((Entity)Minister.this, (byte)5);
        }

        protected int m_8089_() {
            return 30;
        }

        protected int m_8067_() {
            if (Minister.this.hasNearbyIllagers()) {
                return 360;
            }
            return 120;
        }

        protected void m_8130_() {
            if (Minister.this.m_5448_() != null) {
                BlockPos blockPos = Minister.this.m_5448_().m_20183_();
                if (Minister.this.m_5448_().m_20270_((Entity)Minister.this) <= 4.0f) {
                    this.surroundTeeth();
                } else {
                    for (int length = 0; length < 16; ++length) {
                        blockPos = blockPos.m_7918_(-2 + Minister.this.m_217043_().m_188503_(4), 0, -2 + Minister.this.m_217043_().m_188503_(4));
                        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                        while ((double)blockpos$mutable.m_123342_() < (double)blockPos.m_123342_() + 8.0 && !Minister.this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                            blockpos$mutable.m_122173_(Direction.UP);
                        }
                        if (!Minister.this.f_19853_.m_45772_(new AABB((BlockPos)blockpos$mutable))) continue;
                        ++this.teethAmount;
                        ViciousTooth viciousTooth = new ViciousTooth((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), Minister.this.f_19853_);
                        viciousTooth.m_146884_(Vec3.m_82512_((Vec3i)blockpos$mutable));
                        viciousTooth.setOwner((LivingEntity)Minister.this);
                        if (!Minister.this.f_19853_.m_7967_((Entity)viciousTooth)) continue;
                        viciousTooth.m_216990_((SoundEvent)ModSounds.TOOTH_SPAWN.get());
                    }
                }
                if (this.teethAmount <= 0) {
                    this.surroundTeeth();
                }
            }
        }

        public void surroundTeeth() {
            if (Minister.this.m_5448_() != null) {
                ViciousTooth viciousTooth;
                BlockPos blockPos = Minister.this.m_20183_();
                BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                while ((double)blockpos$mutable.m_123342_() < (double)blockPos.m_123342_() + 8.0 && !Minister.this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                    blockpos$mutable.m_122173_(Direction.UP);
                }
                float f = (float)Mth.m_14136_((double)(Minister.this.m_5448_().m_20189_() - (double)blockPos.m_123343_()), (double)(Minister.this.m_5448_().m_20185_() - (double)blockPos.m_123341_()));
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    viciousTooth = new ViciousTooth((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), Minister.this.f_19853_);
                    viciousTooth.m_6034_((double)blockPos.m_123341_() + (double)Mth.m_14089_((float)f1) * 1.5, blockpos$mutable.m_123342_(), (double)blockPos.m_123343_() + (double)Mth.m_14089_((float)f1) * 1.5);
                    viciousTooth.setOwner((LivingEntity)Minister.this);
                    if (!Minister.this.f_19853_.m_7967_((Entity)viciousTooth)) continue;
                    viciousTooth.m_216990_((SoundEvent)ModSounds.TOOTH_SPAWN.get());
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    viciousTooth = new ViciousTooth((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_TOOTH.get()), Minister.this.f_19853_);
                    viciousTooth.m_6034_((double)blockPos.m_123341_() + (double)Mth.m_14089_((float)f2) * 2.5, blockpos$mutable.m_123342_(), (double)blockPos.m_123343_() + (double)Mth.m_14031_((float)f2) * 2.5);
                    viciousTooth.setOwner((LivingEntity)Minister.this);
                    if (!Minister.this.f_19853_.m_7967_((Entity)viciousTooth)) continue;
                    viciousTooth.m_216990_((SoundEvent)ModSounds.TOOTH_SPAWN.get());
                }
            }
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModSounds.MINISTER_CAST.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class MinisterRangedGoal
    extends Goal {
        private final Minister mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public MinisterRangedGoal(Minister p_25768_, double speed, int attackInterval, float attackRadius) {
            this(p_25768_, speed, attackInterval, attackInterval, attackRadius);
        }

        public MinisterRangedGoal(Minister mob, double speed, int attackMin, int attackMax, float attackRadius) {
            this.mob = mob;
            this.speedModifier = speed;
            this.attackIntervalMin = attackMin;
            this.attackIntervalMax = attackMax;
            this.attackRadius = attackRadius;
            this.attackRadiusSqr = attackRadius * attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target != null && this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null) {
                double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
                this.seeTime = flag ? ++this.seeTime : 0;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                    this.mob.m_21573_().m_26573_();
                } else {
                    this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                }
                this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                --this.attackTime;
                if (this.attackTime == 5) {
                    this.mob.attackAnimationState.m_216977_(Minister.this.f_19797_);
                    this.mob.f_19853_.m_7605_((Entity)Minister.this, (byte)4);
                } else if (this.attackTime == 0) {
                    if (!flag) {
                        return;
                    }
                    float f = (float)Math.sqrt(d0) / this.attackRadius;
                    float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    this.mob.m_6504_(this.target, f1);
                    this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
                } else if (this.attackTime < 0) {
                    this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
                }
            }
        }
    }

    abstract class CastingGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public boolean hasCastSound;

        CastingGoal() {
            super((SpellcasterIllager)Minister.this);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Minister.this.isCasting() && Minister.this.coolDown <= 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && (Minister.this.isCasting() || Minister.this.coolDown > 0);
        }

        public void m_8056_() {
            super.m_8056_();
            Minister.this.setCasting(true);
            Minister.this.coolDown = 20;
        }

        public void m_8041_() {
            super.m_8041_();
            Minister.this.setCasting(false);
            Minister.this.coolDown = 20;
        }

        public void m_8037_() {
            --this.f_33774_;
            if (this.f_33774_ == 0) {
                this.m_8130_();
                if (this.hasCastSound) {
                    Minister.this.m_5496_(Minister.this.m_7894_(), 1.0f, 1.0f);
                }
            }
        }
    }
}

