/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class AbstractVine
extends AbstractMonolith {
    public static final EntityDataAccessor<Boolean> PERPETUAL = SynchedEntityData.m_135353_(AbstractVine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int warmupDelayTicks;
    public int activeTick = 0;
    public boolean proximity = false;

    public AbstractVine(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PERPETUAL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_31485_) {
        super.m_7380_(p_31485_);
        p_31485_.m_128405_("ActiveTick", this.activeTick);
        p_31485_.m_128405_("Warmup", this.warmupDelayTicks);
        p_31485_.m_128379_("Proximity", this.proximity);
        p_31485_.m_128379_("Perpetual", this.isPerpetual());
    }

    @Override
    public void m_7378_(CompoundTag p_31474_) {
        super.m_7378_(p_31474_);
        if (p_31474_.m_128441_("ActiveTick")) {
            this.activeTick = p_31474_.m_128451_("ActiveTick");
        }
        if (p_31474_.m_128441_("Warmup")) {
            this.warmupDelayTicks = p_31474_.m_128451_("Warmup");
        }
        if (p_31474_.m_128441_("Proximity")) {
            this.proximity = p_31474_.m_128471_("Proximity");
        }
        if (p_31474_.m_128441_("Perpetual")) {
            this.setPerpetual(p_31474_.m_128471_("Perpetual"));
        }
    }

    public MobType m_6336_() {
        return ModMobType.NATURAL;
    }

    public boolean isPerpetual() {
        return (Boolean)this.f_19804_.m_135370_(PERPETUAL);
    }

    public void setPerpetual(boolean perpetual) {
        this.f_19804_.m_135381_(PERPETUAL, (Object)perpetual);
    }

    public void setWarmup(int warmupDelayTicks) {
        this.warmupDelayTicks = warmupDelayTicks;
    }

    public void setProximity(boolean proximity) {
        this.proximity = proximity;
    }

    public boolean m_20145_() {
        return super.m_20145_() || this.activeTick < 1;
    }

    @Override
    public boolean canHaveEffects() {
        return true;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.isEmerging() || this.m_20164_()) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    protected AABB getTargetSearchArea() {
        return this.m_20191_().m_82377_(4.0, 4.0, 4.0);
    }

    protected boolean hasTarget() {
        return !this.f_19853_.m_6443_(LivingEntity.class, this.getTargetSearchArea(), p_148152_ -> SummonTargetGoal.predicate((LivingEntity)this).test((LivingEntity)p_148152_)).isEmpty();
    }

    public void m_8032_() {
        if (this.activeTick > 0) {
            super.m_8032_();
        }
    }

    protected abstract SoundEvent getBurstSound();

    protected abstract SoundEvent getBurrowSound();

    public boolean isAquatic() {
        return false;
    }

    protected void handleAirSupply(int p_30344_) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(p_30344_ - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (this.isAquatic()) {
            this.handleAirSupply(i);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (this.isAquatic()) {
            return type != ForgeMod.WATER_TYPE.get();
        }
        return super.canDrownInFluidType(type);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Override
    public boolean m_5829_() {
        return this.activeTick > 0;
    }

    public boolean passableEntities(Entity collider) {
        LivingEntity livingEntity;
        return collider instanceof LivingEntity && CuriosFinder.hasWildRobe(livingEntity = (LivingEntity)collider) && MobUtil.areAllies((Entity)livingEntity, (Entity)this);
    }

    @Override
    public void m_8107_() {
        if (this.activeTick > 0) {
            super.m_8107_();
        }
        if (!this.f_19853_.f_46443_) {
            if (this.warmupDelayTicks > 0) {
                --this.warmupDelayTicks;
                if (!this.canSpawn(this.f_19853_)) {
                    this.m_146870_();
                }
            } else {
                boolean flag = this.proximity ? this.hasTarget() : true;
                if (flag) {
                    if (this.proximity) {
                        this.proximity = false;
                    }
                    ++this.activeTick;
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                    this.burst();
                }
            }
        }
        if (!this.isEmerging()) {
            LivingEntity livingEntity;
            if (!this.isActivate()) {
                this.setActivate(true);
            }
            if (!this.isPerpetual() && !this.f_19853_.f_46443_) {
                if (this.activeTick == MathHelper.secondsToTicks(this.getLifeSpan())) {
                    this.burrow();
                } else if (this.activeTick >= MathHelper.secondsToTicks(this.getLifeSpan())) {
                    this.setAge(this.getAge() - this.getAgeSpeed());
                    this.f_19853_.m_7605_((Entity)this, (byte)5);
                }
                if (this.getAge() <= 0) {
                    this.m_146870_();
                }
            }
            if (!(this.f_19853_.f_46443_ || this.m_6060_() || this.m_21224_() || this.limitedLifespan && this.limitedLifeTicks <= 20 || !(this.m_21223_() < this.m_21233_()) || !((livingEntity = this.getTrueOwner()) instanceof Player))) {
                Player owner = (Player)livingEntity;
                boolean curio = false;
                int soulCost = 0;
                int healRate = 0;
                float healAmount = 0.0f;
                if (((Boolean)MobsConfig.NaturalMinionHeal.get()).booleanValue()) {
                    curio = CuriosFinder.hasWildRobe((LivingEntity)owner);
                    soulCost = (Integer)MobsConfig.NaturalMinionHealCost.get();
                    healRate = (Integer)MobsConfig.NaturalMinionHealTime.get();
                    healAmount = ((Double)MobsConfig.NaturalMinionHealAmount.get()).floatValue();
                }
                if (curio && SEHelper.getSoulsAmount(owner, soulCost) && this.f_19797_ % (MathHelper.secondsToTicks(healRate) + 1) == 0) {
                    this.m_5634_(healAmount);
                    Vec3 vector3d = this.m_20184_();
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        SEHelper.decreaseSouls(owner, soulCost);
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, vector3d.f_82479_ * -0.2, 0.1, vector3d.f_82481_ * -0.2, 0.5);
                    }
                }
            }
        }
    }

    public void burst() {
        if (this.activeTick == 1) {
            this.diggingParticles();
        }
    }

    public void burrow() {
        this.diggingParticles();
    }

    public void diggingParticles() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
            BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_(blockPos));
            Vector3f vector3f = new Vector3f((Vector3fc)Vec3.m_82501_((int)13596079).m_252839_());
            if (this.isAquatic()) {
                vector3f = new Vector3f((Vector3fc)Vec3.m_82501_((int)8890069).m_252839_());
            }
            DustCloudParticleOption cloudParticleOptions = new DustCloudParticleOption(vector3f, 1.0f);
            for (int i = 0; i < 8; ++i) {
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1.0f);
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.14, 0.0, 1.0f);
            }
        }
    }

    @Override
    public void m_7822_(byte pId) {
        if (pId == 6) {
            ++this.activeTick;
        } else {
            super.m_7822_(pId);
        }
    }

    public ItemStack getSeed() {
        return ItemStack.f_41583_;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && item == Items.f_42499_) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(5.0f);
                    this.m_5496_(SoundEvents.f_184217_, this.m_6121_(), this.m_6100_() + 0.25f);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                } else {
                    this.m_5496_(SoundEvents.f_144074_, this.m_6121_(), this.m_6100_());
                    Level i = this.f_19853_;
                    if (i instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)i;
                        for (int i2 = 0; i2 < 7; ++i2) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    if (this.f_19853_.f_46441_.m_188501_() <= 0.45f && !this.getSeed().m_41619_()) {
                        ItemHelper.addItemEntity(this.f_19853_, this.m_20183_().m_7494_(), this.getSeed());
                    }
                }
                pPlayer.m_6674_(p_230254_2_);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, p_230254_2_);
    }
}

