/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.AbstractWave;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TidalSurge
extends AbstractWave {
    public TidalSurge(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public TidalSurge(Level level, LivingEntity shooter) {
        this((EntityType)ModEntityType.TIDAL_SURGE.get(), level);
        this.setOwner(shooter);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.m_5496_(SoundEvents.f_11918_, 0.15f, 1.0f);
        }
        if (this.f_19853_.f_46443_) {
            int h = 0;
            while ((float)h < this.getWaveScale()) {
                for (int i = 0; i <= 8; ++i) {
                    float xOffset = (float)i / 4.0f - 0.5f + (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                    this.spawnCloudParticleAt((0.2f + this.f_19796_.m_188501_() * 0.2f) * this.getWaveScale(), 1.2f, xOffset * 1.2f * this.getWaveScale());
                    this.spawnParticleAt((0.2f + this.f_19796_.m_188501_() * 0.2f) * this.getWaveScale(), -0.2f, xOffset * 1.4f * this.getWaveScale(), (ParticleOptions)ParticleTypes.f_123769_);
                }
                ++h;
            }
        }
    }

    public void spawnCloudParticleAt(float yOffset, float zOffset, float xOffset) {
        Vec3 vec3 = new Vec3((double)xOffset, (double)yOffset, (double)zOffset).m_82524_((float)Math.toRadians(-this.m_146908_()));
        this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SPELL_CLOUD.get(), this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_, 1.0, 1.0, 1.0);
    }

    @Override
    public void attackEntities(float scale) {
        DamageSource source = ModDamageSource.indirectDrench(this, (Entity)this.m_269323_());
        for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_((double)(0.5f * scale), 0.5, (double)(0.5f * scale)))) {
            if (MobUtil.areAllies((Entity)entity, (Entity)(this.m_269323_() != null ? this.m_269323_() : this))) continue;
            float damage = scale + ((Double)SpellConfig.TidalBaseDamage.get()).floatValue();
            if (entity.m_6126_()) {
                damage += 1.0f;
            }
            entity.m_6469_(source, damage *= (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue());
            this.setSlamming(true);
            entity.m_147240_(0.1 + 0.5 * (double)scale, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
        }
    }
}

