/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.equipment;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.ModTiers;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DarkScytheItem
extends TieredItem
implements Vanishable {
    private static float initialDamage = ((Double)ItemConfig.ScytheBaseDamage.get()).floatValue();
    private final Multimap<Attribute, AttributeModifier> scytheAttributes;

    public DarkScytheItem(Tier itemTier) {
        super(itemTier, new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41503_(itemTier.m_6609_()));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        initialDamage = ((Double)ItemConfig.ScytheBaseDamage.get()).floatValue() + itemTier.m_6631_();
        double attackSpeed = 4.0 - (Double)ItemConfig.ScytheAttackSpeed.get();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)initialDamage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -attackSpeed, AttributeModifier.Operation.ADDITION));
        this.scytheAttributes = builder.build();
    }

    public DarkScytheItem() {
        this(ModTiers.SPECIAL);
    }

    public static float getInitialDamage() {
        return initialDamage;
    }

    public boolean getMineBlocks(Level pLevel, BlockState pState, BlockPos pPos) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) <= -1.0f) {
            return false;
        }
        return pState.m_204336_(BlockTags.f_144281_) || BlockFinder.isScytheBreak(pState);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return pState.m_204336_(BlockTags.f_144281_) ? 8.0f : 1.0f;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
        if (pAttacker instanceof Player) {
            Player player = (Player)pAttacker;
            this.attackMobs(pStack, pTarget, player);
        }
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(this.getMineBlocks(pLevel, pState, pPos) ? 1 : 2, pEntityLiving, p_220044_0_ -> p_220044_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (this.getMineBlocks(pLevel, pState, pPos)) {
            pLevel.m_6263_((Player)null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.SCYTHE_HIT.get(), pEntityLiving.m_5720_(), 1.0f, 1.0f);
            for (BlockPos blockPos : BlockFinder.multiBlockBreak(pEntityLiving, pPos, 2, 2, 2)) {
                BlockState blockstate = pLevel.m_8055_(blockPos);
                if (!this.getMineBlocks(pLevel, blockstate, blockPos) || !BlockFinder.breakBlock(pLevel, blockPos, pStack, (Entity)pEntityLiving) || blockstate.m_60800_((BlockGetter)pLevel, blockPos) == 0.0f) continue;
                pStack.m_41622_(1, pEntityLiving, p_220044_0_ -> p_220044_0_.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return true;
    }

    public void attackMobs(ItemStack pStack, LivingEntity pTarget, Player pPlayer) {
        int enchantment = pStack.getEnchantmentLevel((Enchantment)ModEnchantments.SOUL_EATER.get());
        int soulEater = Mth.m_14045_((int)(enchantment + 1), (int)1, (int)10);
        SEHelper.increaseSouls(pPlayer, (Integer)ItemConfig.DarkScytheSouls.get() * soulEater);
        float f = (float)pPlayer.m_21133_(Attributes.f_22281_);
        float f1 = EnchantmentHelper.m_44833_((ItemStack)pPlayer.m_21205_(), (MobType)pTarget.m_6336_());
        float f2 = pPlayer.m_36403_(0.5f);
        f *= 0.2f + f2 * f2 * 0.8f;
        if ((f += (f1 *= f2)) > 0.5f || f1 > 0.5f) {
            float f3 = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)pPlayer) * f;
            int j = EnchantmentHelper.m_44914_((LivingEntity)pPlayer);
            double area = 1.0;
            if (f2 > 0.9f) {
                area = 2.0;
            }
            for (LivingEntity livingentity : pPlayer.f_19853_.m_45976_(LivingEntity.class, pTarget.m_20191_().m_82377_(area, 0.25, area))) {
                if (livingentity == pPlayer || livingentity == pTarget || pPlayer.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(pPlayer.m_20280_((Entity)livingentity) < 16.0) || livingentity == pPlayer.m_20202_()) continue;
                livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(pPlayer.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(pPlayer.m_146908_() * ((float)Math.PI / 180)))));
                if (!livingentity.m_6469_(livingentity.m_269291_().m_269075_(pPlayer), f3)) continue;
                if (j > 0) {
                    livingentity.m_20254_(j * 4);
                }
                pStack.m_41622_(1, (LivingEntity)pPlayer, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
                if (livingentity instanceof IOwned) {
                    if (((IOwned)livingentity).getTrueOwner() != pPlayer) {
                        SEHelper.increaseSouls(pPlayer, (Integer)ItemConfig.DarkScytheSouls.get() * soulEater);
                    }
                } else {
                    SEHelper.increaseSouls(pPlayer, (Integer)ItemConfig.DarkScytheSouls.get() * soulEater);
                }
                EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)pPlayer);
                EnchantmentHelper.m_44896_((LivingEntity)pPlayer, (Entity)livingentity);
            }
        }
        pPlayer.f_19853_.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.SCYTHE_SWING.get(), pPlayer.m_5720_(), 1.0f, 1.0f);
        pPlayer.m_36346_();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && slotChanged;
    }

    public boolean m_8096_(BlockState pBlock) {
        return pBlock.m_204336_(BlockTags.f_144281_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEAPON || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE || enchantment.f_44672_ == EnchantmentCategory.DIGGER || enchantment.m_44704_().contains("vanillatweaks:siphon") || enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44987_;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.scytheAttributes : super.m_7167_(equipmentSlot);
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_41720_() == ModItems.PALE_STEEL_INGOT.get() || super.m_6832_(pToRepair, pRepair);
    }
}

