/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.SteamMissile;
import com.Polarice3.Goety.common.magic.ChargingSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SteamSpell
extends ChargingSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SteamingCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.SteamingDuration.get();
    }

    @Override
    public int Cooldown() {
        return 2;
    }

    @Override
    public int Cooldown(LivingEntity caster, ItemStack staff, int shots) {
        if (shots % 5 == 0) {
            return 8;
        }
        return super.Cooldown(caster, staff, shots);
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SteamingCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.CAST_STEAM.get();
    }

    @Override
    public float castingVolume() {
        return 1.0f;
    }

    @Override
    public int shotsNumber(LivingEntity caster, ItemStack staff) {
        if (this.rightStaff(staff)) {
            return 20;
        }
        return 5;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster);
        }
        Vec3 vector3d = caster.m_20252_(1.0f);
        double accuracy = 8.0;
        Vec3 vec3 = new Vec3(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_).m_82541_().m_82520_(worldIn.f_46441_.m_216328_(0.0, 0.0172275 * accuracy), 0.0, worldIn.f_46441_.m_216328_(0.0, 0.0172275 * accuracy));
        SteamMissile steamMissile = new SteamMissile(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (Level)worldIn);
        steamMissile.setExtraDamage(potency);
        steamMissile.setBoltSpeed((int)velocity);
        steamMissile.m_5602_((Entity)caster);
        worldIn.m_7967_((Entity)steamMissile);
    }
}

