/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.HellBlast;
import com.Polarice3.Goety.common.entities.projectiles.Lavaball;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LavaballSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.LavaballCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.LavaballDuration.get();
    }

    @Override
    public SoundEvent CastingSound(LivingEntity caster) {
        if (CuriosFinder.hasUnholySet(caster)) {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SPELL.get();
        }
        return SoundEvents.f_11867_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.LavaballCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public ColorUtil particleColors(LivingEntity caster) {
        return new ColorUtil(1.0f, 0.0f, 0.0f);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int burning = spellStat.getBurning();
        float radius = (float)spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
            radius += (float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0f;
        }
        Vec3 vector3d = caster.m_20252_(1.0f);
        Object fireballEntity = new Lavaball((Level)worldIn, caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
        if (CuriosFinder.hasUnholySet(caster)) {
            fireballEntity = new HellBlast(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
        }
        fireballEntity.m_5602_((Entity)caster);
        if (fireballEntity instanceof Lavaball) {
            Lavaball lavaball = fireballEntity;
            if (this.rightStaff(staff)) {
                lavaball.setUpgraded(true);
            }
            if (this.isShifting(caster)) {
                lavaball.setDangerous(false);
            }
            lavaball.setExtraDamage(potency);
            lavaball.setFiery(burning);
            lavaball.setExplosionPower(lavaball.getExplosionPower() + radius);
        } else if (fireballEntity instanceof HellBlast) {
            HellBlast hellBlast = (HellBlast)((Object)fireballEntity);
            hellBlast.setExtraDamage(potency);
            hellBlast.setRadius(hellBlast.getRadius() + radius);
            hellBlast.setFiery(burning);
        }
        worldIn.m_7967_((Entity)fireballEntity);
        if (this.rightStaff(staff)) {
            for (int i = 0; i < 2; ++i) {
                Object fireballEntity1 = new Lavaball((Level)worldIn, caster.m_20185_() + vector3d.f_82479_ / 2.0 + worldIn.f_46441_.m_188583_(), caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0 + worldIn.f_46441_.m_188583_(), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
                if (CuriosFinder.hasUnholySet(caster)) {
                    fireballEntity1 = new HellBlast(caster.m_20185_() + vector3d.f_82479_ / 2.0 + worldIn.f_46441_.m_188583_(), caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0 + worldIn.f_46441_.m_188583_(), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, (Level)worldIn);
                }
                fireballEntity1.m_5602_((Entity)caster);
                if (fireballEntity1 instanceof Lavaball) {
                    Lavaball lavaball = fireballEntity1;
                    lavaball.setUpgraded(true);
                    if (this.isShifting(caster)) {
                        lavaball.setDangerous(false);
                    }
                    lavaball.setExtraDamage(potency);
                    lavaball.setFiery(burning);
                    lavaball.setExplosionPower(lavaball.getExplosionPower() + radius);
                } else if (fireballEntity1 instanceof HellBlast) {
                    HellBlast hellBlast = (HellBlast)((Object)fireballEntity1);
                    hellBlast.setExtraDamage(potency);
                    hellBlast.setRadius(hellBlast.getRadius() + radius);
                    hellBlast.setFiery(burning);
                }
                worldIn.m_7967_((Entity)fireballEntity1);
            }
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11923_, 2.0f, this.projPitch(worldIn.m_213780_()));
    }
}

