/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SThunderBoltPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class ThunderboltSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ThunderboltCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.ThunderboltDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ZAP.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ThunderboltCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        float damage = ((Double)SpellConfig.ThunderboltDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        damage += (float)spellStat.getPotency();
        Vec3 vec3 = caster.m_146892_();
        BlockHitResult rayTraceResult = this.blockResult((Level)worldIn, caster, range);
        Entity target = MobUtil.getNearbyTarget((Level)worldIn, caster, range, 1.0);
        Optional<BlockPos> lightningRod = BlockFinder.findLightningRod(worldIn, BlockPos.m_274446_((Position)rayTraceResult.m_82450_()), range);
        if (lightningRod.isPresent() && !this.rightStaff(staff)) {
            BlockPos blockPos = lightningRod.get();
            ModNetwork.sendToALL(new SThunderBoltPacket(vec3, new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), 10));
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.THUNDERBOLT.get());
        } else {
            LivingEntity livingEntity = MobUtil.getLivingTarget(target);
            if (livingEntity != null && ForgeHooks.onLivingAttack((LivingEntity)livingEntity, (DamageSource)ModDamageSource.directShock(caster), (float)damage)) {
                Vec3 vec31 = new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_());
                ModNetwork.sendToALL(new SThunderBoltPacket(vec3, vec31, 10));
                if (livingEntity.m_6469_(ModDamageSource.directShock(caster), damage)) {
                    float chance = this.rightStaff(staff) ? 0.25f : 0.05f;
                    float chainDamage = damage / 2.0f;
                    if (worldIn.m_46470_() && worldIn.m_46758_(livingEntity.m_20183_())) {
                        chance += 0.25f;
                        chainDamage = damage;
                    }
                    if (worldIn.f_46441_.m_188501_() <= chance) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SPASMS.get(), MathHelper.secondsToTicks(5)));
                    }
                    if (this.rightStaff(staff)) {
                        WandUtil.chainLightning(livingEntity, caster, (double)range / 4.0, chainDamage);
                    }
                }
                this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.THUNDERBOLT.get());
            } else {
                BlockPos blockPos = rayTraceResult.m_82425_();
                ModNetwork.sendToALL(new SThunderBoltPacket(vec3, new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), 10));
                this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.THUNDERBOLT.get());
            }
        }
    }
}

