/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EndWalkSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.EndWalkCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.EndWalkDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.EndWalkCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration = MathHelper.secondsToTicks(5) * WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        if (caster instanceof Player) {
            Player player = (Player)caster;
            player.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SHADOW_WALK.get(), (Integer)SpellConfig.EndWalkEffectDuration.get() + duration, potency, false, false, true));
            for (int i = 0; i < 16; ++i) {
                double d0 = MathHelper.rgbToSpeed(96.0);
                double d1 = MathHelper.rgbToSpeed(62.0);
                double d2 = MathHelper.rgbToSpeed(92.0);
                worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.CULT_SPELL.get()), caster.m_20208_(1.0), caster.m_20187_(), caster.m_20262_(1.0), 0, d0, d1, d2, 0.5);
            }
            SEHelper.setEndWalk(player, player.m_20183_(), (ResourceKey<Level>)player.f_19853_.m_46472_());
            ModNetwork.sendTo(player, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.END_WALK.get(), 1.0f, 1.0f));
        }
    }
}

