/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.ritual;

import com.Polarice3.Goety.api.ritual.IRitualType;
import com.Polarice3.Goety.api.ritual.RitualType;
import com.Polarice3.Goety.common.blocks.entities.DarkAltarBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.PedestalBlockEntity;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.ritual.EnchantItemRitual;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class Ritual {
    public static final int RANGE = (Integer)MainConfig.RitualRange.get();
    public static final int PEDESTAL_RANGE = (Integer)MainConfig.RitualRange.get();
    public static final int SACRIFICE_DETECTION_RANGE = (Integer)MainConfig.RitualRange.get();
    public RitualRecipe recipe;
    public ResourceLocation factoryId;

    public Ritual(RitualRecipe recipe) {
        this.recipe = recipe;
    }

    public static List<Ingredient> getRemainingAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> consumedIngredients) {
        ArrayList<ItemStack> consumedIngredientsCopy = new ArrayList<ItemStack>(consumedIngredients);
        ArrayList<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
        for (Ingredient ingredient : additionalIngredients) {
            Optional<ItemStack> matchedStack = consumedIngredientsCopy.stream().filter(arg_0 -> ((Ingredient)ingredient).test(arg_0)).findFirst();
            if (matchedStack.isPresent()) {
                consumedIngredientsCopy.remove(matchedStack.get());
                continue;
            }
            remainingAdditionalIngredients.add(ingredient);
        }
        return remainingAdditionalIngredients;
    }

    public ResourceLocation getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryId(ResourceLocation factoryId) {
        this.factoryId = factoryId;
    }

    public RitualRecipe getRecipe() {
        return this.recipe;
    }

    public boolean isValid(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(world, darkAltarPos, castingPlayer, remainingAdditionalIngredients);
    }

    public void start(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem) {
        world.m_5594_(null, darkAltarPos, (SoundEvent)ModSounds.ALTAR_START.get(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
    }

    public void finish(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem) {
        for (IRitualType ritualType : RitualType.getAllRitualType()) {
            if (!tileEntity.getCurrentRitualRecipe().getCraftType().contains(ritualType.getName())) continue;
            ritualType.onFinishRitual(world, darkAltarPos, tileEntity, castingPlayer, activationItem);
        }
        if (tileEntity.getCurrentRitualRecipe().getRitual() instanceof EnchantItemRitual) {
            world.m_5594_(null, darkAltarPos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
        }
        world.m_5594_(null, darkAltarPos, (SoundEvent)ModSounds.ALTAR_FINISH.get(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
    }

    public void interrupt(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem) {
        world.m_5594_(null, darkAltarPos, (SoundEvent)ModSounds.SPELL_FAIL.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
    }

    public void update(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients, int time, int totalTime) {
        if (tileEntity.getConvertEntity != null) {
            MiscCapHelper.setShakeTime((LivingEntity)tileEntity.getConvertEntity, 20);
            if (tileEntity.getConvertEntity.f_19797_ % 20 == 0 && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123809_, (Entity)tileEntity.getConvertEntity);
            }
        }
        int progress = totalTime - time;
        if (world.m_46467_() % (long)MathHelper.secondsToTicks(4) == 0L && MathHelper.secondsToTicks(4) > progress) {
            world.m_5594_(null, darkAltarPos, (SoundEvent)ModSounds.ALTAR_LOOP.get(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
        }
        List<PedestalBlockEntity> pedestals = this.getPedestals(world, darkAltarPos);
        for (PedestalBlockEntity pedestal : pedestals) {
            pedestal.itemStackHandler.map(handler -> {
                ItemStack stack = handler.extractItem(0, 1, true);
                if (!stack.m_41619_()) {
                    this.addItemParticles((ServerLevel)world, pedestal.m_58899_(), darkAltarPos, stack);
                }
                return true;
            });
        }
    }

    public void update(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem, int time, int totalTime) {
        this.update(world, darkAltarPos, tileEntity, castingPlayer, activationItem, new ArrayList<Ingredient>(), time, totalTime);
    }

    public boolean identify(Level world, BlockPos darkAltarPos, Player player, ItemStack activationItem) {
        return this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(world, darkAltarPos, player, (List<Ingredient>)this.recipe.m_7527_());
    }

    public boolean consumeAdditionalIngredients(Level world, BlockPos darkAltarPos, Player player, List<Ingredient> remainingAdditionalIngredients, int time, List<ItemStack> consumedIngredients) {
        int ingredientsConsumed;
        if (remainingAdditionalIngredients.isEmpty()) {
            return true;
        }
        int totalIngredientsToConsume = (int)Math.floor((float)time / this.recipe.getDurationPerIngredient());
        int ingredientsToConsume = totalIngredientsToConsume - (ingredientsConsumed = consumedIngredients.size());
        if (ingredientsToConsume == 0) {
            return true;
        }
        List<PedestalBlockEntity> pedestals = this.getPedestals(world, darkAltarPos);
        Iterator<Ingredient> it = remainingAdditionalIngredients.iterator();
        for (int consumed = 0; it.hasNext() && consumed < ingredientsToConsume; ++consumed) {
            Ingredient ingredient = it.next();
            if (!this.consumeAdditionalIngredient(world, darkAltarPos, pedestals, ingredient, consumedIngredients)) {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.cannotConsume.fail"), true);
                return false;
            }
            it.remove();
        }
        return true;
    }

    public boolean consumeAdditionalIngredient(Level world, BlockPos darkAltarPos, List<PedestalBlockEntity> pedestals, Ingredient ingredient, List<ItemStack> consumedIngredients) {
        for (PedestalBlockEntity pedestal : pedestals) {
            if (!pedestal.itemStackHandler.map(handler -> {
                ItemStack stack = handler.extractItem(0, 1, true);
                if (ingredient.test(stack)) {
                    BucketItem bucketItem;
                    ItemStack extracted = handler.extractItem(0, 1, false);
                    consumedIngredients.add(extracted);
                    Item patt9269$temp = extracted.m_41720_();
                    if (patt9269$temp instanceof BucketItem && !(bucketItem = (BucketItem)patt9269$temp).getFluid().m_76145_().m_76178_()) {
                        ItemHelper.addItemEntity(world, pedestal.m_58899_().m_7494_(), new ItemStack((ItemLike)Items.f_42446_));
                        world.m_5594_(null, pedestal.m_58899_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 0.7f, 0.7f);
                    } else if (extracted.hasCraftingRemainingItem()) {
                        ItemHelper.addItemEntity(world, pedestal.m_58899_().m_7494_(), extracted.getCraftingRemainingItem());
                    }
                    handler.setStackInSlot(0, ItemStack.f_41583_);
                    world.m_5594_(null, pedestal.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.7f);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void addItemParticles(ServerLevel world, BlockPos pedestalPos, BlockPos darkAltarPos, ItemStack stack) {
        double d0 = 0.1 * (double)(darkAltarPos.m_123341_() - pedestalPos.m_123341_());
        double d1 = 0.3;
        double d2 = 0.1 * (double)(darkAltarPos.m_123343_() - pedestalPos.m_123343_());
        world.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)pedestalPos.m_123341_() + 0.5, (double)pedestalPos.m_123342_() + 1.5, (double)pedestalPos.m_123343_() + 0.5, 0, d0, d1, d2, 1.0);
    }

    public boolean areAdditionalIngredientsFulfilled(Level world, BlockPos darkAltarPos, Player player, List<Ingredient> additionalIngredients) {
        return this.matchesAdditionalIngredients(player, additionalIngredients, this.getItemsOnPedestals(world, darkAltarPos));
    }

    public boolean matchesAdditionalIngredients(Player player, List<Ingredient> additionalIngredients, List<ItemStack> items) {
        if (additionalIngredients.size() != items.size()) {
            return false;
        }
        if (additionalIngredients.isEmpty()) {
            return true;
        }
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>(items);
        for (Ingredient ingredient : additionalIngredients) {
            boolean isMatched = false;
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack stack = (ItemStack)remainingItems.get(i);
                if (!ingredient.test(stack)) continue;
                isMatched = true;
                remainingItems.remove(i);
                break;
            }
            if (isMatched) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getItemsOnPedestals(Level world, BlockPos darkAltarPos, List<Ingredient> additionalIngredients) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<PedestalBlockEntity> pedestals = this.getPedestals(world, darkAltarPos);
        for (PedestalBlockEntity pedestalTile : pedestals) {
            pedestalTile.itemStackHandler.ifPresent(handler -> {
                ItemStack stack = handler.getStackInSlot(0);
                for (Ingredient ingredient : additionalIngredients) {
                    if (!ingredient.test(stack) || result.contains(stack)) continue;
                    result.add(stack);
                }
            });
        }
        return result;
    }

    public List<ItemStack> getItemsOnPedestals(Level world, BlockPos darkAltarPos) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<PedestalBlockEntity> pedestals = this.getPedestals(world, darkAltarPos);
        for (PedestalBlockEntity pedestalTile : pedestals) {
            pedestalTile.itemStackHandler.ifPresent(handler -> {
                ItemStack stack = handler.getStackInSlot(0);
                if (!stack.m_41619_()) {
                    result.add(stack);
                }
            });
        }
        return result;
    }

    public List<PedestalBlockEntity> getPedestals(Level world, BlockPos darkAltarPos) {
        ArrayList<PedestalBlockEntity> result = new ArrayList<PedestalBlockEntity>();
        Iterable blocksToCheck = BlockPos.m_121940_((BlockPos)darkAltarPos.m_7918_(-PEDESTAL_RANGE, -PEDESTAL_RANGE, -PEDESTAL_RANGE), (BlockPos)darkAltarPos.m_7918_(PEDESTAL_RANGE, PEDESTAL_RANGE, PEDESTAL_RANGE));
        for (BlockPos blockToCheck : blocksToCheck) {
            BlockEntity tileEntity = world.m_7702_(blockToCheck);
            if (!(tileEntity instanceof PedestalBlockEntity) || tileEntity instanceof DarkAltarBlockEntity) continue;
            result.add((PedestalBlockEntity)tileEntity);
        }
        return result;
    }

    public void prepareLivingEntityForSpawn(LivingEntity livingEntity, Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, boolean setTamed) {
        if (setTamed) {
            MobUtil.summonTame((Entity)livingEntity, castingPlayer);
        }
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.m_19890_((double)((float)darkAltarPos.m_123341_() + 0.5f), (double)((float)darkAltarPos.m_123342_() + 1.0f), (double)((float)darkAltarPos.m_123343_() + 0.5f), (float)world.f_46441_.m_188503_(360), 0.0f);
            mob.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(darkAltarPos), MobSpawnType.MOB_SUMMONED, null, null);
        } else {
            livingEntity.m_6034_((double)((float)darkAltarPos.m_123341_() + 0.5f), (double)(darkAltarPos.m_123342_() + 1), (double)((float)darkAltarPos.m_123343_() + 0.5f));
        }
    }

    public boolean isValidSacrifice(LivingEntity entity) {
        return entity != null && this.recipe.requiresSacrifice() && entity.m_6095_().m_204039_(this.recipe.getEntityToSacrifice());
    }

    public boolean requiresSacrifice() {
        return this.recipe.requiresSacrifice();
    }

    public void dropResult(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)darkAltarPos.m_123341_(), (double)((float)darkAltarPos.m_123342_() + 1.0f), (double)darkAltarPos.m_123343_(), stack);
        entity.m_32010_(10);
        world.m_7967_((Entity)entity);
    }
}

