/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.jei;

import com.Polarice3.Goety.common.crafting.BrewingRecipe;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.effects.brew.BrewEffects;
import com.Polarice3.Goety.common.effects.brew.PotionBrewEffect;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.compat.jei.WitchBrewJeiRecipe;
import com.Polarice3.Goety.utils.BrewUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class WitchBrewMaker {
    private WitchBrewMaker() {
    }

    public static List<WitchBrewJeiRecipe> getRecipes(RecipeManager recipeManager, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return WitchBrewMaker.getBrewRecipes(recipeManager, vanillaRecipeFactory, ingredientManager);
    }

    private static List<WitchBrewJeiRecipe> getBrewRecipes(RecipeManager recipeManager, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ArrayList<WitchBrewJeiRecipe> recipes = new ArrayList<WitchBrewJeiRecipe>();
        for (ItemStack itemStack : ingredientManager.getAllItemStacks()) {
            BrewEffect brewEffect;
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            ArrayList<BrewEffectInstance> blockEffects = new ArrayList<BrewEffectInstance>();
            BrewingRecipe brewingRecipe = recipeManager.m_44013_((RecipeType)ModRecipeSerializer.BREWING_TYPE.get()).stream().filter(recipe -> recipe.input.test(itemStack)).findFirst().orElse(null);
            ItemStack brew = new ItemStack((ItemLike)ModItems.BREW.get());
            int capacity = 0;
            int soulCost = 0;
            if (brewingRecipe != null) {
                effects.add(new MobEffectInstance(brewingRecipe.output, brewingRecipe.duration));
                capacity = brewingRecipe.getCapacityExtra();
                soulCost = brewingRecipe.getSoulCost();
            } else if (BrewEffects.INSTANCE.getEffectFromCatalyst(itemStack.m_41720_()) != null && (brewEffect = BrewEffects.INSTANCE.getEffectFromCatalyst(itemStack.m_41720_())) != null) {
                if (brewEffect instanceof PotionBrewEffect) {
                    PotionBrewEffect potionBrewEffect = (PotionBrewEffect)brewEffect;
                    effects.add(new MobEffectInstance(potionBrewEffect.mobEffect, potionBrewEffect.duration));
                } else {
                    blockEffects.add(new BrewEffectInstance(brewEffect, 1));
                }
                capacity = brewEffect.getCapacityExtra();
                soulCost = brewEffect.getSoulCost();
            }
            if (effects.isEmpty() && blockEffects.isEmpty()) continue;
            BrewUtils.setCustomEffects(brew, effects, blockEffects);
            brew.m_41784_().m_128405_("CustomPotionColor", BrewUtils.getColor(effects, blockEffects));
            WitchBrewJeiRecipe recipe2 = new WitchBrewJeiRecipe(itemStack, brew, capacity, soulCost);
            if (recipes.contains(recipe2)) continue;
            recipes.add(recipe2);
        }
        return recipes;
    }
}

