/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.items.magic;

import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.api.magic.IBlockSpell;
import com.Polarice3.Goety.api.magic.ISpell;
import com.Polarice3.Goety.api.magic.ITouchSpell;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.items.capability.SoulUsingItemCapability;
import com.Polarice3.Goety.common.items.handler.SoulUsingItemHandler;
import com.Polarice3.Goety.utils.SEHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public interface IWand
extends IForgeItem {
    public static final String SOULUSE = "Soul Use";
    public static final String CASTTIME = "Cast Time";
    public static final String SOULCOST = "Soul Cost";
    public static final String DURATION = "Duration";
    public static final String COOLDOWN = "Cooldown";
    public static final String COOL = "Cool";
    public static final String SECONDS = "Seconds";
    public static final String SHOTS = "Shots";

    public SpellType getSpellType();

    public static ItemStack getFocus(ItemStack itemstack) {
        SoulUsingItemHandler handler = SoulUsingItemHandler.get(itemstack);
        return handler.getSlot();
    }

    public static IFocus getMagicFocus(ItemStack itemStack) {
        Item item;
        if (IWand.getFocus(itemStack) != null && !IWand.getFocus(itemStack).m_41619_() && (item = IWand.getFocus(itemStack).m_41720_()) instanceof IFocus) {
            IFocus magicFocus = (IFocus)item;
            return magicFocus;
        }
        return null;
    }

    default public ISpell getSpell(ItemStack stack) {
        IFocus focus = IWand.getMagicFocus(stack);
        if (focus != null && focus.getSpell() != null) {
            return focus.getSpell();
        }
        return null;
    }

    default public int SoulUse(LivingEntity entityLiving, ItemStack stack) {
        return 0;
    }

    default public boolean cannotCast(LivingEntity livingEntity, ItemStack stack) {
        return this.cannotCast(livingEntity, stack, this.getSpell(stack));
    }

    default public boolean cannotCast(LivingEntity livingEntity, ItemStack stack, ISpell spell) {
        boolean flag = false;
        Level level = livingEntity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (spell != null && !spell.conditionsMet(serverLevel, livingEntity)) {
                flag = true;
            }
        }
        return this.isOnCooldown(livingEntity, stack) || flag;
    }

    default public boolean isOnCooldown(LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (IWand.getFocus(stack) != null) {
                Item item = IWand.getFocus(stack).m_41720_();
                return SEHelper.getFocusCoolDown(player).isOnCooldown(item);
            }
        }
        return false;
    }

    @Deprecated
    default public boolean isNotInstant(ISpell spells) {
        return this.isNotInstant(spells, null, ItemStack.f_41583_);
    }

    default public boolean isNotInstant(ISpell spells, @Nullable LivingEntity caster, ItemStack staff) {
        return spells != null && (caster != null ? spells.castDuration(caster, staff) > 0 : spells.defaultCastDuration() > 0);
    }

    default public boolean notTouch(ISpell spells) {
        return !(spells instanceof ITouchSpell) && !(spells instanceof IBlockSpell);
    }

    default public void useParticles(Level worldIn, LivingEntity livingEntity, ItemStack stack, ISpell iSpell) {
        if (iSpell != null) {
            iSpell.useParticle(worldIn, livingEntity, stack);
        }
    }

    default public int currentCastTime(LivingEntity livingEntity, ItemStack itemstack) {
        if (livingEntity.m_6117_() && livingEntity.m_21211_() == itemstack) {
            return livingEntity.m_21252_();
        }
        return 0;
    }

    default public int ShotsFired(ItemStack itemStack) {
        return 0;
    }

    default public void failParticles(Level worldIn, LivingEntity entityLiving) {
        for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            double d = worldIn.f_46441_.m_188583_() * 0.2;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123796_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), d, d, d);
        }
    }

    public static IItemHandler getItemHandler(ItemStack itemStack) {
        return (IItemHandler)itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalArgumentException("Expected an item handler for the Magic Focus item, but " + itemStack + " does not expose an item handler."));
    }

    default public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt;
        IItemHandler iitemHandler = IWand.getItemHandler(stack);
        CompoundTag compoundTag = nbt = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
        if (iitemHandler instanceof ItemStackHandler) {
            ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
            nbt.m_128365_("cap", (Tag)itemHandler.serializeNBT());
        }
        return nbt;
    }

    default public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            stack.m_41751_(null);
        } else {
            IItemHandler iitemHandler = IWand.getItemHandler(stack);
            if (iitemHandler instanceof ItemStackHandler) {
                ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
                itemHandler.deserializeNBT(nbt.m_128469_("cap"));
            }
            stack.m_41751_(nbt);
        }
    }

    @Nullable
    default public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new SoulUsingItemCapability(stack);
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack) && slotChanged;
    }
}

