/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.block;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.BrewCauldronBlockEntity;
import com.Polarice3.Goety.common.blocks.properties.ModStateProperties;
import com.Polarice3.Goety.utils.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class BrewCauldronRenderer
implements BlockEntityRenderer<BrewCauldronBlockEntity> {
    public static final ResourceLocation WATER = new ResourceLocation("block/water_still");
    private static final float[] HEIGHT = new float[]{0.0f, 0.25f, 0.4375f, 0.625f};

    public BrewCauldronRenderer(BlockEntityRendererProvider.Context p_i226007_1_) {
    }

    public void render(BrewCauldronBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world != null) {
            BlockPos pos = entity.m_58899_();
            int level = (Integer)entity.m_58900_().m_61143_((Property)ModStateProperties.LEVEL_BREW);
            if (level > 0 && entity.isHeated() && !Minecraft.m_91087_().m_91104_()) {
                float fluidHeight = 0.0f;
                float width = 0.35f;
                switch ((Integer)entity.m_58900_().m_61143_((Property)ModStateProperties.LEVEL_BREW)) {
                    case 1: {
                        fluidHeight = 0.225f;
                        break;
                    }
                    case 2: {
                        fluidHeight = 0.425f;
                        width = 0.3f;
                        break;
                    }
                    case 3: {
                        fluidHeight = 0.625f;
                    }
                }
                if (fluidHeight > 0.0f) {
                    double[] rgb = MathHelper.rgbParticle(entity.getColor());
                    if (entity.mode == BrewCauldronBlockEntity.Mode.BREWING) {
                        if (entity.isBrewing) {
                            world.m_7106_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + fluidHeight), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                        } else if (entity.m_58904_().m_46467_() % 20L == 0L) {
                            world.m_7106_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + fluidHeight), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                        }
                    } else if (entity.mode == BrewCauldronBlockEntity.Mode.COMPLETED) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + fluidHeight), (double)pos.m_123343_() + 0.5, rgb[0], rgb[1], rgb[2]);
                    } else if (entity.mode == BrewCauldronBlockEntity.Mode.FAILED) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + fluidHeight), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    }
                    world.m_7106_((ParticleOptions)ModParticleTypes.BREW_BUBBLE.get(), (double)pos.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)world.f_46441_, (double)(-width), (double)width), (double)((float)pos.m_123342_() + fluidHeight), (double)pos.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)world.f_46441_, (double)(-width), (double)width), rgb[0], rgb[1], rgb[2]);
                }
            }
        }
    }
}

